/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.util;

import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import miworkplace.common.model.IRemoteObject;

public class ObjectHelper {
    private static final int _30SECS = 30000;
    private static AS400JDBCDriver jdbcDriver = new AS400JDBCDriver();
    private static Map<String, Map<String, List<String>>> fSourceFileCache = new HashMap<String, Map<String, List<String>>>();
    private static long fLastRequestTime;

    public static boolean isSourceFile(IRemoteObject file) throws Exception {
        if (file.getType() != IRemoteObject.Type.file) {
            return false;
        }
        List<String> sourcefiles = ObjectHelper.getSourceFilesFromShortLivedCache(file);
        return sourcefiles.contains(file.getName());
    }

    public static synchronized List<String> getSourceFilesFromShortLivedCache(IRemoteObject pFile) throws SQLException {
        List<String> sourceFiles;
        ObjectHelper.initCache();
        QSYSObjectPathName path = new QSYSObjectPathName(pFile.getPath());
        String system = pFile.getConnection().getName();
        Map<String, List<String>> libraries = fSourceFileCache.get(system);
        if (libraries == null) {
            libraries = new HashMap<String, List<String>>();
            fSourceFileCache.put(system, libraries);
        }
        if ((sourceFiles = libraries.get(path.getLibraryName())) == null) {
            sourceFiles = new ArrayList<String>(ObjectHelper.loadSourceFilesFromLibrary(pFile));
            libraries.put(path.getLibraryName(), sourceFiles);
        }
        return sourceFiles;
    }

    private static void initCache() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - fLastRequestTime > 30000L) {
            fSourceFileCache = new HashMap<String, Map<String, List<String>>>();
        }
        fLastRequestTime = currentTimeMillis;
    }

    public static List<String> loadSourceFilesFromLibrary(IRemoteObject pFile) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        QSYSObjectPathName path = new QSYSObjectPathName(pFile.getPath());
        Connection c = null;
        Statement statement = null;
        try {
            c = jdbcDriver.connect(pFile.getConnection().getSystem(), false);
            statement = c.prepareStatement("SELECT system_table_name FROM qsys2.systables WHERE file_type='S' and system_table_schema = ?");
            statement.setString(1, path.getLibraryName().toUpperCase());
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                result.add(resultSet.getString(1).trim());
            }
        }
        finally {
            if (statement != null && !statement.isClosed()) {
                statement.close();
            }
            if (c != null && !c.isClosed()) {
                c.close();
            }
        }
        return result;
    }

    public static boolean isSourceFileByApi(IRemoteObject file) {
        boolean sourceFile = false;
        AS400Bin4 intConv = new AS400Bin4();
        CharConverter charConv = null;
        try {
            charConv = new CharConverter(file.getConnection().getSystem().getCcsid(), file.getConnection().getSystem());
        }
        catch (Exception e) {
            throw new RuntimeException("Error during CharConverter building.", e);
        }
        QSYSObjectPathName path = new QSYSObjectPathName(file.getPath());
        ProgramCall program = new ProgramCall(file.getConnection().getSystem());
        String programName = "/QSYS.LIB/QDBRTVFD.PGM";
        ProgramParameter[] parameterList = new ProgramParameter[]{new ProgramParameter(400), new ProgramParameter(intConv.toBytes(400)), new ProgramParameter(20), new ProgramParameter(charConv.stringToByteArray("FILD0100")), new ProgramParameter(charConv.stringToByteArray(path.toQualifiedObjectName())), new ProgramParameter(charConv.stringToByteArray("*FIRST    ")), new ProgramParameter(charConv.stringToByteArray("0")), new ProgramParameter(charConv.stringToByteArray("*LCL      ")), new ProgramParameter(charConv.stringToByteArray("*EXT      ")), new ProgramParameter(260)};
        if (file.getConnection().isConnected()) {
            try {
                program.setProgram(programName, parameterList);
                if (!program.run()) {
                    AS400Message[] msgList = program.getMessageList();
                    StringBuilder as400ErrorMsg = new StringBuilder();
                    int j = 0;
                    while (j < msgList.length) {
                        as400ErrorMsg.append(msgList[j].getID() + " - " + msgList[j].getText() + " ");
                        ++j;
                    }
                    throw new RuntimeException("Could not retrieve file attributes (source/data) for file " + file.getName() + ": " + as400ErrorMsg.toString());
                }
                sourceFile = ObjectHelper.hasSourceFlag(parameterList[0].getOutputData()[8]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not retrieve file attributes (source/data) for file " + file.getName() + ".", e);
            }
        }
        return sourceFile;
    }

    private static boolean hasSourceFlag(byte flag) {
        boolean sourceFile = false;
        int SOURCE = 8;
        int res = flag & SOURCE;
        if (res == 8) {
            sourceFile = true;
        }
        return sourceFile;
    }
}

