/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.util;

import com.ibm.as400.access.AS400FileRecordDescription;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectList;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RecordFormat;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.services.api.IFileDescriptionService;
import miworkplace.services.files.FileDescription;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.log.LogService;

public class FileDescriptionLoader
extends Job {
    @Inject
    private IFileDescriptionService service;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private LogService logger;
    @Inject
    private IConnectionUtilities connUtilFacade;
    private final IConnection connection;
    private final String ifsPath;
    private String inputUri;

    @Inject
    public FileDescriptionLoader(IConnection connection, @Named(value="path") String ifsPath, @Named(value="inputUri") String inputUri) {
        super("Loading file description from " + ifsPath);
        this.connection = connection;
        this.ifsPath = ifsPath;
        this.inputUri = inputUri;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.logger.log(4, "Starting loading of file description for " + this.ifsPath);
        if (!this.connection.isConnected()) {
            this.logger.log(1, "Could not load file description for " + this.ifsPath + ". Connection not open.");
            return Status.CANCEL_STATUS;
        }
        if (!this.connUtilFacade.doesObjectExist(this.connection, this.ifsPath)) {
            return Status.CANCEL_STATUS;
        }
        try {
            String resolvedPath = this.resolveIfsPath(this.connection, this.ifsPath);
            AS400FileRecordDescription fd = new AS400FileRecordDescription(this.connection.getSystem(), resolvedPath);
            RecordFormat[] recordFormats = fd.retrieveRecordFormat();
            FileDescription fileDescription = new FileDescription(this.connection, this.ifsPath);
            fileDescription.addRecordFormats(recordFormats);
            this.service.addFileDescription(fileDescription);
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("org.eclipse.e4.data", fileDescription);
            ((Dictionary)properties).put("connection", this.connection);
            ((Dictionary)properties).put("path", this.ifsPath);
            ((Dictionary)properties).put("inputUri", this.inputUri);
            this.eventBroker.send("miworkplace/filedesc/loaded", properties);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            this.logger.log(1, "Could not retrieve record formats for " + this.ifsPath + ".", (Throwable)e);
            return Status.CANCEL_STATUS;
        }
    }

    private String resolveIfsPath(IConnection connection, String ifsPath) throws Exception {
        QSYSObjectPathName path = new QSYSObjectPathName(ifsPath);
        if (path.getLibraryName().equalsIgnoreCase("*libl")) {
            ObjectList list = new ObjectList(connection.getSystem(), "*LIBL", path.getObjectName(), "*" + path.getObjectType());
            list.load();
            Enumeration enumeration = list.getObjects();
            if (enumeration.hasMoreElements()) {
                ObjectDescription desc = (ObjectDescription)enumeration.nextElement();
                return desc.getPath();
            }
        }
        return ifsPath;
    }
}

