/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.properties;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import miworkplace.services.api.ObjectProperty;
import miworkplace.services.properties.PropertyValueMapping;

public class ObjectPropertyValueMapper {
    private static final Map<ObjectProperty, List<PropertyValueMapping>> map = new HashMap<ObjectProperty, List<PropertyValueMapping>>();

    static {
        map.put(ObjectProperty.journalimages, Arrays.asList(new PropertyValueMapping(Boolean.FALSE, "only after images"), new PropertyValueMapping(Boolean.TRUE, "before and after images"), new PropertyValueMapping(null, "object is not journaled")));
        map.put(ObjectProperty.journalstatus, Arrays.asList(new PropertyValueMapping(Boolean.TRUE, "object is journaled"), new PropertyValueMapping(Boolean.FALSE, "object is not journaled")));
        map.put(ObjectProperty.journalomittedentries, Arrays.asList(new PropertyValueMapping(Boolean.TRUE, "open and close operations are omitted"), new PropertyValueMapping(Boolean.FALSE, "no entries are omitted"), new PropertyValueMapping(null, "object is not journaled")));
        map.put(ObjectProperty.auditing, Arrays.asList(new PropertyValueMapping("*NOTAVL", "not available")));
        map.put(ObjectProperty.compression, Arrays.asList(new PropertyValueMapping("Y", "compressed"), new PropertyValueMapping("N", "permanently decompressed and compressible"), new PropertyValueMapping("X", "permanently decompressed and not compressible"), new PropertyValueMapping("T", "temporarily decompressed"), new PropertyValueMapping("F", "compression status cannot be determined")));
        map.put(ObjectProperty.domain, Arrays.asList(new PropertyValueMapping("*U", "user domain"), new PropertyValueMapping("*S", "system domain")));
    }

    public Object map(ObjectProperty property, Object value) {
        if (map.containsKey((Object)property)) {
            for (PropertyValueMapping mapping : map.get((Object)property)) {
                if (!mapping.getValue().equals(value)) continue;
                return mapping.getMappedValue();
            }
            return value;
        }
        return value;
    }
}

