/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.lock;

import com.ibm.as400.access.QSYSObjectPathName;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.services.api.ILock;
import miworkplace.services.lock.AbstractLock;

public class MemberLock
extends AbstractLock {
    Debug logger = Debug.getInstance();

    public MemberLock(IConnection pConnection, String pPath) {
        super(pConnection, pPath);
    }

    @Override
    public ILock lock(IConnectionUtilities pUtil) throws Exception {
        this.logger.traceEntry((Option)miworkplace.services.debug.Option.locking, new Object[]{"MemberLock::allocate. Start " + this.getResourcePath()});
        this.logger.debug((Option)miworkplace.services.debug.Option.locking, "MemberLock::allocate  Allocating " + this.getResourcePath());
        try {
            QSYSObjectPathName ifsPath = new QSYSObjectPathName(this.getResourcePath());
            String command = "ALCOBJ OBJ((" + ifsPath.getLibraryName() + "/" + ifsPath.getObjectName() + " *FILE  *EXCLRD " + ifsPath.getMemberName() + ")) WAIT(1)";
            pUtil.executeRemoteCommand(this.getConnection(), command);
            this.logger.debug((Option)miworkplace.services.debug.Option.locking, "MemberLock::allocate  Allocated " + this.getResourcePath());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new Exception("Could not acquire lock on member " + this.getResourcePath() + ".", e);
        }
        this.logger.traceExit((Option)miworkplace.services.debug.Option.locking, (Object)("MemberLock::allocate. Stop " + this.getResourcePath()));
        return this;
    }

    @Override
    public ILock unlock(IConnectionUtilities pUtil) throws Exception {
        try {
            QSYSObjectPathName ifsPath = new QSYSObjectPathName(this.getResourcePath());
            String command = "DLCOBJ OBJ((" + ifsPath.getLibraryName() + "/" + ifsPath.getObjectName() + " *FILE  *EXCLRD " + ifsPath.getMemberName() + "))";
            pUtil.executeRemoteCommand(this.getConnection(), command);
        }
        catch (Exception exception) {
            Exception exception2 = new Exception("Could not release lock on member " + this.getResourcePath() + ".");
            this.logger.error(exception2.getMessage(), (Throwable)exception2);
            throw exception2;
        }
        return this;
    }
}

