/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.services.api.CompileSettings;
import miworkplace.services.api.ICompileSettings;
import miworkplace.services.api.ICompileSettingsProvider;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CompileSettingsProvider
implements ICompileSettingsProvider {
    private static final String DEFAULT = "miworkplace.ui.editor.compiler.rpgpgm";
    private List<ICompileSettings> settings = new ArrayList<ICompileSettings>();
    private List<ICompileSettings> fDefaultsettings = new ArrayList<ICompileSettings>();
    private Debug logger = Debug.getInstance();
    private IEclipsePreferences fCompilePreferences;
    private PreferenceChangeListener preferenceChangeListener = new PreferenceChangeListener();

    public CompileSettingsProvider() {
        this.init();
    }

    private void init() {
        CompileSettings cs = new CompileSettings().setId("miworkplace.ui.editor.compiler.srvpgm").setName("Service Program").setCompileCommand("CRTSRVPGM").setArguments("SRVPGM(${object_library}/${name})");
        this.add(cs);
        cs = new CompileSettings().setId("miworkplace.ui.editor.compiler.cmd").setName("Command").setCompileCommand("CRTCMD").setArguments("CMD(${object_library}/${name}) SRCFILE(${library}/${fileName}) SRCMBR(${name}) PGM(${name}) OPTION(*EVENTF) ").addDefaultSourceType("cmd");
        this.add(cs);
        cs = new CompileSettings().setId("miworkplace.ui.editor.compiler.cmd.ifs").setName("Command (Stream File)").setCompileCommand("CRTCMD").setArguments("CMD(${object_library}/${basename}) SRCSTMF('${ifspath}') PGM(${basename}) OPTION(*EVENTF)").setIfsSetting(Boolean.TRUE).addDefaultSourceType("cmd");
        this.add(cs);
    }

    @Override
    public void add(ICompileSettings compileSettings) {
        this.settings.add(compileSettings);
        this.updateCompileSettings(compileSettings.getId());
        this.fDefaultsettings.add(new CompileSettings(compileSettings));
    }

    @Override
    public List<ICompileSettings> list() {
        return Collections.unmodifiableList(this.settings);
    }

    @Override
    public IEclipsePreferences getPreferences() {
        return this.fCompilePreferences;
    }

    private void updateCompileSettings() {
        for (ICompileSettings cs : this.settings) {
            this.updateCompileSettings(cs.getId());
        }
    }

    private void updateCompileSettings(String id) {
        if (this.fCompilePreferences == null) {
            this.logger.debug((Option)miworkplace.services.debug.Option.prefs, "Preferences not set yet. Cannot store persisted values for compile settings " + id);
            return;
        }
        ICompileSettings cs = this.get(id);
        if (cs == null) {
            this.logger.debug((Option)miworkplace.services.debug.Option.prefs, "Could not update compile settings for id " + id + ". Compile settings not found");
        } else {
            Preferences node = this.fCompilePreferences.node(id);
            if (!node.get("name", "").trim().isEmpty()) {
                cs.setName(node.get("name", ""));
                this.logger.debug((Option)miworkplace.services.debug.Option.prefs, "Compile settings name " + id + " updated");
            }
            if (!node.get("ifs", "").trim().isEmpty()) {
                cs.setIfs(node.getBoolean("ifs", false));
                this.logger.debug((Option)miworkplace.services.debug.Option.prefs, "Compile settings ifs " + id + " updated");
            }
            if (!node.get("command", "").trim().isEmpty()) {
                cs.setCompileCommand(node.get("command", ""));
                this.logger.debug((Option)miworkplace.services.debug.Option.prefs, "Compile settings command " + id + " updated");
            }
            if (!node.get("arguments", "").trim().isEmpty()) {
                cs.setArguments(node.get("arguments", ""));
                this.logger.debug((Option)miworkplace.services.debug.Option.prefs, "Compile settings arguments " + id + " updated");
            }
            if (!node.get("suffix", "").trim().isEmpty()) {
                cs.setDefaultSourceTypes(Arrays.asList(node.get("suffix", "").split(",")));
                this.logger.debug((Option)miworkplace.services.debug.Option.prefs, "Compile settings suffixes " + node.get("suffix", "") + " updated");
            }
        }
    }

    @Override
    public ICompileSettings get(String id) {
        for (ICompileSettings cs : this.settings) {
            if (!cs.getId().equals(id)) continue;
            return cs;
        }
        return null;
    }

    @Override
    public ICompileSettings getDefault(IRemoteObject source) {
        String sourceType = this.resolveSourceType(source);
        sourceType = sourceType == null ? null : sourceType.toLowerCase();
        for (ICompileSettings cs : this.settings) {
            if (!cs.getDefaultSourceTypes().contains(sourceType)) continue;
            if (!(source instanceof StreamFile)) {
                return cs;
            }
            if (!cs.isIfsSetting()) continue;
            return cs;
        }
        return this.get(DEFAULT);
    }

    private String resolveSourceType(IRemoteObject sourceObject) {
        if (sourceObject instanceof SourceMember) {
            return ((SourceMember)sourceObject).getSourceType();
        }
        if (sourceObject instanceof StreamFile) {
            return FilenameUtils.getExtension((String)((StreamFile)sourceObject).getName());
        }
        return null;
    }

    @Override
    public void setPreferences(IEclipsePreferences preferences) {
        this.fCompilePreferences = preferences;
        this.addUserCommands();
        this.addPreferencesListener();
        this.updateCompileSettings();
    }

    private void addUserCommands() {
        try {
            String[] stringArray = this.fCompilePreferences.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.contains(".user.")) {
                    CompileSettings cs = new CompileSettings().setId(name);
                    this.add(cs);
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    private void addPreferencesListener() {
        this.getPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.preferenceChangeListener);
    }

    @Override
    public ICompileSettings create() {
        String id = null;
        while (this.get(id = "miworkplace.ui.editor.compiler.user." + (new Random().nextInt(10000) + 1000)) != null) {
        }
        CompileSettings settings = new CompileSettings();
        settings.setId(id);
        return settings;
    }

    @Override
    public void remove(String Id) {
        this.settings.remove(this.get(Id));
        this.fDefaultsettings.remove(this.get(Id));
        try {
            if (this.fCompilePreferences.nodeExists(Id)) {
                this.fCompilePreferences.node(Id).removeNode();
            }
        }
        catch (BackingStoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void restoreDefaults() {
        this.erasePreferences();
        ArrayList<ICompileSettings> temp = new ArrayList<ICompileSettings>(this.fDefaultsettings);
        this.settings.clear();
        this.fDefaultsettings.clear();
        temp.forEach(this::add);
    }

    private void erasePreferences() {
        try {
            for (ICompileSettings cs : this.settings) {
                if (cs.getId().contains(".user.") || !this.fCompilePreferences.nodeExists(cs.getId())) continue;
                Preferences node = this.fCompilePreferences.node(cs.getId());
                node.removeNode();
            }
            this.fCompilePreferences.flush();
        }
        catch (BackingStoreException e) {
            this.logger.error("Error erasing settings", (Throwable)e);
        }
    }

    class PreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        PreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (CompileSettingsProvider.this.get(event.getKey()) != null) {
                CompileSettingsProvider.this.updateCompileSettings(event.getKey());
            }
        }
    }
}

