/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.cl;

import jakarta.inject.Inject;
import miworkplace.ui.editor.DefaultSourceViewerConfiguration;
import miworkplace.ui.editor.ILEDocsCompletionProcessor;
import miworkplace.ui.editor.cl.text.ClPartitionTypes;
import miworkplace.ui.editor.cl.text.CommentLineScanner;
import miworkplace.ui.editor.cl.text.DefaultCompletionProcessor;
import miworkplace.ui.editor.cl.text.DefaultScanner;
import miworkplace.ui.editor.cl.text.IledocsLineScanner;
import miworkplace.ui.editor.cl.text.SourceModelReconcileStrategy;
import miworkplace.ui.themes.Colors;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;

public class ClSourceViewerConfiguration
extends DefaultSourceViewerConfiguration {
    @Inject
    private IEclipseContext context;
    private final SourceModelReconcileStrategy sourceModelReconcileStrategy;

    @Inject
    public ClSourceViewerConfiguration(SourceModelReconcileStrategy reconcileStrategy) {
        this.sourceModelReconcileStrategy = reconcileStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new DefaultScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)new CommentLineScanner());
        reconciler.setDamager((IPresentationDamager)dr, "singleComment_partition");
        reconciler.setRepairer((IPresentationRepairer)dr, "singleComment_partition");
        dr = new DefaultDamagerRepairer((ITokenScanner)new IledocsLineScanner());
        reconciler.setDamager((IPresentationDamager)dr, "iledocs_partition");
        reconciler.setRepairer((IPresentationRepairer)dr, "iledocs_partition");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant ca = new ContentAssistant();
        ca.enableColoredLabels(true);
        ca.enableAutoInsert(true);
        ca.setContentAssistProcessor((IContentAssistProcessor)ContextInjectionFactory.make(DefaultCompletionProcessor.class, (IEclipseContext)this.context), "__dftl_partition_content_type");
        ca.setContentAssistProcessor((IContentAssistProcessor)ContextInjectionFactory.make(ILEDocsCompletionProcessor.class, (IEclipseContext)this.context), "iledocs_partition");
        ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        ca.setProposalSelectorForeground(Colors.instance().get(Colors.ColorDefinition.DefaultFont));
        ca.setProposalSelectorBackground(Colors.instance().get(Colors.ColorDefinition.DefaultBackground));
        return ca;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new DefaultIndentLineAutoEditStrategy()};
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return ClPartitionTypes.PARTITION_TYPES;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return new MonoReconciler((IReconcilingStrategy)this.sourceModelReconcileStrategy, false);
    }
}

