/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ast.rpg.token.control;

import java.util.ArrayList;
import java.util.HashMap;
import miworkplace.ast.rpg.ControlParameters;
import miworkplace.ast.rpg.token.AbstractToken;
import miworkplace.ast.rpg.token.CharacterString;
import miworkplace.ast.rpg.token.Number;
import miworkplace.ast.rpg.token.Parenthesis;
import miworkplace.ast.rpg.token.UnknownToken;
import miworkplace.ast.rpg.token.control.Parameter;
import miworkplace.ast.rpg.token.control.ParameterSeparator;
import miworkplace.ast.rpg.tokenizer.Delimiter;
import miworkplace.ast.rpg.tokenizer.Token;

public class Keyword
extends AbstractToken {
    public static final HashMap<String, Keywords> keywords = new HashMap();
    private Keywords type = null;
    private boolean parameter = false;
    private boolean parameterOptional = false;
    private boolean multipleParameter = false;
    private boolean characterParameter = false;
    private boolean integerParameter = false;
    private boolean dateParameter = false;
    private boolean timeParameter = false;
    private ArrayList<Token> parameters = new ArrayList();

    static {
        keywords.put("ACTGRP", Keywords.ACTIVATION_GROUP);
        keywords.put("ALTSEQ", Keywords.ALTERNATE_COLLATING_SEQUENCE);
        keywords.put("ALWNULL", Keywords.ALLOW_NULL_VALUE);
        keywords.put("AUT", Keywords.AUTHORITY);
        keywords.put("BNDDIR", Keywords.BINDING_DIRECTORY);
        keywords.put("CCSID", Keywords.CCSID);
        keywords.put("COPYNEST", Keywords.COPY_NESTING_DEPTH);
        keywords.put("COPYRIGHT", Keywords.COPYRIGHT);
        keywords.put("CURSYM", Keywords.CURRENCY_SYMBOL);
        keywords.put("CVTOPT", Keywords.CONVERT_OPTION);
        keywords.put("DATEDIT", Keywords.DATE_EDIT_FORMAT);
        keywords.put("DATFMT", Keywords.DATE_FORMAT);
        keywords.put("DEBUG", Keywords.DEBUG);
        keywords.put("DECEDIT", Keywords.DECIMAL_EDIT_FORMAT);
        keywords.put("DECPREC", Keywords.DECIMAL_PRECISION);
        keywords.put("DFTACTGRP", Keywords.DEFAULT_ACTIVATION_GROUP);
        keywords.put("DFTNAME", Keywords.DEFAULT_NAME);
        keywords.put("ENBPFRCOL", Keywords.ENABLE_PERFORMANCE_COLLECTION);
        keywords.put("EXPROPTS", Keywords.EXPRESSION_OPTIONS);
        keywords.put("EXTBININT", Keywords.EXTERNAL_BINARY_FORMAT);
        keywords.put("FIXNBR", Keywords.FIX_DECIMAL_DATA);
        keywords.put("FLTDIV", Keywords.FLOATING_POINT_DIVISION);
        keywords.put("FORMSALIGN", Keywords.FORMS_ALIGNMENT);
        keywords.put("FTRANS", Keywords.FILE_TRANSLATION);
        keywords.put("GENLVL", Keywords.GENERATION_SEVERITY_LEVEL);
        keywords.put("INDENT", Keywords.INDENT);
        keywords.put("INTPREC", Keywords.INTEGER_PRECISION);
        keywords.put("LANGID", Keywords.LANGUAGE_ID);
        keywords.put("NOMAIN", Keywords.NO_MAIN_PROCEDURE);
        keywords.put("OPENOPT", Keywords.PRINTER_FILE_OPEN_OPTION);
        keywords.put("OPTIMIZE", Keywords.OPTIMIZE);
        keywords.put("OPTION", Keywords.OPTION);
        keywords.put("PRFDTA", Keywords.PROFILING_DATA);
        keywords.put("SRTSEQ", Keywords.SORT_SEQUENCE);
        keywords.put("TEXT", Keywords.TEXT);
        keywords.put("THREAD", Keywords.THREADING);
        keywords.put("TIMFMT", Keywords.TIME_FORMAT);
        keywords.put("TRUNCNBR", Keywords.TRUNCATE_NUMBER);
        keywords.put("USRPRF", Keywords.USER_PROFILE);
    }

    public Keyword(Token token) {
        super(token);
    }

    public Keywords getType() {
        return this.type;
    }

    public void setType(Keywords type) {
        this.type = type;
    }

    public boolean mayHaveParameter() {
        return this.parameter;
    }

    public void setMayHaveParameter(boolean value) {
        this.parameter = value;
    }

    public boolean isParameterOptional() {
        return this.parameterOptional;
    }

    public void setParameterOptional(boolean parameterOptional) {
        this.parameterOptional = parameterOptional;
    }

    public boolean acceptMultipleParameter() {
        return this.multipleParameter;
    }

    public void setMultipleParameter(boolean accept) {
        this.multipleParameter = accept;
    }

    public boolean acceptCharacterParameter() {
        return this.characterParameter;
    }

    public void setCharacterParameter(boolean accept) {
        this.characterParameter = accept;
    }

    public boolean acceptIntegerParameter() {
        return this.integerParameter;
    }

    public void setIntegerParameter(boolean accept) {
        this.integerParameter = accept;
    }

    public boolean acceptDateParameter() {
        return this.dateParameter;
    }

    public void setDateParameter(boolean accept) {
        this.dateParameter = accept;
    }

    public boolean acceptTimeParameter() {
        return this.timeParameter;
    }

    public void setTimeParameter(boolean accept) {
        this.timeParameter = accept;
    }

    public boolean hasParameter() {
        return this.parameters.size() > 0;
    }

    public Token getParameter(int position) {
        return this.parameters.get(position);
    }

    public Token[] getParameters() {
        return this.parameters.toArray(new Token[this.parameters.size()]);
    }

    public boolean isOk() {
        if (this.parameter && !this.parameterOptional && this.parameters.size() == 0) {
            return false;
        }
        if (!this.parameter && this.children.size() > 0) {
            return false;
        }
        if (this.parameter) {
            for (Token t : this.children) {
                if (t instanceof UnknownToken) {
                    return false;
                }
                if (t instanceof Parameter) {
                    Parameter p = (Parameter)t;
                    if (!(this.acceptDateParameter() ? !ControlParameters.dateformats.contains(p.getData().toUpperCase()) : (this.acceptTimeParameter() ? !ControlParameters.timeformats.contains(p.getData().toUpperCase()) : !ControlParameters.parameters.containsValue((Object)this.type, (Object)p.getData().toUpperCase())))) continue;
                    return false;
                }
                if (t instanceof CharacterString) {
                    if (this.acceptCharacterParameter()) continue;
                    return false;
                }
                if (t instanceof Number) {
                    if (this.acceptIntegerParameter()) continue;
                    return false;
                }
                if (t instanceof ParameterSeparator) {
                    if (this.acceptMultipleParameter()) continue;
                    return false;
                }
                if (t instanceof Parenthesis) {
                    if (this.parameter) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void addChildren(Token token) {
        super.addChildren(token);
        if (!(token instanceof Parenthesis) && !(token instanceof Delimiter)) {
            this.parameters.add(token);
        }
    }

    @Override
    public String toString() {
        return this.getData();
    }

    public static enum Keywords {
        ACTIVATION_GROUP("ACTGRP"),
        ALTERNATE_COLLATING_SEQUENCE("ALTSEQ"),
        ALLOW_NULL_VALUE("ALWNULL"),
        AUTHORITY("AUT"),
        BINDING_DIRECTORY("BNDDIR"),
        CCSID("CCSID"),
        COPY_NESTING_DEPTH("COPYNEST"),
        COPYRIGHT("COPYRIGHT"),
        CURRENCY_SYMBOL("CURSYM"),
        CONVERT_OPTION("CVTOPT"),
        DATE_EDIT_FORMAT("DATEDIT"),
        DATE_FORMAT("DATFMT"),
        DEBUG("DEBUG"),
        DECIMAL_EDIT_FORMAT("DECEDIT"),
        DECIMAL_PRECISION("DECPREC"),
        DEFAULT_ACTIVATION_GROUP("DFTACTGRP"),
        DEFAULT_NAME("DFTNAME"),
        ENABLE_PERFORMANCE_COLLECTION("ENBPFRCOL"),
        EXPRESSION_OPTIONS("EXPROPTS"),
        EXTERNAL_BINARY_FORMAT("EXTBININT"),
        FIX_DECIMAL_DATA("FIXNBR"),
        FLOATING_POINT_DIVISION("FLTDIV"),
        FORMS_ALIGNMENT("FORMSALIGN"),
        FILE_TRANSLATION("FTRANS"),
        GENERATION_SEVERITY_LEVEL("GENLVL"),
        INDENT("INDENT"),
        INTEGER_PRECISION("INTPREC"),
        LANGUAGE_ID("LANGID"),
        NO_MAIN_PROCEDURE("NOMAIN"),
        PRINTER_FILE_OPEN_OPTION("OPENOPT"),
        OPTIMIZE("OPTIMIZE"),
        OPTION("OPTION"),
        PROFILING_DATA("PRFDTA"),
        SORT_SEQUENCE("SRTSEQ"),
        TEXT("TEXT"),
        THREADING("THREAD"),
        TIME_FORMAT("TIMFMT"),
        TRUNCATE_NUMBER("TRUNCNBR"),
        USER_PROFILE("USRPRF");

        private final String keyword;

        private Keywords(String str) {
            this.keyword = str;
        }

        public String toString() {
            return this.keyword;
        }
    }
}

