/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ast.rpg.iledocs;

import java.util.ArrayList;
import java.util.List;
import miworkplace.ast.rpg.iledocs.ILEDocs;
import miworkplace.ast.rpg.iledocs.Link;
import miworkplace.ast.rpg.iledocs.Revision;
import miworkplace.ast.rpg.tokenizer.Token;

public class ILEDocsBuilder {
    public static ILEDocs build(Token[] tokens) {
        ILEDocs comment = new ILEDocs();
        comment.setStartLine(tokens[0].getLineNumber());
        comment.setEndLine(tokens[tokens.length - 1].getLineNumber());
        ILEDocs.Tag currentTag = null;
        int lineNumber = -1;
        boolean ignore = false;
        Token lastToken = null;
        ArrayList<Token> tagTokens = new ArrayList<Token>();
        StringBuilder content = new StringBuilder();
        Token[] tokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            Token token = tokenArray[n2];
            if (lineNumber != token.getLineNumber()) {
                ignore = false;
                if (ILEDocsBuilder.isKeyword(token.getData())) {
                    if (currentTag != null) {
                        ILEDocsBuilder.add(comment, currentTag, content.toString(), tagTokens);
                        currentTag = null;
                        content.setLength(0);
                        tagTokens.clear();
                    }
                    currentTag = ILEDocsBuilder.getTag(token.getData());
                } else if (token.getData().startsWith("\\")) {
                    ignore = true;
                    if (currentTag != null) {
                        ILEDocsBuilder.add(comment, currentTag, content.toString(), tagTokens);
                        currentTag = null;
                        content.setLength(0);
                        tagTokens.clear();
                    }
                } else if (currentTag != null && currentTag.getStyle() == ILEDocs.KeywordLineStyle.MULTI_LINE_STYLE) {
                    ILEDocsBuilder.addContent(content, token, lastToken);
                    tagTokens.add(lastToken);
                } else {
                    if (currentTag != null) {
                        ILEDocsBuilder.add(comment, currentTag, content.toString(), tagTokens);
                        currentTag = null;
                        content.setLength(0);
                        tagTokens.clear();
                    }
                    currentTag = ILEDocs.Tag.DESCRIPTION;
                    ILEDocsBuilder.addContent(content, token, lastToken);
                    tagTokens.add(lastToken);
                }
                lineNumber = token.getLineNumber();
            } else if (!ignore) {
                ILEDocsBuilder.addContent(content, token, lastToken);
                tagTokens.add(lastToken);
            }
            lastToken = token;
            ++n2;
        }
        if (currentTag != null) {
            ILEDocsBuilder.add(comment, currentTag, content.toString(), tagTokens);
        }
        return comment;
    }

    private static void addContent(StringBuilder content, Token token, Token lastToken) {
        if (token.getData().length() == 1 && " ():.;'".contains(token.getData())) {
            if (lastToken.getLineNumber() != token.getLineNumber()) {
                content.append(" ");
            } else if (token.getPosition() > lastToken.getData().length() + lastToken.getPosition()) {
                content.append(" ");
            }
        } else if (lastToken != null && lastToken.getData().length() == 1 && " ():.;'".contains(lastToken.getData())) {
            if (lastToken.getLineNumber() != token.getLineNumber()) {
                content.append(" ");
            } else if (token.getPosition() > lastToken.getData().length() + lastToken.getPosition()) {
                content.append(" ");
            }
        } else if (content.length() > 0) {
            content.append(" ");
        }
        content.append(token.getData());
    }

    private static boolean isKeyword(String token) {
        ILEDocs.Tag[] tagArray = ILEDocs.Tag.values();
        int n = tagArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILEDocs.Tag tag = tagArray[n2];
            if (tag.getKeyword().equals(token)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static ILEDocs.Tag getTag(String token) {
        ILEDocs.Tag[] tagArray = ILEDocs.Tag.values();
        int n = tagArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILEDocs.Tag tag = tagArray[n2];
            if (tag.getKeyword().equals(token)) {
                return tag;
            }
            ++n2;
        }
        return null;
    }

    private static void add(ILEDocs iledocs, ILEDocs.Tag tag, Object content, List<Token> tagTokens) {
        switch (tag) {
            case DESCRIPTION: {
                iledocs.setDescription(content.toString());
                break;
            }
            case AUTHOR: {
                iledocs.setAuthor(content.toString());
                break;
            }
            case DATE: {
                iledocs.setDate(content.toString());
                break;
            }
            case LINK: {
                String[] parts = content.toString().split(" ", 2);
                if (parts.length == 1) {
                    iledocs.addLink(new Link(parts[0]));
                    break;
                }
                if (parts.length != 2) break;
                iledocs.addLink(new Link(parts[0], parts[1]));
                break;
            }
            case INFO: {
                iledocs.addInfo(content.toString());
                break;
            }
            case WARNING: {
                iledocs.addWarning(content.toString());
                break;
            }
            case BRIEF: {
                iledocs.setBriefDescription(content.toString());
                break;
            }
            case CRITICAL: {
                iledocs.setCritical(true);
                break;
            }
            case DEPRECATED: {
                iledocs.setDeprecated(content.toString());
                break;
            }
            case PARAMETER: {
                iledocs.addParameterDescription(content.toString());
                break;
            }
            case RETURN: {
                iledocs.setReturnValueDescription(content.toString());
                break;
            }
            case REVISION: {
                Revision rev = ILEDocsBuilder.buildRevision(content, tagTokens);
                if (rev == null) break;
                iledocs.addRevision(rev);
                break;
            }
            case PROJECT: {
                iledocs.setProject(content.toString());
            }
            case TASK: {
                iledocs.setTask(content.toString());
            }
        }
    }

    private static Revision buildRevision(Object data, List<Token> tagTokens) {
        Revision rev = new Revision();
        String content = data.toString();
        if (tagTokens == null || tagTokens.isEmpty()) {
            return null;
        }
        Token lastTokenOfFirstLine = ILEDocsBuilder.retrieveLastTokenOfFirstLine(tagTokens);
        if (lastTokenOfFirstLine == null) {
            return null;
        }
        int firstLineEnd = content.indexOf(lastTokenOfFirstLine.getData()) + lastTokenOfFirstLine.getData().length();
        String firstLine = firstLineEnd == content.length() ? content : content.substring(0, firstLineEnd);
        String revisionDescription = firstLineEnd == content.length() ? null : content.substring(firstLineEnd);
        String[] revHead = firstLine.split(" ", 2);
        if (revHead.length == 1) {
            rev.setDate(revHead[0]);
        } else if (revHead.length == 2) {
            rev.setDate(revHead[0]);
            rev.setAuthor(revHead[1]);
        }
        rev.setDescription(revisionDescription);
        return rev;
    }

    private static Token retrieveLastTokenOfFirstLine(List<Token> tagTokens) {
        int lineNumber = tagTokens.get(0).getLineNumber();
        Token lastToken = null;
        for (Token token : tagTokens) {
            if (token.getLineNumber() != lineNumber) break;
            lastToken = token;
        }
        return lastToken;
    }
}

