/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.text;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.Map;
import miworkplace.ast.rpg.AST;
import miworkplace.ast.rpg.ASTBuilder;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.text.RpgSyntaxTypeChecker;
import miworkplace.ui.editor.IIncludePathResolver;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.Include;
import miworkplace.ui.editor.rpg.ast.Parser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.osgi.service.log.LogService;

public class SourceModelReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IDocument document;
    @Inject
    @Named(value="inputUri")
    private String inputUri;
    @Inject
    @Named(value="memberPath")
    private String ifsPath;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IIncludePathResolver pathResolver;
    @Inject
    @Named(value="resolvedIncludePaths")
    private Map<String, String> resolvedPaths = new HashMap<String, String>();
    private LogService logger;
    private Parser parser = new Parser();
    private String connectionName;

    @PostConstruct
    public void postConstruct(LogService logger) {
        this.logger = logger;
        this.connectionName = EditorInputUriUtil.getConnectionName((String)this.inputUri);
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion region) {
    }

    public void reconcile(IRegion region) {
        this.buildAst();
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void initialReconcile() {
        this.buildAst();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    private void buildAst() {
        this.logger.log(4, "Building AST for " + this.ifsPath);
        AST ast = null;
        String content = this.document.get();
        try {
            if (RpgSyntaxTypeChecker.isFullFree((String)content)) {
                ast = this.parser.parse(content);
                this.setQualifiedIncludePaths((Ast)ast);
            } else {
                ast = ASTBuilder.buildAST((String)content);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("org.eclipse.e4.data", ast);
            data.put("memberPath", this.ifsPath);
            data.put("inputUri", this.inputUri);
            data.put("content", content);
            this.eventBroker.post("miworkplace/editor/reconciled", data);
            this.logger.log(4, "Finsihed AST for " + this.ifsPath);
        }
        catch (Exception e) {
            this.logger.log(1, "Could not build AST for " + this.ifsPath + ". Error: " + e.getMessage(), (Throwable)e);
        }
    }

    private void setQualifiedIncludePaths(Ast ast) {
        if (ast == null) {
            return;
        }
        for (Include include : ast.listIncludes()) {
            try {
                include.setQualifiedPath(this.resolveIncludePath(include));
            }
            catch (Exception e) {
                this.logger.log(1, "Could not resolve include path for " + include.getFileUnquoted(), (Throwable)e);
            }
        }
    }

    private String resolveIncludePath(Include include) throws Exception {
        String resolvedPath = this.resolvedPaths.get(include.getFileUnquoted());
        if (resolvedPath == null && (resolvedPath = this.pathResolver.resolvePath(include.getFileUnquoted(), this.connectionName, this.ifsPath)) != null) {
            this.resolvedPaths.put(include.getFileUnquoted(), resolvedPath);
        }
        return resolvedPath;
    }
}

