/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.handler;

import jakarta.inject.Inject;
import java.util.HashMap;
import miworkplace.ui.api.IEditor;
import miworkplace.ui.editor.AstProvider;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;

public class ClearCacheHandler {
    @Inject
    private IEventBroker eventBroker;

    @Execute
    public void execute(MPart part) {
        Object partObject = part.getObject();
        if (partObject == null || !(partObject instanceof IEditor) && partObject instanceof AstProvider) {
            return;
        }
        AstProvider astProvider = (AstProvider)partObject;
        IEditor editor = (IEditor)partObject;
        String inputUri = editor.getInputUri();
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        eventMap.put("org.eclipse.e4.data", inputUri);
        if (astProvider.getAst() != null) {
            eventMap.put("ast", astProvider.getAst());
        }
        this.eventBroker.send("miworkplace/editor/cache/clear", eventMap);
    }
}

