/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.free;

import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RecordFormat;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.services.api.IFileDescription;
import miworkplace.services.api.IFileDescriptionService;
import miworkplace.services.util.FileDescriptionLoader;
import miworkplace.ui.editor.rpg.OutlineCategories;
import miworkplace.ui.editor.rpg.ast.AbstractVariable;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.Constant;
import miworkplace.ui.editor.rpg.ast.DataStructure;
import miworkplace.ui.editor.rpg.ast.Element;
import miworkplace.ui.editor.rpg.ast.File;
import miworkplace.ui.editor.rpg.ast.Include;
import miworkplace.ui.editor.rpg.ast.Module;
import miworkplace.ui.editor.rpg.ast.Procedure;
import miworkplace.ui.editor.rpg.ast.Prototype;
import miworkplace.ui.editor.rpg.ast.Subroutine;
import miworkplace.ui.editor.rpg.free.FileDeclaration;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.osgi.service.event.Event;
import org.osgi.service.log.LogService;

public class OutlineContentProvider
implements ITreeContentProvider {
    @Inject
    private LogService logger;
    @Inject
    private IEclipseContext context;
    @Inject
    private IFileDescriptionService fileDescriptionService;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private UISynchronize sync;
    @Inject
    @Named(value="inputUri")
    private String inputUri;
    @Inject
    @Optional
    @Named(value="pepLine")
    private Integer pepline;
    private final Object[] nullElements = new Object[0];
    private Map<File, FileDeclaration> files = new HashMap<File, FileDeclaration>();
    private Ast ast;
    private TreeViewer viewer;
    private OutlineCategories[] categories;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof Ast) {
            this.files.clear();
            this.viewer = (TreeViewer)viewer;
            this.ast = (Ast)newInput;
            this.categories = this.composeCategories(this.ast);
            this.buildFileDeclarations(this.ast, this.files);
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Module) {
            return this.categories;
        }
        if (parentElement == OutlineCategories.Constants) {
            List constants = this.ast.listConstants();
            return constants.toArray(new Constant[constants.size()]);
        }
        if (parentElement == OutlineCategories.Files) {
            List files = this.ast.listFiles();
            return files.toArray(new File[files.size()]);
        }
        if (parentElement == OutlineCategories.Includes) {
            List includes = this.ast.listIncludes();
            return includes.toArray(new Include[includes.size()]);
        }
        if (parentElement == OutlineCategories.Procedures) {
            List procedures = ((Module)this.ast).listProcedures();
            return procedures.toArray(new Procedure[procedures.size()]);
        }
        if (parentElement == OutlineCategories.Prototypes) {
            List prototypes = this.ast.listPrototypes();
            return (Element[])prototypes.toArray(new Prototype[prototypes.size()]);
        }
        if (parentElement == OutlineCategories.Subroutines) {
            List subroutines = this.ast.listSubroutines();
            return subroutines.toArray(new Subroutine[subroutines.size()]);
        }
        if (parentElement == OutlineCategories.Variables) {
            List listVariables = this.ast.listVariables();
            return listVariables.toArray(new AbstractVariable[listVariables.size()]);
        }
        if (parentElement instanceof DataStructure) {
            List subfields = ((DataStructure)parentElement).getSubfields();
            return subfields.toArray(new Object[subfields.size()]);
        }
        if (parentElement instanceof Subroutine) {
            return this.ast.getControlFlow().stream().filter(cf -> cf.getName().equals(((Subroutine)parentElement).getName())).collect(Collectors.toList()).toArray();
        }
        if (parentElement instanceof File) {
            FileDeclaration fd = this.files.get(parentElement);
            if (fd == null) {
                return this.nullElements;
            }
            List<RecordFormat> listRecordFormats = fd.listRecordFormats();
            return listRecordFormats.toArray(new RecordFormat[listRecordFormats.size()]);
        }
        if (parentElement instanceof RecordFormat) {
            RecordFormat recordFormat = (RecordFormat)parentElement;
            return recordFormat.getFieldDescriptions();
        }
        if (parentElement instanceof Procedure) {
            Procedure p = (Procedure)parentElement;
            ArrayList elements = new ArrayList();
            elements.addAll(p.listFiles());
            elements.addAll(p.listPrototypes());
            elements.addAll(p.listConstants());
            elements.addAll(p.listVariables());
            elements.addAll(p.listSubroutines());
            return elements.toArray(new Object[elements.size()]);
        }
        return this.nullElements;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof OutlineCategories) {
            return this.ast;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
    }

    private OutlineCategories[] composeCategories(Ast ast) {
        ArrayList<OutlineCategories> categories = new ArrayList<OutlineCategories>();
        if (ast instanceof Module && !((Module)ast).listProcedures().isEmpty()) {
            categories.add(OutlineCategories.Procedures);
        }
        if (!ast.listPrototypes().isEmpty()) {
            categories.add(OutlineCategories.Prototypes);
        }
        if (!ast.listConstants().isEmpty()) {
            categories.add(OutlineCategories.Constants);
        }
        if (!ast.listSubroutines().isEmpty()) {
            categories.add(OutlineCategories.Subroutines);
        }
        if (!ast.listVariables().isEmpty()) {
            categories.add(OutlineCategories.Variables);
        }
        if (!ast.listFiles().isEmpty()) {
            categories.add(OutlineCategories.Files);
        }
        if (!ast.listIncludes().isEmpty()) {
            categories.add(OutlineCategories.Includes);
        }
        if (this.pepline != null) {
            categories.add(OutlineCategories.PEP);
        }
        return categories.toArray(new OutlineCategories[categories.size()]);
    }

    @Inject
    @Optional
    public void notifiedFileDescriptionLoaded(@UIEventTopic(value="miworkplace/filedesc/loaded") Event event) {
        String eventInputUri = event.getProperty("inputUri").toString();
        String eventIfsPath = event.getProperty("path").toString();
        IFileDescription fd = (IFileDescription)event.getProperty("org.eclipse.e4.data");
        this.logger.log(4, "Loaded file descriptions for " + eventIfsPath);
        if (this.inputUri.equals(eventInputUri)) {
            List files = this.ast.listFiles();
            for (File file : files) {
                String ifsPath = null;
                try {
                    ifsPath = QSYSObjectPathName.toPath((String)file.getExternalDescriptionLibrary(), (String)file.getExternalDescriptionFile(), (String)"FILE");
                }
                catch (Exception exception) {
                    continue;
                }
                if (!ifsPath.equals(eventIfsPath)) continue;
                FileDeclaration fileDeclaration = new FileDeclaration(file);
                List recordFormats = fd.getRecordFormats();
                List includedRecordFormats = file.getIncludedRecordFormats();
                List ignoredRecordFormats = file.getIgnoredRecordFormats();
                for (RecordFormat recordFormat : recordFormats) {
                    if (!includedRecordFormats.isEmpty()) {
                        if (!includedRecordFormats.contains(recordFormat.getName())) continue;
                        fileDeclaration.addRecordFormat(recordFormat);
                        continue;
                    }
                    if (!ignoredRecordFormats.isEmpty()) {
                        if (ignoredRecordFormats.contains(recordFormat.getName())) continue;
                        fileDeclaration.addRecordFormat(recordFormat);
                        continue;
                    }
                    fileDeclaration.addRecordFormat(recordFormat);
                }
                this.files.put(file, fileDeclaration);
            }
            this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    OutlineContentProvider.this.viewer.refresh((Object)OutlineCategories.Files, true);
                }
            });
        }
    }

    @Inject
    @Optional
    public void notifiedRefresh(@UIEventTopic(value="miworkplace/ui/outline/refresh") Event event) {
        String connectionName = EditorInputUriUtil.getConnectionName((String)this.inputUri);
        IConnection connection = this.connectionManager.get(connectionName);
        for (File file : this.ast.listFiles()) {
            String ifsPath = QSYSObjectPathName.toPath((String)file.getExternalDescriptionLibrary(), (String)file.getExternalDescriptionFile(), (String)"FILE");
            this.fileDescriptionService.clearFileDescription(connection, ifsPath);
        }
        this.files.clear();
        this.buildFileDeclarations(this.ast, this.files);
        this.viewer.refresh();
    }

    private void buildFileDeclarations(Ast ast, Map<File, FileDeclaration> files) {
        String connectionName = EditorInputUriUtil.getConnectionName((String)this.inputUri);
        IConnection connection = this.connectionManager.get(connectionName);
        for (File file : ast.listFiles()) {
            String ifsPath = null;
            try {
                ifsPath = QSYSObjectPathName.toPath((String)file.getExternalDescriptionLibrary(), (String)file.getExternalDescriptionFile(), (String)"FILE");
            }
            catch (Exception exception) {
                continue;
            }
            IFileDescription fd = this.fileDescriptionService.getFileDescription(connection, ifsPath);
            if (fd == null) {
                IEclipseContext childContext = this.context.createChild();
                childContext.set(IConnection.class, (Object)connection);
                childContext.set("path", (Object)ifsPath);
                childContext.set("inputUri", (Object)this.inputUri);
                FileDescriptionLoader loader = (FileDescriptionLoader)ContextInjectionFactory.make(FileDescriptionLoader.class, (IEclipseContext)childContext);
                loader.schedule();
                continue;
            }
            FileDeclaration fileDeclaration = new FileDeclaration(file);
            List recordFormats = fd.getRecordFormats();
            List includedRecordFormats = file.getIncludedRecordFormats();
            List ignoredRecordFormats = file.getIgnoredRecordFormats();
            for (RecordFormat recordFormat : recordFormats) {
                if (!includedRecordFormats.isEmpty()) {
                    if (!includedRecordFormats.contains(recordFormat.getName())) continue;
                    fileDeclaration.addRecordFormat(recordFormat);
                    continue;
                }
                if (!ignoredRecordFormats.isEmpty()) {
                    if (ignoredRecordFormats.contains(recordFormat.getName())) continue;
                    fileDeclaration.addRecordFormat(recordFormat);
                    continue;
                }
                fileDeclaration.addRecordFormat(recordFormat);
            }
            files.put(file, fileDeclaration);
        }
    }
}

