/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg.free;

import java.util.List;
import java.util.ListIterator;
import miworkplace.services.api.Index;
import miworkplace.services.api.IndexStore;
import miworkplace.services.api.Indexer;
import miworkplace.ui.editor.rpg.ast.Ast;
import miworkplace.ui.editor.rpg.ast.Module;
import miworkplace.ui.editor.rpg.ast.Procedure;
import miworkplace.ui.editor.rpg.ast.Statement;
import miworkplace.ui.editor.rpg.ast.Token;

public class FreeRpgIndexer
implements Indexer {
    private IndexStore store;

    public void bindIndexStore(IndexStore store) {
        this.store = store;
        store.register((Indexer)this);
    }

    public void unbindIndexStore(IndexStore store) {
        store.deregister((Indexer)this);
        this.store = null;
    }

    public boolean supportsIndexSource(Object indexSource) {
        if (indexSource == null) {
            return false;
        }
        return indexSource instanceof Ast;
    }

    public void index(String connectionName, String ifsPath, Object indexSource) {
        Ast ast = (Ast)indexSource;
        Index index = new Index();
        this.internal_index(ast, index);
        this.store.add(connectionName, ifsPath, index);
    }

    private void internal_index(Ast ast, Index index) {
        List statements = ast.getStatements();
        for (Statement statement : statements) {
            if (statement.startsWith("//") || statement.startsWith("dcl-")) continue;
            if (statement.startsWith("dcl-proc")) break;
            List tokens = statement.list();
            for (Token token : tokens) {
                Object symbol = ast.getSymbol(token.value);
                if (symbol == null) {
                    symbol = ast.getSymbol(token.value);
                }
                if (symbol == null) continue;
                index.add(token.offset, token.value.length(), (Object)token);
            }
        }
        if (ast instanceof Module) {
            Module module = (Module)ast;
            List procedures = module.listProcedures();
            for (Procedure procedure : procedures) {
                ListIterator iter = procedure.getStatements().listIterator();
                if (iter.hasNext()) {
                    iter.next();
                }
                while (iter.hasNext()) {
                    List tokens = ((Statement)iter.next()).list();
                    for (Token token : tokens) {
                        index.add(token.offset, token.value.length(), (Object)token);
                    }
                }
            }
        }
    }
}

