/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg;

import java.text.MessageFormat;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.LineType;
import miworkplace.ui.editor.FormatLine;
import miworkplace.ui.editor.FormatLineListener;
import miworkplace.ui.editor.FormatLineProvider;
import miworkplace.ui.editor.ISourceViewerExtension;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class RpgFormatLineListener
extends FormatLineListener {
    private static final String FREE = "**FREE";
    private FormatLine formatLine;
    private ISourceViewerExtension editorExtension;
    private Debug logger = Debug.getInstance();
    private FormatLineProvider formatLineProvider;

    public RpgFormatLineListener(ISourceViewerExtension editorExtension, FormatLineProvider formatLineProvider, FormatLine formatLine) {
        this.editorExtension = editorExtension;
        this.formatLineProvider = formatLineProvider;
        this.formatLine = formatLine;
    }

    public void updateFormatLine() {
        if (this.isFreeRpg(this.editorExtension.getDocument())) {
            if (this.formatLine.isVisible()) {
                this.formatLine.setVisible(false);
            }
            return;
        }
        if (!this.formatLine.isVisible()) {
            this.formatLine.setVisible(true);
        }
        if (this.editorExtension.getSelectionProvider() == null || this.editorExtension.getSelectionProvider().getSelection() == null) {
            return;
        }
        ISelection selection = this.editorExtension.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            AbstractDocument document = (AbstractDocument)this.editorExtension.getDocument();
            try {
                int lineOffset = document.getLineOffset(textSelection.getStartLine());
                int relativePosition = textSelection.getOffset() - lineOffset;
                this.formatLine.updateFormatLabel(this.formatLineProvider.getFormatLine(this.determineLineType(document.get(lineOffset, document.getLineLength(textSelection.getStartLine())))), relativePosition);
            }
            catch (BadLocationException e) {
                this.logger.error(MessageFormat.format("Could not update formate line for line {0}. Error: {1}", textSelection.getStartLine(), e.getMessage()), (Throwable)e);
            }
        }
    }

    private boolean isFreeRpg(IDocument document) {
        if (document == null) {
            return false;
        }
        return StringUtils.startsWithIgnoreCase((CharSequence)document.get(), (CharSequence)FREE);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.updateFormatLine();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.updateFormatLine();
    }

    public void mouseUp(MouseEvent e) {
    }

    private LineType determineLineType(String line) {
        String lineCAPS = line.toUpperCase();
        LineType type = LineType.Empty;
        type = line.length() < 6 ? LineType.Empty : (line.length() >= 8 && line.substring(5, 8).equals("/**") ? LineType.IledocsStart : (line.length() >= 8 && line.substring(6, 8).equals("*/") ? LineType.IledocsEnd : (line.length() >= 7 && line.charAt(6) == '*' ? LineType.Comment : (line.length() >= 6 && line.charAt(5) == ' ' && line.substring(6).trim().startsWith("//") ? LineType.Comment : (line.length() >= 6 && lineCAPS.charAt(5) == 'H' ? LineType.Header : (line.length() >= 6 && lineCAPS.charAt(5) == 'F' ? LineType.File : (line.length() >= 6 && lineCAPS.charAt(5) == 'D' ? LineType.Declaration : (line.length() >= 6 && lineCAPS.charAt(5) == 'I' ? LineType.Input : (line.length() >= 6 && lineCAPS.charAt(5) == 'O' ? LineType.Output : (line.length() >= 6 && lineCAPS.charAt(5) == 'P' ? LineType.Procedure : (line.length() >= 6 && lineCAPS.charAt(5) == 'C' ? LineType.Calculation : (line.length() >= 11 && lineCAPS.substring(6, 11).equals("/COPY") ? LineType.Copy : (line.length() >= 14 && lineCAPS.substring(6, 14).equals("/INCLUDE") ? LineType.Include : (line.length() >= 11 && lineCAPS.substring(6, 11).equals("/FREE") ? LineType.FreeFormStart : (line.length() >= 15 && lineCAPS.substring(6, 15).equals("/END-FREE") ? LineType.FreeFormEnd : (line.length() >= 8 && line.substring(5, 7).equals(" /") && line.charAt(7) != '/' ? LineType.CompilerDirective : LineType.Empty))))))))))))))));
        return type;
    }
}

