/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.rpg;

import java.util.HashMap;
import miworkplace.common.model.LineType;
import miworkplace.services.util.LineTypeMapper;
import miworkplace.ui.api.Position;
import miworkplace.ui.editor.AstProvider;
import miworkplace.ui.editor.CursorPositionChangedListener;
import miworkplace.ui.editor.rpg.ast.Ast;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Point;

public class RpgCursorPositionChangedListener
extends CursorPositionChangedListener {
    private AstProvider astProvider;

    public RpgCursorPositionChangedListener(IEventBroker eventBroker, ITextViewer viewer, AstProvider astProvider) {
        super(eventBroker, viewer);
        this.astProvider = astProvider;
    }

    public void sendPositionUpdate() {
        Position position = this.getCurrentPosition();
        if (position != null) {
            LineType lineType = this.getLineType(this.viewer);
            if (lineType == null) {
                this.eventBroker.post("miworkplace/ui/editor/position/changed", (Object)position);
            } else {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("org.eclipse.e4.data", position);
                data.put("linetype", lineType);
                data.put("free", this.astProvider.getAst() == null || this.astProvider.getAst() instanceof Ast ? Boolean.TRUE : Boolean.FALSE);
                this.eventBroker.post("miworkplace/ui/editor/position/changed", data);
            }
        }
    }

    private LineType getLineType(ITextViewer viewer) {
        block6: {
            String line;
            block7: {
                if (this.astProvider.getAst() == null) {
                    return null;
                }
                if (this.astProvider.getAst() instanceof Ast) {
                    return null;
                }
                Point selection = viewer.getSelectedRange();
                if (selection == null) break block6;
                int x = selection.x;
                int lineNumber = viewer.getDocument().getLineOfOffset(x);
                line = viewer.getTextWidget().getLine(lineNumber);
                if (line.length() >= 6) break block7;
                return null;
            }
            try {
                if (line.length() >= 7 && line.charAt(6) == '*') {
                    return LineType.Comment;
                }
                return LineTypeMapper.getLineType((String)line.substring(5, 6).toUpperCase());
            }
            catch (Exception e) {
                this.logger.error("Could not determine line type.", (Throwable)e);
            }
        }
        return null;
    }
}

