/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.unix.dialog;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.dialog.TokenEditorDialog;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.util.DebugWindow;
import com.ibm.iseries.debug.util.DialogTabPanel;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.accessibility.Accessible;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class UnixStartDebugOptionsPage
extends DialogTabPanel
implements DebugConstants,
ActionListener,
FocusListener {
    private static final String SRCPATH = "srcpath";
    private static final String HOST_BUTTON = "host";
    private static final String CLIENT_BUTTON = "client";
    private static final String PLUGIN_LOAD_BUTTON = "plgload";
    private static final String PLUGIN_PATH_BUTTON = "plgpath";
    private static final String USER_KEY_FLAG = "*";
    private static final int TEXT_FIELD_WIDTH = 25;
    private static final int HOST_PATH = 0;
    private static final int CLIENT_PATH = 1;
    private static final int PLUGIN_LOAD = 2;
    private static final int PLUGIN_PATH = 3;
    private JTabbedPane m_parent;
    private Settings m_userCfg;
    private Settings m_userAliases;
    private JPanel m_panel;
    private JPanel m_boxPanel;
    private JPanel m_ctrlPanel;
    private JTextField m_hostSrcPathCtrl;
    private JTextField m_clientSrcPathCtrl;
    private JTextField m_pluginLoadCtrl;
    private JTextField m_pluginPathCtrl;
    private JComboBox m_multiProcCtrl;
    private JComboBox m_breakBehaviorCtrl;
    private JCheckBox m_resolveLoadmapCtrl;
    private JCheckBox m_resolveMethodsCtrl;
    private JCheckBox m_pauseOnLoadCtrl;
    private JCheckBox m_includeStaticsCtrl;
    private JCheckBox m_excludeCompilerCtrl;
    private JCheckBox m_IlePaseCtrl;
    private JCheckBox m_genCodePaseCtrl;
    private JCheckBox m_ignTrapPaseCtrl;
    private JButton m_hostSrcPathButton;
    private JButton m_clientSrcPathButton;
    private JButton m_pluginLoadButton;
    private JButton m_pluginPathButton;
    private String m_hostSrcPath;
    private String m_clientSrcPath;
    private String m_pluginLoad;
    private String m_pluginPath;
    private int m_multiProc;
    private int m_breakBehavior;
    private boolean m_resolveLoadmap;
    private boolean m_resolveMethods;
    private boolean m_pauseOnLoad;
    private boolean m_includeStatics;
    private boolean m_excludeCompiler;
    private boolean m_IlePase;
    private boolean m_IlePaseSupported;
    private boolean m_genCodePase;
    private boolean m_ignTrapPase;

    public UnixStartDebugOptionsPage(DebugWindow debugWindow, JTabbedPane jTabbedPane, SettingsManager settingsManager) {
        super(MRI.get("DBG_OPTIONS"), 0);
        this.m_IlePaseSupported = debugWindow.isSupported(9, debugWindow.getSystemVersion());
        this.m_parent = jTabbedPane;
        this.m_userCfg = settingsManager.getUserConfig();
        this.m_userAliases = settingsManager.getUserAliases();
        this.m_panel = new JPanel(new BorderLayout());
        this.m_boxPanel = new JPanel();
        this.m_boxPanel.setLayout(new BoxLayout(this.m_boxPanel, 1));
        this.m_hostSrcPath = this.m_userCfg.getString("strdbgHostSrcPath", "");
        this.m_clientSrcPath = this.m_userCfg.getString("strdbgClientSrcPath", "");
        this.m_pluginLoad = this.m_userCfg.getString("strdbgHostPluginLoad", "");
        this.m_pluginPath = this.m_userCfg.getString("strdbgHostPluginPath", "");
        this.m_multiProc = this.m_userCfg.getInt("strdbgMultiProc", 3);
        this.m_breakBehavior = this.m_userCfg.getInt("strdbgBreakBehavior", 0);
        this.m_resolveLoadmap = this.m_userCfg.getBool("strdbgResolveLoadmap", true);
        this.m_resolveMethods = this.m_userCfg.getBool("strdbgResolveMethods", true);
        this.m_pauseOnLoad = this.m_userCfg.getBool("strdbgPauseOnLoad", true);
        this.m_includeStatics = this.m_userCfg.getBool("strdbgIncludeStatics", true);
        this.m_excludeCompiler = this.m_userCfg.getBool("strdbgExcludeCompiler", true);
        this.m_IlePase = this.m_userCfg.getBool("strdbgIlePase", false);
        this.m_genCodePase = this.m_userCfg.getBool("strdbgGenCodePase", false);
        this.m_ignTrapPase = this.m_userCfg.getBool("strdbgIgnoreTrapPase", false);
        this.createMiscCtrlPanel();
        this.createIndividualOptions();
        Dimension dimension = new Dimension(0, 10);
        this.m_boxPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_boxPanel.add(this.m_ctrlPanel);
        this.m_boxPanel.add(Box.createRigidArea(dimension));
        this.m_boxPanel.add(this.m_resolveLoadmapCtrl);
        this.m_boxPanel.add(Box.createRigidArea(dimension));
        this.m_boxPanel.add(this.m_resolveMethodsCtrl);
        this.m_boxPanel.add(Box.createRigidArea(dimension));
        this.m_boxPanel.add(this.m_pauseOnLoadCtrl);
        this.m_boxPanel.add(Box.createRigidArea(dimension));
        this.m_boxPanel.add(this.m_includeStaticsCtrl);
        this.m_boxPanel.add(Box.createRigidArea(dimension));
        this.m_boxPanel.add(this.m_excludeCompilerCtrl);
        this.m_boxPanel.add(Box.createRigidArea(dimension));
        this.m_boxPanel.add(this.m_genCodePaseCtrl);
        this.m_boxPanel.add(Box.createRigidArea(dimension));
        this.m_boxPanel.add(this.m_ignTrapPaseCtrl);
        this.m_boxPanel.add(Box.createRigidArea(dimension));
        if (this.m_IlePaseSupported) {
            this.m_boxPanel.add(this.m_IlePaseCtrl);
            this.m_boxPanel.add(Box.createRigidArea(dimension));
        }
        this.m_panel.add((Component)this.m_boxPanel, "North");
    }

    private void createMiscCtrlPanel() {
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_HOST_SOURCE_PATH_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_CLIENT_SOURCE_PATH_LABEL"));
        JLabel jLabel3 = Util.getAccessibleLabel(MRI.get("DBG2_PLUGIN_LOAD_LABEL"));
        JLabel jLabel4 = Util.getAccessibleLabel(MRI.get("DBG2_PLUGIN_PATH_LABEL"));
        JLabel jLabel5 = Util.getAccessibleLabel(MRI.get("DBG_FORKED_PROCESS_LABEL"));
        JLabel jLabel6 = Util.getAccessibleLabel(MRI.get("DBG_BREAK_BEHAVIOR_LABEL"));
        this.m_hostSrcPathCtrl = new JTextField(this.m_hostSrcPath, 25);
        this.m_hostSrcPathCtrl.setActionCommand(SRCPATH);
        this.m_hostSrcPathCtrl.addActionListener(this);
        this.m_hostSrcPathCtrl.addFocusListener(this);
        Insets insets = new Insets(0, 2, 0, 2);
        String string = MRI.get("DBG_EDIT_WITH_ELLIPSIS");
        this.m_hostSrcPathButton = new JButton(string);
        this.m_hostSrcPathButton.setActionCommand(HOST_BUTTON);
        this.m_hostSrcPathButton.addActionListener(this);
        this.m_hostSrcPathButton.setMargin(insets);
        this.m_clientSrcPathCtrl = new JTextField(this.m_clientSrcPath, 25);
        this.m_clientSrcPathCtrl.setActionCommand(SRCPATH);
        this.m_clientSrcPathCtrl.addActionListener(this);
        this.m_clientSrcPathCtrl.addFocusListener(this);
        this.m_clientSrcPathButton = new JButton(string);
        this.m_clientSrcPathButton.setActionCommand(CLIENT_BUTTON);
        this.m_clientSrcPathButton.addActionListener(this);
        this.m_clientSrcPathButton.setMargin(insets);
        this.m_pluginLoadCtrl = new JTextField(this.m_pluginLoad, 25);
        this.m_pluginLoadCtrl.setActionCommand(SRCPATH);
        this.m_pluginLoadCtrl.addActionListener(this);
        this.m_pluginLoadCtrl.addFocusListener(this);
        this.m_pluginLoadButton = new JButton(string);
        this.m_pluginLoadButton.setActionCommand(PLUGIN_LOAD_BUTTON);
        this.m_pluginLoadButton.addActionListener(this);
        this.m_pluginLoadButton.setMargin(insets);
        this.m_pluginPathCtrl = new JTextField(this.m_pluginPath, 25);
        this.m_pluginPathCtrl.setActionCommand(SRCPATH);
        this.m_pluginPathCtrl.addActionListener(this);
        this.m_pluginPathCtrl.addFocusListener(this);
        this.m_pluginPathButton = new JButton(string);
        this.m_pluginPathButton.setActionCommand(PLUGIN_PATH_BUTTON);
        this.m_pluginPathButton.addActionListener(this);
        this.m_pluginPathButton.setMargin(insets);
        this.m_multiProcCtrl = new JComboBox();
        this.m_multiProcCtrl.addItem(MRI.get("DBG_OFF"));
        this.m_multiProcCtrl.addItem(MRI.get("DBG_DEBUG_PARENT"));
        this.m_multiProcCtrl.addItem(MRI.get("DBG_DEBUG_CHILD"));
        this.m_multiProcCtrl.addItem(MRI.get("DBG_DEBUG_BOTH"));
        this.m_multiProcCtrl.setSelectedIndex(this.m_multiProc);
        this.m_breakBehaviorCtrl = new JComboBox();
        this.m_breakBehaviorCtrl.addItem(MRI.get("DBG_SYNC_DUPLICATE_MODULES"));
        this.m_breakBehaviorCtrl.addItem(MRI.get("DBG_EXTEND_DUPLICATE_MODULES"));
        this.m_breakBehaviorCtrl.addItem(MRI.get("DBG_EXTEND_DUPLICATE_MODULES_PROMPT"));
        this.m_breakBehaviorCtrl.addItem(MRI.get("DBG_IGNORE_DUPLICATE_MODULES"));
        this.m_breakBehaviorCtrl.setSelectedIndex(this.m_breakBehavior);
        Dimension dimension = this.m_hostSrcPathCtrl.getPreferredSize();
        Dimension dimension2 = this.m_hostSrcPathButton.getPreferredSize();
        if (dimension2.height - dimension.height < 10) {
            dimension2.height = dimension.height;
        }
        this.m_hostSrcPathButton.setPreferredSize(dimension2);
        this.m_clientSrcPathButton.setPreferredSize(dimension2);
        this.m_pluginLoadButton.setPreferredSize(dimension2);
        this.m_pluginPathButton.setPreferredSize(dimension2);
        Util.setAccessible((Accessible)this.m_hostSrcPathCtrl, jLabel);
        Util.setAccessible((Accessible)this.m_clientSrcPathCtrl, jLabel2);
        Util.setAccessible((Accessible)this.m_pluginLoadCtrl, jLabel3);
        Util.setAccessible((Accessible)this.m_pluginPathCtrl, jLabel4);
        Util.setAccessible((Accessible)this.m_multiProcCtrl, jLabel5);
        Util.setAccessible((Accessible)this.m_breakBehaviorCtrl, jLabel6);
        Util.setAccessible((Accessible)this.m_hostSrcPathButton, string);
        Util.setAccessible((Accessible)this.m_clientSrcPathButton, string);
        Util.setAccessible((Accessible)this.m_pluginLoadButton, string);
        Util.setAccessible((Accessible)this.m_pluginPathButton, string);
        Util.setOrientation(this.m_hostSrcPathCtrl, jLabel);
        Util.setOrientation(this.m_clientSrcPathCtrl, jLabel2);
        Util.setOrientation(this.m_pluginLoadCtrl, jLabel3);
        Util.setOrientation(this.m_pluginPathCtrl, jLabel4);
        Util.setOrientation(this.m_multiProcCtrl, jLabel5);
        Util.setOrientation(this.m_breakBehaviorCtrl, jLabel6);
        Util.setOrientation(this.m_hostSrcPathButton);
        Util.setOrientation(this.m_clientSrcPathButton);
        Util.setOrientation(this.m_pluginLoadButton);
        Util.setOrientation(this.m_pluginPathButton);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        jPanel.setBorder(this.getEmptyBorder(10, 0, 10, 10));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        jPanel.add(jLabel3);
        jPanel.add(jLabel4);
        jPanel.add(jLabel5);
        jPanel.add(jLabel6);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        jPanel2.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        jPanel2.add(this.m_hostSrcPathCtrl);
        jPanel2.add(this.m_clientSrcPathCtrl);
        jPanel2.add(this.m_pluginLoadCtrl);
        jPanel2.add(this.m_pluginPathCtrl);
        jPanel2.add(this.m_multiProcCtrl);
        jPanel2.add(this.m_breakBehaviorCtrl);
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 3));
        jPanel3.setBorder(this.getEmptyBorder(10, 5, 10, 0));
        jPanel3.add(this.m_hostSrcPathButton);
        jPanel3.add(this.m_clientSrcPathButton);
        jPanel3.add(this.m_pluginLoadButton);
        jPanel3.add(this.m_pluginPathButton);
        jPanel3.add(new JLabel(" "));
        jPanel3.add(new JLabel(" "));
        this.m_ctrlPanel = new JPanel(new BorderLayout());
        this.m_ctrlPanel.add((Component)jPanel, this.m_isLtoR ? "West" : "East");
        this.m_ctrlPanel.add((Component)jPanel2, "Center");
        this.m_ctrlPanel.add((Component)jPanel3, this.m_isLtoR ? "East" : "West");
    }

    private void createIndividualOptions() {
        String string = MRI.get("DBG_RESOLVE_LOADMAP_LABEL");
        this.m_resolveLoadmapCtrl = new JCheckBox(string, this.m_resolveLoadmap);
        String string2 = MRI.get("DBG_RESOLVE_METHODS_LABEL");
        this.m_resolveMethodsCtrl = new JCheckBox(string2, this.m_resolveMethods);
        String string3 = MRI.get("DBG_PAUSE_ON_LOAD_LABEL");
        this.m_pauseOnLoadCtrl = new JCheckBox(string3, this.m_pauseOnLoad);
        String string4 = MRI.get("DBG_INCLUDE_STATIC_IN_LOCALS_LABEL");
        this.m_includeStaticsCtrl = new JCheckBox(string4, this.m_includeStatics);
        String string5 = MRI.get("DBG_EXCLUDE_COMPILER_LABEL");
        this.m_excludeCompilerCtrl = new JCheckBox(string5, this.m_excludeCompiler);
        String string6 = MRI.get("DBG2_DEBUG_GENCODE");
        this.m_genCodePaseCtrl = new JCheckBox(string6, this.m_genCodePase);
        String string7 = MRI.get("DBG2_DEBUG_IGNTRAP");
        this.m_ignTrapPaseCtrl = new JCheckBox(string7, this.m_ignTrapPase);
        String string8 = MRI.get("DBG2_DEBUG_ILE");
        this.m_IlePaseCtrl = new JCheckBox(string8, this.m_IlePase);
        Util.setAccessible((Accessible)this.m_resolveLoadmapCtrl, string);
        Util.setAccessible((Accessible)this.m_resolveMethodsCtrl, string2);
        Util.setAccessible((Accessible)this.m_pauseOnLoadCtrl, string3);
        Util.setAccessible((Accessible)this.m_includeStaticsCtrl, string4);
        Util.setAccessible((Accessible)this.m_excludeCompilerCtrl, string5);
        Util.setAccessible((Accessible)this.m_IlePaseCtrl, string8);
        Util.setAccessible((Accessible)this.m_genCodePaseCtrl, string6);
        Util.setAccessible((Accessible)this.m_ignTrapPaseCtrl, string7);
        Util.setOrientation(this.m_resolveLoadmapCtrl);
        Util.setOrientation(this.m_resolveMethodsCtrl);
        Util.setOrientation(this.m_pauseOnLoadCtrl);
        Util.setOrientation(this.m_includeStaticsCtrl);
        Util.setOrientation(this.m_excludeCompilerCtrl);
        Util.setOrientation(this.m_genCodePaseCtrl);
        Util.setOrientation(this.m_ignTrapPaseCtrl);
        Util.setOrientation(this.m_IlePaseCtrl);
        this.m_ctrlPanel.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_resolveLoadmapCtrl.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_resolveMethodsCtrl.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_pauseOnLoadCtrl.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_includeStaticsCtrl.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_excludeCompilerCtrl.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_genCodePaseCtrl.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_ignTrapPaseCtrl.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_IlePaseCtrl.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
    }

    public String getHostSourcePath() {
        return this.m_hostSrcPath;
    }

    public String getClientSourcePath() {
        return this.m_clientSrcPath;
    }

    public String getHostPluginLoad() {
        return this.m_pluginLoad;
    }

    public String getHostPluginPath() {
        return this.m_pluginPath;
    }

    public int getMultiProc() {
        return this.m_multiProc;
    }

    public int getOptionsMask() {
        int n = 0;
        switch (this.m_breakBehavior) {
            case 0: {
                n |= 0x40;
                break;
            }
            case 1: {
                n |= 4;
                break;
            }
            case 2: {
                n |= 0x100;
                break;
            }
        }
        if (this.m_resolveLoadmap) {
            n |= 2;
        }
        if (this.m_resolveMethods) {
            n |= 0x20;
        }
        if (this.m_pauseOnLoad) {
            n |= 8;
        }
        if (this.m_includeStatics) {
            n |= 0x10;
        }
        if (this.m_excludeCompiler) {
            n |= 0x80;
        }
        if (this.m_genCodePase) {
            n |= 0x800;
        }
        if (this.m_ignTrapPase) {
            n |= 0x1000;
        }
        if (this.m_IlePaseSupported && this.m_IlePase) {
            n |= 0x400;
        }
        return n;
    }

    public JComponent getComponent() {
        return this.m_panel;
    }

    public void cleanUp() {
        this.m_userCfg = null;
        this.m_panel = null;
        this.m_boxPanel = null;
        this.m_ctrlPanel = null;
        this.m_hostSrcPathCtrl = null;
        this.m_clientSrcPathCtrl = null;
        this.m_pluginLoadCtrl = null;
        this.m_pluginPathCtrl = null;
        this.m_multiProcCtrl = null;
        this.m_breakBehaviorCtrl = null;
        this.m_resolveLoadmapCtrl = null;
        this.m_pauseOnLoadCtrl = null;
        this.m_includeStaticsCtrl = null;
        this.m_excludeCompilerCtrl = null;
        this.m_genCodePaseCtrl = null;
        this.m_ignTrapPaseCtrl = null;
        this.m_IlePaseCtrl = null;
        this.m_hostSrcPathButton = null;
        this.m_clientSrcPathButton = null;
        this.m_pluginLoadButton = null;
        this.m_pluginPathButton = null;
    }

    public boolean doOk() {
        String string = this.m_hostSrcPathCtrl.getText().trim();
        this.m_hostSrcPath = string.startsWith(USER_KEY_FLAG) ? this.m_userAliases.getString(string.substring(1), string) : string;
        string = this.m_clientSrcPathCtrl.getText().trim();
        this.m_clientSrcPath = string.startsWith(USER_KEY_FLAG) ? this.m_userAliases.getString(string.substring(1), string) : string;
        string = this.m_pluginLoadCtrl.getText().trim();
        this.m_pluginLoad = string.startsWith(USER_KEY_FLAG) ? this.m_userAliases.getString(string.substring(1), string) : string;
        string = this.m_pluginPathCtrl.getText().trim();
        this.m_pluginPath = string.startsWith(USER_KEY_FLAG) ? this.m_userAliases.getString(string.substring(1), string) : string;
        this.m_multiProc = this.m_multiProcCtrl.getSelectedIndex();
        this.m_breakBehavior = this.m_breakBehaviorCtrl.getSelectedIndex();
        this.m_resolveLoadmap = this.m_resolveLoadmapCtrl.isSelected();
        this.m_resolveMethods = this.m_resolveMethodsCtrl.isSelected();
        this.m_pauseOnLoad = this.m_pauseOnLoadCtrl.isSelected();
        this.m_includeStatics = this.m_includeStaticsCtrl.isSelected();
        this.m_excludeCompiler = this.m_excludeCompilerCtrl.isSelected();
        this.m_genCodePase = this.m_genCodePaseCtrl.isSelected();
        this.m_ignTrapPase = this.m_ignTrapPaseCtrl.isSelected();
        this.m_IlePase = this.m_IlePaseCtrl.isSelected();
        this.m_userCfg.setString("strdbgHostSrcPath", this.m_hostSrcPath);
        this.m_userCfg.setString("strdbgClientSrcPath", this.m_clientSrcPath);
        this.m_userCfg.setString("strdbgHostPluginLoad", this.m_pluginLoad);
        this.m_userCfg.setString("strdbgHostPluginPath", this.m_pluginPath);
        this.m_userCfg.setInt("strdbgMultiProc", this.m_multiProc);
        this.m_userCfg.setInt("strdbgBreakBehavior", this.m_breakBehavior);
        this.m_userCfg.setBool("strdbgResolveLoadmap", this.m_resolveLoadmap);
        this.m_userCfg.setBool("strdbgResolveMethods", this.m_resolveMethods);
        this.m_userCfg.setBool("strdbgPauseOnLoad", this.m_pauseOnLoad);
        this.m_userCfg.setBool("strdbgIncludeStatics", this.m_includeStatics);
        this.m_userCfg.setBool("strdbgGenCodePase", this.m_genCodePase);
        this.m_userCfg.setBool("strdbgIgnoreTrapPase", this.m_ignTrapPase);
        this.m_userCfg.setBool("strdbgExcludeCompiler", this.m_excludeCompiler);
        if (this.m_IlePaseSupported) {
            this.m_userCfg.setBool("strdbgIlePase", this.m_IlePase);
        }
        return true;
    }

    public void doEditPath(int n) {
        String string = this.m_clientSrcPathCtrl.getText().trim();
        String string2 = File.pathSeparator;
        char c = File.pathSeparatorChar;
        String string3 = MRI.get("DBG_CLIENT_SOURCE_PATH_LABEL");
        switch (n) {
            case 0: {
                string = this.m_hostSrcPathCtrl.getText().trim();
                string2 = ":";
                c = ':';
                string3 = MRI.get("DBG_HOST_SOURCE_PATH_LABEL");
                break;
            }
            case 2: {
                string = this.m_pluginLoadCtrl.getText().trim();
                string2 = ":";
                c = ':';
                string3 = MRI.get("DBG2_HOST_PLUGIN_LOAD_LABEL");
                break;
            }
            case 3: {
                string = this.m_pluginPathCtrl.getText().trim();
                string2 = ":";
                c = ':';
                string3 = MRI.get("DBG2_HOST_PLUGIN_PATH_LABEL");
                break;
            }
        }
        TokenEditorDialog tokenEditorDialog = new TokenEditorDialog(this.getDialog(), MRI.get("DBG_EDIT_PATH_DIALOG_TITLE"), string3, MRI.get("DBG_ENTER_NEW_PATH_LABEL"), string, string2, c);
        tokenEditorDialog.display();
        if (!tokenEditorDialog.wasCanceled()) {
            switch (n) {
                case 0: {
                    this.m_hostSrcPath = tokenEditorDialog.getTokenString();
                    this.m_hostSrcPathCtrl.setText(this.m_hostSrcPath);
                    break;
                }
                case 2: {
                    this.m_pluginLoad = tokenEditorDialog.getTokenString();
                    this.m_pluginLoadCtrl.setText(this.m_pluginLoad);
                    break;
                }
                case 3: {
                    this.m_pluginPath = tokenEditorDialog.getTokenString();
                    this.m_pluginPathCtrl.setText(this.m_pluginPath);
                    break;
                }
                default: {
                    this.m_clientSrcPath = tokenEditorDialog.getTokenString();
                    this.m_clientSrcPathCtrl.setText(this.m_clientSrcPath);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(SRCPATH)) {
            this.getDialog().doOk();
        } else if (string.equals(HOST_BUTTON)) {
            this.doEditPath(0);
        } else if (string.equals(CLIENT_BUTTON)) {
            this.doEditPath(1);
        } else if (string.equals(PLUGIN_LOAD_BUTTON)) {
            this.doEditPath(2);
        } else if (string.equals(PLUGIN_PATH_BUTTON)) {
            this.doEditPath(3);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Component component;
        String string;
        if (!focusEvent.isTemporary() && (string = ((JTextField)(component = focusEvent.getComponent())).getText().trim()).startsWith(USER_KEY_FLAG)) {
            ((JTextField)component).setText(this.m_userAliases.getString(string.substring(1), string));
        }
    }
}

