/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.util;

import java.text.ParseException;

public class TokenParser {
    protected DFAScanner m_oScanner = null;
    protected int m_nCurPos;
    protected String m_sParseContent;
    protected int m_nMaxLength;
    protected boolean m_bIsAllowLineReturn = false;
    protected boolean m_bIsAllowSpaceOutput = false;
    protected boolean m_bIsAllowMultiSpaceOutput = false;

    protected CParser getCharParser() {
        return new CParser();
    }

    protected DFAScanner getScanner() {
        if (this.m_oScanner == null) {
            int[][] nArray = new int[4][5];
            if (this.m_bIsAllowSpaceOutput) {
                for (int i = 0; i < 4; ++i) {
                    System.arraycopy(DFAScanner.ScanState_AllowSpaceOutput[i], 0, nArray[i], 0, 5);
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    System.arraycopy(DFAScanner.ScanState_NotAllowSpaceOutput[i], 0, nArray[i], 0, 5);
                }
            }
            nArray[3][4] = this.m_bIsAllowLineReturn ? 3 : -4;
            this.m_oScanner = new DFAScanner(this.getCharParser(), nArray, this.m_sParseContent, this.m_nMaxLength);
        }
        return this.m_oScanner;
    }

    public boolean isSpaceToken(Token token) {
        return token.type == 1 && token.value.length() == 1 && this.getScanner().charParser.getCharType(token.value.charAt(0)) == 2;
    }

    public Token next() throws ParseException {
        Token token = this.peek();
        this.m_nCurPos = token == null ? this.m_nMaxLength : token.endPos;
        return token;
    }

    public Token peek() throws ParseException {
        Token token = this.getScanner().scan(this.m_nCurPos);
        if (!this.m_bIsAllowMultiSpaceOutput && token != null && this.isSpaceToken(token)) {
            Token token2 = this.getScanner().scan(token.endPos);
            while (token2 != null && this.isSpaceToken(token2)) {
                token = token2;
                token2 = this.getScanner().scan(token2.endPos);
            }
        }
        return token;
    }

    public void setAllowLineReturn(boolean bl) {
        this.m_oScanner = null;
        this.m_bIsAllowLineReturn = bl;
    }

    public void setAllowSpaceOutput(boolean bl, boolean bl2) {
        this.m_oScanner = null;
        this.m_bIsAllowSpaceOutput = bl;
        this.m_bIsAllowMultiSpaceOutput = bl2;
    }

    public void setParseContent(String string) {
        this.m_sParseContent = string == null ? "" : string;
        this.m_nCurPos = 0;
        this.m_nMaxLength = this.m_sParseContent.length();
    }

    public static class Token {
        public static final int TT_BAD = 0;
        public static final int TT_SYM = 1;
        public static final int TT_NAME = 2;
        public static final int TT_STRING = 3;
        public static final int TT_VAR = 4;
        public static final int TT_MACRO = 5;
        public final int type;
        public final String value;
        public final int endPos;

        public static char getType(int n) {
            switch (n) {
                case 0: {
                    return 'B';
                }
                case 1: {
                    return 'S';
                }
                case 2: {
                    return 'N';
                }
                case 3: {
                    return 'T';
                }
                case 4: {
                    return 'V';
                }
                case 5: {
                    return 'M';
                }
            }
            return 'B';
        }

        public Token(int n, String string, int n2) {
            this.type = n;
            this.value = string;
            this.endPos = n2;
        }
    }

    protected static class DFAScanner {
        static final int SS_INIT = 0;
        static final int SS_SKIP = 1;
        static final int SS_VAR = 2;
        static final int SS_STR = 3;
        static final int SS_OUT1 = -1;
        static final int SS_OUT2 = -2;
        static final int SS_OUT3 = -3;
        static final int SS_BAD = -4;
        static final int SS_ARRAY_H = 4;
        static final int SS_ARRAY_W = 5;
        static int[][] ScanState_NotAllowSpaceOutput = new int[][]{{2, -2, 1, 3, 1}, {2, -2, 1, 3, 1}, {2, -1, -1, -1, -1}, {3, 3, 3, -3, -4}};
        static int[][] ScanState_AllowSpaceOutput = new int[][]{{2, -2, -2, 3, 1}, {2, -2, -2, 3, 1}, {2, -1, -1, -1, -1}, {3, 3, 3, -3, -4}};
        protected CParser charParser;
        private final int[][] ScanState;
        private String parseContent;
        private int maxLength;

        public DFAScanner(CParser cParser, int[][] nArray, String string, int n) {
            this.charParser = cParser;
            this.ScanState = nArray;
            this.parseContent = string;
            this.maxLength = n;
        }

        public Token scan(int n) throws ParseException {
            int n2 = -1;
            char c = '\u0000';
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            String string = null;
            Token token = null;
            if (n >= this.maxLength) {
                return null;
            }
            char c2 = '\u0000';
            for (int i = n; string == null && i < this.maxLength; ++i) {
                c = this.parseContent.charAt(i);
                int n6 = this.charParser.getCharType(c);
                if (n6 == 5) {
                    if (n3 != 3) {
                        throw new ParseException(this.parseContent, i);
                    }
                } else {
                    n4 = this.ScanState[n3][n6];
                    switch (n4) {
                        case -4: {
                            throw new ParseException(this.parseContent, i);
                        }
                        case 1: {
                            ++n;
                            break;
                        }
                        case -1: {
                            n2 = i;
                            n5 = 2;
                            string = this.parseContent.substring(n, n2);
                            break;
                        }
                        case -2: {
                            n2 = i + 1;
                            n5 = 1;
                            string = this.parseContent.substring(n, n2);
                            break;
                        }
                        case -3: {
                            if (n6 != 3) {
                                throw new ParseException(this.parseContent, i);
                            }
                            if (n3 != 3) {
                                throw new ParseException(this.parseContent, i);
                            }
                            if (c2 == '\u0000') {
                                throw new ParseException(this.parseContent, i);
                            }
                            if (c2 != c) {
                                n4 = 3;
                                break;
                            }
                            n2 = i + 1;
                            n5 = 3;
                            string = this.parseContent.substring(n + 1, n2 - 1);
                            break;
                        }
                        case 3: {
                            if (c2 != '\u0000') break;
                            if (n6 != 3) {
                                throw new ParseException(this.parseContent, i);
                            }
                            c2 = c;
                        }
                    }
                }
                n3 = n4;
            }
            if (string == null) {
                if (n4 == 1) {
                    return null;
                }
                n2 = this.maxLength;
                n5 = n4 == 2 ? 2 : 0;
                string = this.parseContent.substring(n, n2);
            }
            token = new Token(n5, string, n2);
            return token;
        }
    }

    protected static class CParser {
        static final int CT_CHAR = 0;
        static final int CT_SINGLE = 1;
        static final int CT_SPACE = 2;
        static final int CT_STRING = 3;
        static final int CT_END = 4;
        static final int CT_UNKNOWN = 5;
        static final char EN_CHAR_NEWLINE = '\n';
        static final char EN_CHAR_ENTER = '\r';
        static final char EN_CHAR_SPACE = ' ';
        static final char EN_CHAR_TAB = '\t';
        static final char CN_CHAR_SPACE = '\u3000';

        protected CParser() {
        }

        public int getCharType(char c) {
            switch (c) {
                case '\n': 
                case '\r': {
                    return 4;
                }
                case '\t': 
                case ' ': {
                    return 2;
                }
                case '\"': 
                case '\'': {
                    return 3;
                }
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '_': 
                case '{': 
                case '}': {
                    return 1;
                }
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                return 0;
            }
            return 5;
        }
    }
}

