/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.request;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.request.DebuggerRequest;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.Util;
import java.io.IOException;

public class StartDebugRequest
extends DebuggerRequest
implements DebugConstants {
    private String m_pgmLib;
    private String m_pgmName;
    private int m_pgmType;
    private String m_pgmParms;
    private String m_cmd;
    private String m_jobId;
    private String m_jvmVersion;
    private String m_classPath;
    private String m_sourcePath;
    private int m_options;

    public StartDebugRequest(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, String string8, int n2) {
        super(501);
        this.m_pgmLib = string;
        this.m_pgmName = string2;
        this.m_pgmType = n;
        this.m_pgmParms = this.quoteIt(string3.trim());
        this.m_cmd = this.quoteIt(string4.trim());
        this.m_jvmVersion = string5.trim();
        this.m_classPath = string6.trim();
        this.m_sourcePath = string7.trim();
        this.m_jobId = string8;
        this.m_options = n2;
    }

    public int writeSize(CommLink commLink) {
        int n = 0;
        n += commLink.writeSize(this.m_pgmLib);
        n += commLink.writeSize(this.m_pgmName);
        n += 4;
        n += commLink.writeSize(this.m_pgmParms);
        n += commLink.writeSize(this.m_jobId);
        n += commLink.writeSize(this.m_jvmVersion);
        n += commLink.writeSize(this.m_classPath);
        n += commLink.writeSize(this.m_sourcePath);
        if (this.m_ctxt != null) {
            double d = commLink.getSystemVersion();
            if (this.m_ctxt.isSupported(3, d)) {
                n += commLink.writeSize(this.m_cmd);
            }
            if (this.m_ctxt.isSupported(4, d)) {
                n += 4;
            }
        }
        return n;
    }

    public void write(CommLink commLink) throws IOException {
        boolean bl = this.m_pgmType == 0 || this.m_pgmType == 1;
        commLink.writeString(bl ? Util.upper(this.m_pgmLib) : this.m_pgmLib);
        commLink.writeString(bl ? Util.upper(this.m_pgmName) : this.m_pgmName);
        commLink.writeInt(this.m_pgmType);
        commLink.writeString(this.m_pgmParms);
        commLink.writeString(Util.upper(this.m_jobId));
        commLink.writeString(this.m_jvmVersion);
        commLink.writeString(this.m_classPath);
        commLink.writeString(this.m_sourcePath);
        if (this.m_ctxt != null) {
            double d = commLink.getSystemVersion();
            if (this.m_ctxt.isSupported(3, d)) {
                commLink.writeString(this.m_cmd);
            }
            if (this.m_ctxt.isSupported(4, d)) {
                commLink.writeInt(this.m_options);
            }
        }
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_pgmLib = null;
        this.m_pgmName = null;
        this.m_pgmParms = null;
        this.m_cmd = null;
        this.m_jobId = null;
        this.m_jvmVersion = null;
        this.m_classPath = null;
        this.m_sourcePath = null;
    }

    private String quoteIt(String string) {
        if (string.length() > 0 && string.indexOf(39) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                stringBuffer.append(c);
                if (c != '\'') continue;
                stringBuffer.append(c);
            }
            string = stringBuffer.toString();
        }
        return string;
    }
}

