/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.register;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.RequestPacketElement;
import java.io.IOException;
import java.math.BigInteger;

public class RegisterDescriptor
implements RequestPacketElement,
DebugConstants {
    private int m_id;
    private String m_value;
    private String m_bits;

    public RegisterDescriptor() {
        this.m_id = -1;
        this.m_value = "";
    }

    public RegisterDescriptor(int n, String string) {
        this.m_id = n;
        this.m_value = string;
    }

    public int getId() {
        return this.m_id;
    }

    public String getValue() {
        return this.m_value;
    }

    public void setValue(String string) {
        this.m_bits = null;
        this.m_value = string;
    }

    public String getBitValue() {
        if (this.m_bits == null) {
            this.m_bits = this.hexToBits(this.m_value);
        }
        return this.m_bits;
    }

    protected String hexToBits(String string) {
        BigInteger bigInteger = new BigInteger(string, 16);
        String string2 = bigInteger.toString(2);
        if (string2.length() < string.length() * 4) {
            string2 = "0000000000000000000000000000000000000000000000000000000000000000".substring(0, string.length() * 4 - string2.length()) + string2;
        }
        return string2;
    }

    protected String bitsToHex(String string) {
        BigInteger bigInteger = new BigInteger(string, 2);
        String string2 = bigInteger.toString(16).toUpperCase();
        if (string2.length() < string.length() / 4) {
            string2 = "0000000000000000000000000000000000000000000000000000000000000000".substring(0, string.length() / 4 - string2.length()) + string2;
        }
        return string2;
    }

    protected String replaceBits(String string, String string2, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.replace(n, n2 + 1, string2);
        return stringBuffer.toString();
    }

    public String getChildBitValue(int n, int n2) {
        if (this.m_value.charAt(0) == '.') {
            return "................................................................".substring(0, n2 - n + 1);
        }
        try {
            return this.getBitValue().substring(n, n2 + 1);
        }
        catch (Throwable throwable) {
            boolean bl = false;
            return "";
        }
    }

    public String getChildHexValue(int n, int n2, int n3) {
        if (this.m_value.charAt(0) == '.') {
            int n4 = n2 - n + 1;
            int n5 = n4 % 4 == 0 ? n4 / 4 : n4 / 4 + 1;
            return "................................................................".substring(0, n5);
        }
        String string = this.getBitValue().substring(n, n2 + 1);
        int n6 = string.length();
        switch (n3) {
            case 0: 
            case 1: {
                if (n6 % 4 == 0) break;
                string = "0000000000000000000000000000000000000000000000000000000000000000".substring(0, 4 - n6 % 4) + string;
                break;
            }
            case 2: {
                if (n6 % 4 == 0) break;
                string = string + "0000000000000000000000000000000000000000000000000000000000000000".substring(0, 4 - n6 % 4);
            }
        }
        return this.bitsToHex(string);
    }

    public void setChildBitValue(String string, int n, int n2) {
        if (this.m_value.charAt(0) == '.') {
            return;
        }
        this.m_bits = this.replaceBits(this.getBitValue(), string, n, n2);
        this.m_value = this.bitsToHex(this.m_bits);
    }

    public void setChildHexValue(String string, int n, int n2, int n3) {
        if (this.m_value.charAt(0) == '.') {
            return;
        }
        String string2 = this.hexToBits(string);
        int n4 = string2.length();
        int n5 = n2 - n + 1;
        switch (n3) {
            case 0: 
            case 1: {
                if (n4 <= n5) break;
                string2 = string2.substring(n4 - n5);
                break;
            }
            case 2: {
                if (n4 % 4 == 0) break;
                string2 = string2.substring(0, n5);
            }
        }
        this.setChildBitValue(string2, n, n2);
    }

    public void read(CommLink commLink) throws IOException {
        this.m_id = commLink.readInt();
        this.m_value = commLink.readString();
    }

    public int writeSize(CommLink commLink) {
        int n = 0;
        n += 4;
        return n += commLink.writeSize(this.m_value);
    }

    public void write(CommLink commLink) throws IOException {
        commLink.writeInt(this.m_id);
        commLink.writeString(this.m_value);
    }
}

