/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.panel;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.ModuleDescriptor;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.event.LAFEvent;
import com.ibm.iseries.debug.event.PgmEvent;
import com.ibm.iseries.debug.listener.ContextListener;
import com.ibm.iseries.debug.listener.LAFListener;
import com.ibm.iseries.debug.listener.PgmListener;
import com.ibm.iseries.debug.manager.LAFManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Util;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ProgramsPanel
extends TabPanel
implements PgmListener,
LAFListener,
DebugConstants,
MouseListener,
ActionListener,
TreeSelectionListener,
ClipboardOwner,
ContextListener {
    public static final String KEY = "programs";
    private static final String GIF = "/com/ibm/iseries/debug/dbg016.gif";
    private static final String PGM_GIF = "/com/ibm/iseries/debug/dbg032.gif";
    private static final String SRVPGM_GIF = "/com/ibm/iseries/debug/dbg033.gif";
    private static final String MODULE_GIF = "/com/ibm/iseries/debug/dbg034.gif";
    private static final String CLASS_GIF = "/com/ibm/iseries/debug/dbg036.gif";
    private static final int ROOT_LEVEL = 0;
    private static final int TYPE_LEVEL = 1;
    private static final int PGM_LEVEL = 2;
    private static final int MODULE_LEVEL = 3;
    private static final int ROOT_COUNT = 1;
    private static final int TYPE_COUNT = 2;
    private static final int PGM_COUNT = 3;
    private static final int MODULE_COUNT = 4;
    private static final String DELETE = "delete";
    private JScrollPane m_scrollPane;
    private JTree m_tree;
    private DefaultMutableTreeNode m_root = new DefaultMutableTreeNode();
    private DefaultMutableTreeNode m_pgmNode = new DefaultMutableTreeNode(MRI.get("DBG_PROGRAMS"));
    private DefaultMutableTreeNode m_srvPgmNode = new DefaultMutableTreeNode(MRI.get("DBG_SERVICE_PROGRAMS"));
    private DefaultMutableTreeNode m_classNode = new DefaultMutableTreeNode(MRI.get("DBG_CLASS_FILES"));
    private DefaultTreeModel m_treeModel;
    private TreeSelectionModel m_treeSelect;
    private ProgramRenderer m_pgmRenderer;
    private ContextMenu m_contextMenu;
    private ArrayList m_descriptors;

    public ProgramsPanel() {
        super(MRI.get("DBG_PROGRAMS"), MRI.getIcon(0, GIF));
        this.m_root.add(this.m_pgmNode);
        this.m_root.add(this.m_srvPgmNode);
        this.m_root.add(this.m_classNode);
        this.m_tree = new JTree();
        this.m_treeModel = new DefaultTreeModel(this.m_root);
        this.m_treeSelect = this.m_tree.getSelectionModel();
        this.m_tree.setRootVisible(false);
        this.m_tree.setModel(this.m_treeModel);
        this.m_tree.addMouseListener(this);
        this.m_tree.addTreeSelectionListener(this);
        if (this.m_tree.getRowHeight() < 18) {
            this.m_tree.setRowHeight(18);
        }
        this.m_tree.registerKeyboardAction(this, DELETE, KeyStroke.getKeyStroke(127, 0), 2);
        this.m_scrollPane = new JScrollPane(this.m_tree);
        this.m_tree.addFocusListener(this);
        this.m_scrollPane.getViewport().addFocusListener(this);
        Util.setAccessible((Accessible)this.m_tree, this.m_name);
        Util.setOrientation(this.m_scrollPane);
        Util.setOrientation(this.m_tree);
        this.m_descriptors = new ArrayList();
    }

    public void lookAndFeelModifications() {
        String string = LAFManager.instance().getLookAndFeel();
        if (string.equals("javax.swing.plaf.metal.MetalLookAndFeel")) {
            this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        }
        Settings settings = this.m_ctxt.getConfig();
        this.m_contextMenu = (ContextMenu)Util.loadObject(settings.getString("pgmContextMenu", null));
        this.m_contextMenu.init(this.m_ctxt.getActionGroup());
        this.m_pgmRenderer = new ProgramRenderer();
        this.m_tree.setCellRenderer(this.m_pgmRenderer);
    }

    private Object getUserObject(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return defaultMutableTreeNode.getUserObject();
    }

    private Object getUserObject(TreePath treePath, int n) {
        if (treePath.getPathCount() - 1 < n) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(n);
        return defaultMutableTreeNode.getUserObject();
    }

    private boolean isRootPath(TreePath treePath) {
        return treePath.getPathCount() == 1;
    }

    private boolean isTypePath(TreePath treePath) {
        return treePath.getPathCount() == 2;
    }

    private boolean isPgmPath(TreePath treePath) {
        return treePath.getPathCount() == 3;
    }

    private boolean isModulePath(TreePath treePath) {
        return treePath.getPathCount() == 4;
    }

    private void prepareActionContext(TreePath[] treePathArray) {
        if (!this.m_tree.hasFocus()) {
            return;
        }
        this.m_ctxt.getActionGroup().clearAddPgmContext();
        this.m_ctxt.getActionGroup().clearRmvPgmContext();
        this.m_ctxt.getActionGroup().clearGotoSrcContext();
        this.m_descriptors.clear();
        if (treePathArray == null || treePathArray.length == 0) {
            this.clearActionContext();
            return;
        }
        boolean bl = !this.m_ctxt.getAction("strdbg").isEnabled();
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < treePathArray.length; ++i) {
            Object object;
            TreePath treePath = treePathArray[i];
            if (this.isTypePath(treePath)) {
                if (treePathArray.length != 1) continue;
                object = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (object == this.m_pgmNode) {
                    this.m_ctxt.getActionGroup().setAddPgmContext(0);
                    continue;
                }
                if (object == this.m_srvPgmNode) {
                    this.m_ctxt.getActionGroup().setAddPgmContext(1);
                    continue;
                }
                if (object != this.m_classNode) continue;
                this.m_ctxt.getActionGroup().setAddPgmContext(2);
                continue;
            }
            object = (PgmDescriptor)this.getUserObject(treePath, 2);
            this.m_ctxt.getActionGroup().setAddPgmContext(((PgmDescriptor)object).getPgmType());
            if (this.isPgmPath(treePath)) {
                if (treePathArray.length == 1 && ((PgmDescriptor)object).isJavaClass()) {
                    bl3 = true;
                    this.m_ctxt.getActionGroup().setGotoSrcContext(((PgmDescriptor)object).getModuleAt(0).getViewId(), -1);
                }
                this.m_descriptors.add(object);
                bl2 = true;
                continue;
            }
            if (treePathArray.length != 1 || !this.isModulePath(treePath)) continue;
            bl3 = true;
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)this.getUserObject(treePath);
            this.m_ctxt.getActionGroup().setGotoSrcContext(moduleDescriptor.getViewId(), -1);
        }
        if (this.m_descriptors.size() > 0) {
            this.m_ctxt.getActionGroup().setRmvPgmContext(this.m_descriptors);
        }
        this.m_ctxt.enableAction("addpgm", bl);
        this.m_ctxt.enableAction("rmvpgm", bl2);
        this.m_ctxt.enableAction("gosrc", bl3);
        this.m_ctxt.enableAction("copy", treePathArray.length > 0);
    }

    private void clearActionContext() {
        this.m_ctxt.enableAction("rmvpgm", false);
        this.m_ctxt.enableAction("gosrc", false);
        this.m_ctxt.enableAction("copy", false);
    }

    private DefaultMutableTreeNode searchDescendants(DefaultMutableTreeNode defaultMutableTreeNode, String string, boolean bl) {
        if (bl && defaultMutableTreeNode.toString().toUpperCase().indexOf(string) >= 0) {
            return defaultMutableTreeNode;
        }
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.searchDescendants(defaultMutableTreeNode2, string, true);
            if (defaultMutableTreeNode3 == null) continue;
            return defaultMutableTreeNode3;
        }
        return null;
    }

    private DefaultMutableTreeNode searchChildren(DefaultMutableTreeNode defaultMutableTreeNode, int n, String string) {
        int n2 = defaultMutableTreeNode.getChildCount();
        for (int i = n; i < n2; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.toString().toUpperCase().indexOf(string) < 0) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    private void ensureVisible(TreePath treePath) {
        Rectangle rectangle = this.m_tree.getVisibleRect();
        Rectangle rectangle2 = this.m_tree.getPathBounds(treePath);
        if (rectangle2.y < rectangle.y || rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
            rectangle.y = rectangle2.y;
            this.m_tree.scrollRectToVisible(rectangle);
        }
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        super.init(debugContext, tabbedPane);
        this.lookAndFeelModifications();
        this.m_ctxt.getManager("pgmmgr").addListener(this);
        this.m_ctxt.getManager("lafmgr").addListener(this);
        this.m_ctxt.getManager("ctxtmgr").addListener(this);
    }

    public void cleanUp() {
        this.m_ctxt.getManager("pgmmgr").removeListener(this);
        this.m_ctxt.getManager("lafmgr").removeListener(this);
        this.m_ctxt.getManager("ctxtmgr").removeListener(this);
        this.m_tree.removeFocusListener(this);
        this.m_scrollPane.getViewport().removeFocusListener(this);
        this.m_scrollPane = null;
        this.m_tree = null;
        this.m_root = null;
        this.m_pgmNode = null;
        this.m_srvPgmNode = null;
        this.m_classNode = null;
        this.m_treeModel = null;
        this.m_treeSelect = null;
        this.m_pgmRenderer = null;
        this.m_contextMenu = null;
        this.m_descriptors = null;
        super.cleanUp();
    }

    public String getHelpId() {
        return "dbgpgms_p";
    }

    public String getKey() {
        return KEY;
    }

    public JComponent getComponent() {
        return this.m_scrollPane;
    }

    public void setActivePanel(boolean bl) {
        super.setActivePanel(bl);
        if (bl) {
            this.prepareActionContext(this.m_treeSelect.getSelectionPaths());
        } else {
            this.clearActionContext();
        }
    }

    public boolean canDoFind() {
        return true;
    }

    public boolean find(String string) {
        Serializable serializable;
        TreePath treePath = this.m_tree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        defaultMutableTreeNode = treePath == null ? this.m_root : (DefaultMutableTreeNode)treePath.getLastPathComponent();
        string = string.toUpperCase();
        if (defaultMutableTreeNode.getChildCount() == 0) {
            serializable = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            defaultMutableTreeNode2 = this.searchChildren((DefaultMutableTreeNode)serializable, serializable.getIndex(defaultMutableTreeNode) + 1, string);
        } else {
            defaultMutableTreeNode2 = this.searchDescendants(defaultMutableTreeNode, string, false);
        }
        if (defaultMutableTreeNode2 != null) {
            serializable = new TreePath(defaultMutableTreeNode2.getPath());
            this.m_tree.setSelectionPath((TreePath)serializable);
            this.m_tree.expandPath((TreePath)serializable);
            this.ensureVisible((TreePath)serializable);
            this.m_ctxt.clearMessage();
            return true;
        }
        this.m_tree.clearSelection();
        return false;
    }

    public boolean canDoCopy() {
        return this.m_tree.getSelectionPath() != null;
    }

    public void copy() {
        TreePath treePath = this.m_tree.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(defaultMutableTreeNode.toString());
            clipboard.setContents(stringSelection, this);
        }
    }

    private DefaultMutableTreeNode pgmTypeToNode(int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        switch (n) {
            case 0: {
                defaultMutableTreeNode = this.m_pgmNode;
                break;
            }
            case 1: {
                defaultMutableTreeNode = this.m_srvPgmNode;
                break;
            }
            case 2: {
                defaultMutableTreeNode = this.m_classNode;
            }
        }
        return defaultMutableTreeNode;
    }

    public void programAdded(PgmEvent pgmEvent) {
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        int n = pgmEvent.getCount();
        TreePath treePath = null;
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2;
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode = this.pgmTypeToNode(pgmDescriptor.getPgmType());
            if (this.programExists(defaultMutableTreeNode, pgmDescriptor, n2 = pgmManager.programSortOrder(pgmDescriptor.getPgmPath(), pgmDescriptor.getPgmType()))) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(pgmDescriptor);
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n2);
            if (defaultMutableTreeNode.getChildCount() == 1) {
                object = new TreePath(defaultMutableTreeNode.getPath());
                this.m_tree.expandPath((TreePath)object);
            }
            if (!pgmDescriptor.isJavaClass()) {
                int n3 = pgmDescriptor.getModuleCount();
                for (int j = 0; j < n3; ++j) {
                    ModuleDescriptor moduleDescriptor = pgmDescriptor.getModuleAt(j);
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(moduleDescriptor);
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                    if (treePath != null || !moduleDescriptor.hasMain() || moduleDescriptor != pgmManager.getMainModule()) continue;
                    TreePath treePath2 = new TreePath(defaultMutableTreeNode2.getPath());
                    TreePath treePath3 = new TreePath(defaultMutableTreeNode3.getPath());
                    this.m_tree.expandPath(treePath2);
                    treePath = treePath3;
                }
            } else if (treePath == null && ((ModuleDescriptor)(object = pgmDescriptor.getModuleAt(0))).hasMain() && object == pgmManager.getMainModule()) {
                treePath = new TreePath(defaultMutableTreeNode2.getPath());
            }
            if (n != 1 || treePath != null) continue;
            treePath = new TreePath(defaultMutableTreeNode2.getPath());
            this.m_tree.requestFocus();
        }
        if (treePath != null) {
            this.m_tree.setSelectionPath(treePath);
            this.ensureVisible(treePath);
        }
    }

    public void programUpdated(PgmEvent pgmEvent) {
    }

    public void programRemoved(PgmEvent pgmEvent) {
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        int n = pgmEvent.getCount();
        for (int i = 0; i < n; ++i) {
            PgmDescriptor pgmDescriptor = pgmEvent.getDescriptorAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode = this.pgmTypeToNode(pgmDescriptor.getPgmType());
            int n2 = pgmManager.programSortOrder(pgmDescriptor.getPgmPath(), pgmDescriptor.getPgmType());
            if ((n2 = n2 * -1 - 1) >= defaultMutableTreeNode.getChildCount()) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            this.m_treeModel.removeNodeFromParent(defaultMutableTreeNode2);
        }
    }

    public void programsCleared(PgmEvent pgmEvent) {
        this.m_pgmNode.removeAllChildren();
        this.m_srvPgmNode.removeAllChildren();
        this.m_classNode.removeAllChildren();
        this.m_treeModel.reload();
    }

    public boolean programExists(DefaultMutableTreeNode defaultMutableTreeNode, PgmDescriptor pgmDescriptor, int n) {
        if (defaultMutableTreeNode.getChildCount() <= n) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
        PgmDescriptor pgmDescriptor2 = (PgmDescriptor)defaultMutableTreeNode2.getUserObject();
        return pgmDescriptor.getPgmLibrary().equals(pgmDescriptor2.getPgmLibrary()) && pgmDescriptor.getPgmName().equals(pgmDescriptor2.getPgmName()) && pgmDescriptor.getPgmType() == pgmDescriptor2.getPgmType();
    }

    public void lookAndFeelChanged(LAFEvent lAFEvent) {
        this.lookAndFeelModifications();
    }

    private boolean handlePopupMenu(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.isPopupTrigger()) {
            TreePath treePath = this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                if (this.m_tree.isPathSelected(treePath)) {
                    this.prepareActionContext(this.m_treeSelect.getSelectionPaths());
                } else {
                    this.m_tree.setSelectionPath(treePath);
                }
            } else {
                this.prepareActionContext(null);
            }
            this.m_contextMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_ctxt.setActivePanel(this);
        ((JComponent)mouseEvent.getSource()).requestFocus();
        if (!this.handlePopupMenu(mouseEvent)) {
            TreePath treePath = this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                this.prepareActionContext(this.m_treeSelect.getSelectionPaths());
            }
            if (mouseEvent.getClickCount() == 2 && treePath != null) {
                PgmDescriptor pgmDescriptor;
                Action action = null;
                if (this.isModulePath(treePath)) {
                    action = this.m_ctxt.getAction("gosrc");
                } else if (this.isPgmPath(treePath) && (pgmDescriptor = (PgmDescriptor)this.getUserObject(treePath, 2)).isJavaClass()) {
                    action = this.m_ctxt.getAction("gosrc");
                }
                if (action != null) {
                    action.run();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupMenu(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Action action;
        String string = actionEvent.getActionCommand();
        if (string.equals(DELETE) && this.m_tree.hasFocus() && (action = this.m_ctxt.getAction("rmvpgm")) != null && action.isEnabled()) {
            action.run();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.prepareActionContext(this.m_treeSelect.getSelectionPaths());
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void contextChanged(ContextEvent contextEvent) {
        switch (contextEvent.getType()) {
            case 0: {
                TreePath treePath = null;
                int n = contextEvent.getPgmType();
                String string = contextEvent.getPgmName();
                String string2 = contextEvent.getModuleName();
                String string3 = string + "." + string2;
                DefaultMutableTreeNode defaultMutableTreeNode = this.pgmTypeToNode(n);
                if (defaultMutableTreeNode == null) break;
                if (n == 0 || n == 1) {
                    DefaultMutableTreeNode defaultMutableTreeNode2;
                    DefaultMutableTreeNode defaultMutableTreeNode3 = this.searchChildren(defaultMutableTreeNode, 0, string.toUpperCase());
                    if (defaultMutableTreeNode3 == null || (defaultMutableTreeNode2 = this.searchChildren(defaultMutableTreeNode3, 0, string2.toUpperCase())) == null) break;
                    treePath = new TreePath(defaultMutableTreeNode2.getPath());
                } else if (n == 2) {
                    DefaultMutableTreeNode defaultMutableTreeNode4 = this.searchChildren(defaultMutableTreeNode, 0, string3.toUpperCase());
                    if (defaultMutableTreeNode4 == null) break;
                    treePath = new TreePath(defaultMutableTreeNode4.getPath());
                }
                if (treePath == null) break;
                this.m_tree.expandPath(treePath);
                this.m_tree.setSelectionPath(treePath);
                this.ensureVisible(treePath);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private class ProgramRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon m_pgmIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg032.gif");
        private ImageIcon m_srvPgmIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg033.gif");
        private ImageIcon m_moduleIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg034.gif");
        private ImageIcon m_classIcon = MRI.getIcon(0, "/com/ibm/iseries/debug/dbg036.gif");

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof PgmDescriptor) {
                PgmDescriptor pgmDescriptor = (PgmDescriptor)object2;
                switch (pgmDescriptor.getPgmType()) {
                    case 0: {
                        this.setIcon(this.m_pgmIcon);
                        break;
                    }
                    case 1: {
                        this.setIcon(this.m_srvPgmIcon);
                        break;
                    }
                    case 2: {
                        this.setIcon(this.m_classIcon);
                    }
                }
            } else if (object2 instanceof ModuleDescriptor) {
                this.setIcon(this.m_moduleIcon);
            } else if (bl3 && object2 instanceof String) {
                String string = (String)object2;
                if (string.equals(MRI.get("DBG_PROGRAMS"))) {
                    this.setIcon(this.m_pgmIcon);
                } else if (string.equals(MRI.get("DBG_SERVICE_PROGRAMS"))) {
                    this.setIcon(this.m_srvPgmIcon);
                } else {
                    this.setIcon(this.m_classIcon);
                }
            }
            return this;
        }
    }
}

