/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.panel;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.MonitorDescriptor;
import com.ibm.iseries.debug.VariableDescriptor;
import com.ibm.iseries.debug.event.ContextEvent;
import com.ibm.iseries.debug.event.PgmEvent;
import com.ibm.iseries.debug.event.VariableEvent;
import com.ibm.iseries.debug.event.WatchEvent;
import com.ibm.iseries.debug.listener.PgmListener;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.panel.VariablesPanel;
import com.ibm.iseries.debug.util.Action;
import com.ibm.iseries.debug.util.ContextMenu;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugFile;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabbedPane;
import com.ibm.iseries.debug.util.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class MonitorsPanel
extends VariablesPanel
implements PgmListener,
DebugConstants,
ActionListener {
    public static final String KEY = "monitors";
    protected static final String GIF = "/com/ibm/iseries/debug/dbg019.gif";
    protected static final String DELETE = "delete";
    protected static final int COL_COUNT = 6;
    protected static final int VALUE_COL = 0;
    protected static final int LIB_COL = 1;
    protected static final int PGM_COL = 2;
    protected static final int MODULE_COL = 3;
    protected static final int LINE_COL = 4;
    protected static final int WATCH_COL = 5;
    protected ArrayList m_monitors = new ArrayList();
    protected HashMap m_watches = new HashMap();
    protected int m_currentColumnCount;
    protected int[] m_currentColumns;
    protected HashMap m_columnNameToId = new HashMap();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public MonitorsPanel() {
        super(2, MRI.get("DBG_MONITORS"), MRI.getIcon(0, GIF));
        for (int i = 0; i < 6; ++i) {
            this.m_columnNameToId.put(this.getColumnNameFromId(i), new Integer(i));
        }
        this.m_tree.registerKeyboardAction(this, DELETE, KeyStroke.getKeyStroke(127, 0), 0);
        this.m_table.registerKeyboardAction(this, DELETE, KeyStroke.getKeyStroke(127, 0), 0);
    }

    protected JComponent getMonitorPane() {
        return this.m_pane;
    }

    protected int getMonitorCount() {
        return this.m_monitors.size();
    }

    public boolean monitorExists(MonitorDescriptor monitorDescriptor) {
        boolean bl = false;
        int n = this.m_monitors.size();
        for (int i = 0; i < n; ++i) {
            MonitorDescriptor monitorDescriptor2 = (MonitorDescriptor)this.m_monitors.get(i);
            if (!monitorDescriptor2.getName().equals(monitorDescriptor.getName()) || monitorDescriptor2.getLineNum() != monitorDescriptor.getLineNum() || !monitorDescriptor2.getViewId().equals(monitorDescriptor.getViewId())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void deleteMonitor() {
        VariableDescriptor variableDescriptor;
        int n;
        if (this.m_actionNode != null && (n = Collections.binarySearch(this.m_monitors, (variableDescriptor = (VariableDescriptor)this.m_actionNode.getUserObject()).getName())) >= 0) {
            this.m_monitors.remove(n);
            this.clearAllWatches((MonitorTreeNode)this.m_actionNode);
            this.clearAllAttributes(variableDescriptor, true);
            this.m_treeModel.removeNodeFromParent(this.m_actionNode);
            this.m_pane.refreshTreeAndTable();
            this.m_actionNode = null;
            if (this.m_monitors.size() == 0) {
                this.clearAllAttributes();
            }
            this.clearActionContext();
        }
    }

    public void deleteAllMonitors() {
        this.clear(false);
        this.clearActionContext();
    }

    public String getWatchName(int n) {
        String string = "";
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Object object = this.m_watches.values().iterator();
        while (object.hasNext()) {
            MonitorTreeNode monitorTreeNode = (MonitorTreeNode)object.next();
            if (monitorTreeNode.m_watchNum != n) continue;
            defaultMutableTreeNode = monitorTreeNode;
            break;
        }
        if (defaultMutableTreeNode != null && (object = (VariableDescriptor)defaultMutableTreeNode.getUserObject()) != null) {
            switch (((VariableDescriptor)object).getType()) {
                case 31: 
                case 32: 
                case 33: {
                    string = "*" + ((VariableDescriptor)object).getEvalName();
                    break;
                }
                default: {
                    string = ((VariableDescriptor)object).getEvalName();
                }
            }
        }
        return string;
    }

    public String getWatchName(VariableDescriptor variableDescriptor) {
        String string = "";
        MonitorTreeNode monitorTreeNode = (MonitorTreeNode)this.m_watches.get(this.key(variableDescriptor));
        if (monitorTreeNode != null) {
            switch (variableDescriptor.getType()) {
                case 31: 
                case 32: 
                case 33: {
                    string = "*" + variableDescriptor.getEvalName();
                    break;
                }
                default: {
                    string = variableDescriptor.getEvalName();
                }
            }
        }
        return string;
    }

    protected void clearAllWatches(MonitorTreeNode monitorTreeNode) {
        Iterator iterator = this.m_watches.values().iterator();
        while (iterator.hasNext()) {
            MonitorTreeNode monitorTreeNode2 = (MonitorTreeNode)iterator.next();
            if (!monitorTreeNode.isNodeDescendant(monitorTreeNode2)) continue;
            VariableDescriptor variableDescriptor = (VariableDescriptor)monitorTreeNode2.getUserObject();
            this.m_varMgr.requestWatchRmv(variableDescriptor, monitorTreeNode2.m_watchNum);
            this.m_watches.remove(this.key(variableDescriptor));
        }
    }

    protected int maxColCount() {
        return 6;
    }

    protected boolean isValidColId(int n) {
        return true;
    }

    protected int mapColIndex(int n) {
        if (!this.m_isLtoR) {
            n = this.m_currentColumnCount - n - 1;
        }
        return n;
    }

    public void init(DebugContext debugContext, TabbedPane tabbedPane) {
        super.init(debugContext, tabbedPane);
        this.restoreSettings();
    }

    public void cleanUp() {
        this.m_monitors.clear();
        this.m_watches.clear();
        this.m_columnNameToId.clear();
        this.m_monitors = null;
        this.m_watches = null;
        this.m_columnNameToId = null;
        super.cleanUp();
    }

    public String getHelpId() {
        return "dbgmonitor_p";
    }

    public String getKey() {
        return KEY;
    }

    public boolean canDoColumns() {
        return true;
    }

    public ArrayList getAvailableColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_currentColumnCount < this.maxColCount()) {
            for (int i = 0; i < 6; ++i) {
                if (!this.isValidColId(i)) continue;
                boolean bl = false;
                for (int j = 0; j < this.m_currentColumnCount; ++j) {
                    if (this.m_currentColumns[j] != i) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(this.getColumnNameFromId(i));
            }
        }
        return arrayList;
    }

    public ArrayList getCurrentColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.m_currentColumnCount; ++i) {
            int n = this.mapColIndex(i);
            arrayList.add(this.getColumnNameFromId(this.m_currentColumns[n]));
        }
        return arrayList;
    }

    public void setCurrentColumns(ArrayList arrayList) {
        this.m_currentColumnCount = arrayList.size();
        this.m_currentColumns = new int[this.m_currentColumnCount];
        for (int i = 0; i < this.m_currentColumnCount; ++i) {
            String string = (String)arrayList.get(i);
            Integer n = (Integer)this.m_columnNameToId.get(string);
            int n2 = this.mapColIndex(i);
            this.m_currentColumns[n2] = n;
        }
        this.m_tableModel.fireTableStructureChanged();
    }

    public void saveSettings() {
        int n;
        String string = this.getKey();
        if (this.m_currentColumnCount != this.maxColCount()) {
            for (n = this.m_currentColumnCount; n < 6; ++n) {
                this.m_userCfg.remove(string + "Col" + n);
                this.m_userCfg.remove(string + "Col" + n + "Width");
            }
        }
        this.m_userCfg.setInt(string + "Cols", this.m_currentColumnCount);
        for (n = 0; n < this.m_currentColumnCount; ++n) {
            int n2 = this.mapColIndex(n);
            this.m_userCfg.setInt(string + "Col" + n, this.m_currentColumns[n2]);
            this.m_userCfg.setInt(string + "Col" + n + "Width", this.m_table.getColumnModel().getColumn(n2).getWidth());
        }
    }

    public void restoreSettings() {
        int n;
        int n2;
        String string = this.getKey();
        this.m_currentColumnCount = this.m_userCfg.getInt(string + "Cols", 0);
        if (this.m_currentColumnCount <= 0) {
            this.initDefaultColumns();
            return;
        }
        this.m_currentColumns = new int[this.m_currentColumnCount];
        for (n2 = 0; n2 < this.m_currentColumnCount; ++n2) {
            n = this.mapColIndex(n2);
            this.m_currentColumns[n] = this.m_userCfg.getInt(string + "Col" + n2, -1);
            if (this.m_currentColumns[n] >= 0) continue;
            this.initDefaultColumns();
            return;
        }
        this.m_tableModel.fireTableStructureChanged();
        for (n2 = 0; n2 < this.m_currentColumnCount; ++n2) {
            n = this.mapColIndex(n2);
            int n3 = this.m_userCfg.getInt(string + "Col" + n2 + "Width", -1);
            if (n3 < 0) continue;
            this.m_table.getColumnModel().getColumn(n).setPreferredWidth(n3);
        }
    }

    protected void initDefaultColumns() {
        this.m_currentColumnCount = 2;
        this.m_currentColumns = new int[this.m_currentColumnCount];
        this.m_currentColumns[this.mapColIndex((int)0)] = 0;
        this.m_currentColumns[this.mapColIndex((int)1)] = 5;
        this.m_tableModel.fireTableStructureChanged();
    }

    protected String getColumnNameFromId(int n) {
        switch (n) {
            case 0: {
                return MRI.get("DBG_VALUE");
            }
            case 1: {
                return MRI.get("DBG_LIBRARY");
            }
            case 2: {
                return MRI.get("DBG_PROGRAM");
            }
            case 3: {
                return MRI.get("DBG_MODULE");
            }
            case 4: {
                return MRI.get("DBG_LINE");
            }
            case 5: {
                return MRI.get("DBG_WATCH");
            }
        }
        return "";
    }

    protected AbstractTableModel createTableModel() {
        return new TblModel();
    }

    protected DefaultMutableTreeNode createTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, VariableDescriptor variableDescriptor) {
        return new MonitorTreeNode(defaultMutableTreeNode, variableDescriptor);
    }

    protected String key(VariableDescriptor variableDescriptor) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(variableDescriptor.getEvalName());
        stringBuffer.append("_");
        stringBuffer.append(variableDescriptor.getType());
        stringBuffer.append("_");
        stringBuffer.append(variableDescriptor.getViewId());
        stringBuffer.append("_");
        stringBuffer.append(variableDescriptor.getLineNum());
        return stringBuffer.toString();
    }

    protected void requestVariables() {
        if (this.m_monitors.size() == 0) {
            return;
        }
        this.forgetEvalVariables();
        this.m_varMgr.requestMonitors(this.m_monitors, this.m_ctxt.getVariableDisplayMask());
    }

    protected void forgetEvalVariables() {
        Iterator iterator = this.m_forget.values().iterator();
        while (iterator.hasNext()) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)iterator.next();
            String string = this.key(variableDescriptor);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_nodes.get(string);
            this.clearAllAttributes(variableDescriptor, false);
            if (defaultMutableTreeNode == null) continue;
            defaultMutableTreeNode.removeAllChildren();
            this.m_treeModel.reload(defaultMutableTreeNode);
        }
        super.forgetEvalVariables();
    }

    public void clearAllAttributes() {
        super.clearAllAttributes();
        this.m_monitors.clear();
        this.m_watches.clear();
    }

    protected void lookAndFeelModifications() {
        super.lookAndFeelModifications();
        Settings settings = this.m_ctxt.getConfig();
        Settings settings2 = this.m_ctxt.getUserConfig();
        this.m_contextMenu = (ContextMenu)Util.loadObject(settings.getString("monitorsContextMenu", null));
        this.m_contextMenu.init(this.m_ctxt.getActionGroup());
        this.m_validate = settings2.getBool("validateDerefs", false);
    }

    protected void prepareActionContext(int n) {
        super.prepareActionContext(n);
        if (!this.m_tree.hasFocus() && !this.m_table.hasFocus()) {
            return;
        }
        boolean bl = false;
        if (n >= 0) {
            TreePath treePath = this.m_tree.getPathForRow(n);
            VariableDescriptor variableDescriptor = this.getVariableDescriptor(n);
            this.m_ctxt.getActionGroup().setGotoSrcContext(variableDescriptor.getViewId(), variableDescriptor.getLineNum());
            bl = treePath.getPathCount() == 2;
        }
        this.m_ctxt.enableAction("dltmon", bl);
        this.m_ctxt.enableAction("dltamon", this.m_monitors.size() > 0);
        this.m_ctxt.enableAction("gosrc", true);
    }

    protected void clearActionContext() {
        super.clearActionContext();
        this.m_ctxt.enableAction("dltmon", false);
        this.m_ctxt.enableAction("dltamon", this.m_monitors.size() > 0);
        this.m_ctxt.enableAction("gosrc", false);
    }

    public void variablesAvailable(VariableEvent variableEvent) {
        int n = variableEvent.getDescriptorCount();
        if (this.m_root.getChildCount() == 0) {
            for (int i = 0; i < n; ++i) {
                VariableDescriptor variableDescriptor = variableEvent.getDescriptorAt(i);
                this.insertVariableNode(this.m_root, variableDescriptor, i, false);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                VariableDescriptor[] variableDescriptorArray;
                VariableDescriptor variableDescriptor = variableEvent.getDescriptorAt(i);
                String string = this.key(variableDescriptor);
                MonitorTreeNode monitorTreeNode = (MonitorTreeNode)this.m_nodes.get(string);
                if (monitorTreeNode == null && variableDescriptor.getType() == -1 && (monitorTreeNode = (MonitorTreeNode)this.m_root.getChildAt(i)) != null) {
                    monitorTreeNode.removeAllChildren();
                    variableDescriptorArray = (VariableDescriptor[])monitorTreeNode.getUserObject();
                    variableDescriptor.setType(variableDescriptorArray.getType());
                }
                if (monitorTreeNode == null) continue;
                if (monitorTreeNode.getChildCount() != variableDescriptor.getChildCount()) {
                    if (variableDescriptor.isValidPtr() || variableDescriptor.isArray() && !variableDescriptor.hasChildren()) {
                        if (!this.isDerefed(string) && !this.isBounded(string)) continue;
                        this.updateVariableNode(variableDescriptor);
                        continue;
                    }
                    monitorTreeNode.removeAllChildren();
                    this.setVariableDescriptor(monitorTreeNode, variableDescriptor);
                    if (!variableDescriptor.hasChildren()) continue;
                    this.rememberExpanded(string, variableDescriptor, new TreePath(monitorTreeNode.getPath()));
                    variableDescriptorArray = variableDescriptor.getChildren();
                    for (int j = 0; j < variableDescriptorArray.length; ++j) {
                        this.insertVariableNode(monitorTreeNode, variableDescriptorArray[j], j, false);
                    }
                    if (!variableDescriptor.isPtr() || !variableDescriptorArray[0].isStruct()) continue;
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)monitorTreeNode.getChildAt(0);
                    TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                    String string2 = this.key(variableDescriptorArray[0]);
                    this.rememberExpanded(string2, variableDescriptorArray[0], treePath);
                    continue;
                }
                this.updateVariableNode(variableDescriptor);
            }
        }
        this.restoreTreeState(true);
        this.requestEvalVariables();
    }

    public void monitorCreated(VariableEvent variableEvent) {
        String string;
        VariableDescriptor variableDescriptor = variableEvent.getDescriptorAt(0);
        String string2 = variableDescriptor.getName();
        if (!string2.equals(string = variableDescriptor.getEvalName()) && string2.length() == string.length()) {
            variableDescriptor.setName(variableDescriptor.getEvalName());
        }
        PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        MonitorDescriptor monitorDescriptor = new MonitorDescriptor(pgmManager, variableDescriptor.getName(), variableDescriptor.getViewId(), variableDescriptor.getLineNum());
        this.m_monitors.add(monitorDescriptor);
        Collections.sort(this.m_monitors);
        int n = Collections.binarySearch(this.m_monitors, monitorDescriptor.getName());
        if (n >= 0) {
            monitorDescriptor.setVarType(variableDescriptor.getType());
            this.insertVariableNode(this.m_root, variableDescriptor, n, true);
            String string3 = this.key(variableDescriptor);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_nodes.get(string3);
            if (defaultMutableTreeNode != null) {
                this.m_actionPath = new TreePath(defaultMutableTreeNode.getPath());
                if (variableDescriptor.hasChildren()) {
                    this.rememberExpanded(string3, variableDescriptor, this.m_actionPath);
                }
            }
            this.m_tree.requestFocus();
            this.restoreTreeState(true);
        }
    }

    public void watchAdded(WatchEvent watchEvent) {
        Object[] objectArray;
        VariableDescriptor variableDescriptor = watchEvent.getDescriptor();
        MonitorTreeNode monitorTreeNode = (MonitorTreeNode)this.m_nodes.get(this.key(variableDescriptor));
        if (monitorTreeNode == null) {
            Iterator iterator = this.m_watches.values().iterator();
            while (iterator.hasNext()) {
                objectArray = (Object[])iterator.next();
                if (((MonitorTreeNode)objectArray).m_watchNum != watchEvent.getWatchNum()) continue;
                monitorTreeNode = objectArray;
                break;
            }
        }
        if (monitorTreeNode != null) {
            monitorTreeNode.m_watch = new Boolean(true);
            monitorTreeNode.m_watchNum = watchEvent.getWatchNum();
            int n = this.m_tree.getRowForPath(new TreePath(monitorTreeNode.getPath()));
            this.m_tableModel.fireTableDataChanged();
            this.m_table.setRowSelectionInterval(n, n);
            this.m_watches.put(this.key(variableDescriptor), monitorTreeNode);
            objectArray = new Object[]{this.getWatchName(variableDescriptor), watchEvent.getWatchAddress(), new Integer(watchEvent.getWatchLength())};
            String string = MessageFormat.format(MRI.get("DBG_WATCH_ACTIVE_FMT"), objectArray);
            this.m_ctxt.setMessage(string);
        }
    }

    public void watchRemoved(WatchEvent watchEvent) {
        VariableDescriptor variableDescriptor = watchEvent.getDescriptor();
        MonitorTreeNode monitorTreeNode = (MonitorTreeNode)this.m_nodes.get(this.key(variableDescriptor));
        if (monitorTreeNode == null) {
            Iterator iterator = this.m_watches.values().iterator();
            while (iterator.hasNext()) {
                MonitorTreeNode monitorTreeNode2 = (MonitorTreeNode)iterator.next();
                if (monitorTreeNode2.m_watchNum != watchEvent.getWatchNum()) continue;
                monitorTreeNode = monitorTreeNode2;
                break;
            }
        }
        if (monitorTreeNode != null) {
            monitorTreeNode.m_watch = new Boolean(false);
            monitorTreeNode.m_watchNum = watchEvent.getWatchNum();
            int n = this.m_tree.getRowForPath(new TreePath(monitorTreeNode.getPath()));
            this.m_tableModel.fireTableDataChanged();
            this.m_table.setRowSelectionInterval(n, n);
            this.m_watches.remove(this.key(variableDescriptor));
            this.m_ctxt.clearMessage();
        }
    }

    public void watchError(WatchEvent watchEvent) {
        String string = this.key(watchEvent.getDescriptor());
        MonitorTreeNode monitorTreeNode = (MonitorTreeNode)this.m_nodes.get(string);
        if (monitorTreeNode != null) {
            monitorTreeNode.m_watch = new Boolean(false);
            monitorTreeNode.m_watchNum = -1;
            this.m_watches.remove(string);
            this.m_tableModel.fireTableDataChanged();
        }
    }

    public void allWatchesRemoved(WatchEvent watchEvent) {
        Iterator iterator = this.m_watches.values().iterator();
        while (iterator.hasNext()) {
            MonitorTreeNode monitorTreeNode = (MonitorTreeNode)iterator.next();
            if (monitorTreeNode == null) continue;
            monitorTreeNode.m_watch = new Boolean(false);
            monitorTreeNode.m_watchNum = -1;
        }
        this.m_watches.clear();
        this.m_tableModel.fireTableDataChanged();
    }

    public int openEnvironment(DebugFile debugFile, String string, String string2) throws IOException {
        if (debugFile.readBytesAvailable() == 0) {
            return 0;
        }
        boolean bl = string.length() > 0 && string2.length() > 0;
        int n = debugFile.readInt();
        for (int i = 0; i < n; ++i) {
            String string3 = debugFile.readString();
            String string4 = debugFile.readString();
            int n2 = debugFile.readInt();
            String string5 = debugFile.readString();
            String string6 = debugFile.readString();
            int n3 = debugFile.readInt();
            int n4 = debugFile.readInt();
            if (bl && string3.equals(string)) {
                string3 = string2;
            }
            MonitorDescriptor monitorDescriptor = new MonitorDescriptor(n3, string3, string4, n2, string5, string6, n4);
            this.m_monitors.add(monitorDescriptor);
        }
        if (n > 0) {
            this.m_ctxt.getManager("pgmmgr").addListener(this);
        }
        return n;
    }

    public void saveEnvironment(DebugFile debugFile) throws IOException {
        if (this.m_monitors == null) {
            return;
        }
        int n = this.m_monitors.size();
        debugFile.writeInt(n);
        for (int i = 0; i < n; ++i) {
            MonitorDescriptor monitorDescriptor = (MonitorDescriptor)this.m_monitors.get(i);
            debugFile.writeString(monitorDescriptor.getPgmLibrary());
            debugFile.writeString(monitorDescriptor.getPgmName());
            debugFile.writeInt(monitorDescriptor.getPgmType());
            debugFile.writeString(monitorDescriptor.getModuleName());
            debugFile.writeString(monitorDescriptor.getName());
            debugFile.writeInt(monitorDescriptor.getLineNum());
            debugFile.writeInt(monitorDescriptor.getVarType());
        }
    }

    public void contextChanged(ContextEvent contextEvent) {
        super.contextChanged(contextEvent);
        switch (contextEvent.getType()) {
            case 0: {
                this.m_ctxt.enableAction("newmon", true);
                break;
            }
            case 3: 
            case 4: {
                this.m_ctxt.enableAction("newmon", false);
                break;
            }
        }
    }

    public void programAdded(PgmEvent pgmEvent) {
        if (pgmEvent.getInitiatedFrom() == 1) {
            int n = this.m_monitors.size();
            PgmManager pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr");
            for (int i = 0; i < n; ++i) {
                MonitorDescriptor monitorDescriptor = (MonitorDescriptor)this.m_monitors.get(i);
                monitorDescriptor.setViewId(pgmManager.getViewId(monitorDescriptor.getPgmLibrary(), monitorDescriptor.getPgmName(), monitorDescriptor.getPgmType(), monitorDescriptor.getModuleName()));
                VariableDescriptor variableDescriptor = new VariableDescriptor(monitorDescriptor.getViewId(), monitorDescriptor.getLineNum(), monitorDescriptor.getName(), monitorDescriptor.getName(), monitorDescriptor.getVarType());
                this.insertVariableNode(this.m_root, variableDescriptor, i, true);
            }
            if (n > 0) {
                this.m_treeModel.reload();
            }
            pgmManager.removeListener(this);
        }
    }

    public void programUpdated(PgmEvent pgmEvent) {
    }

    public void programRemoved(PgmEvent pgmEvent) {
    }

    public void programsCleared(PgmEvent pgmEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Action action;
        String string = actionEvent.getActionCommand();
        if (string.equals(DELETE) && (action = this.m_ctxt.getAction("dltmon")) != null && action.isEnabled()) {
            action.run();
        }
    }

    protected class TblModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return MonitorsPanel.this.m_currentColumnCount;
        }

        public int getRowCount() {
            return MonitorsPanel.this.m_tree != null ? MonitorsPanel.this.m_tree.getRowCount() : 0;
        }

        public String getColumnName(int n) {
            return MonitorsPanel.this.getColumnNameFromId(MonitorsPanel.this.m_currentColumns[n]);
        }

        public Object getValueAt(int n, int n2) {
            VariableDescriptor variableDescriptor = MonitorsPanel.this.getVariableDescriptor(n);
            TreePath treePath = MonitorsPanel.this.m_tree.getPathForRow(n);
            MonitorTreeNode monitorTreeNode = (MonitorTreeNode)treePath.getLastPathComponent();
            switch (MonitorsPanel.this.m_currentColumns[n2]) {
                case 0: {
                    return variableDescriptor.getValue();
                }
                case 1: {
                    return monitorTreeNode.m_monitor != null ? monitorTreeNode.m_monitor.getPgmLibrary() : "";
                }
                case 2: {
                    return monitorTreeNode.m_monitor != null ? monitorTreeNode.m_monitor.getPgmName() : "";
                }
                case 3: {
                    return monitorTreeNode.m_monitor != null ? monitorTreeNode.m_monitor.getModuleName() : "";
                }
                case 4: {
                    return String.valueOf(variableDescriptor.getLineNum());
                }
                case 5: {
                    return monitorTreeNode.m_watch;
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            TreePath treePath = MonitorsPanel.this.m_tree.getPathForRow(n);
            MonitorTreeNode monitorTreeNode = (MonitorTreeNode)treePath.getLastPathComponent();
            VariableDescriptor variableDescriptor = (VariableDescriptor)monitorTreeNode.getUserObject();
            if (variableDescriptor == null) {
                return;
            }
            switch (MonitorsPanel.this.m_currentColumns[n2]) {
                case 0: {
                    String string = (String)object;
                    if (string.equals(variableDescriptor.getValue())) break;
                    MonitorsPanel.this.m_varMgr.requestModify(MonitorsPanel.this.m_panelId, variableDescriptor, string, MonitorsPanel.this.m_ctxt.getVariableDisplayMask());
                    variableDescriptor.setValue(string);
                    break;
                }
                case 5: {
                    monitorTreeNode.m_watch = (Boolean)object;
                    if (monitorTreeNode.m_watch.booleanValue()) {
                        MonitorsPanel.this.m_varMgr.requestWatchAdd(variableDescriptor, monitorTreeNode.m_watchNum);
                        break;
                    }
                    MonitorsPanel.this.m_varMgr.requestWatchRmv(variableDescriptor, monitorTreeNode.m_watchNum);
                }
            }
        }

        public Class getColumnClass(int n) {
            if (n >= MonitorsPanel.this.m_currentColumnCount) {
                return class$java$lang$String == null ? (class$java$lang$String = MonitorsPanel.class$("java.lang.String")) : class$java$lang$String;
            }
            if (MonitorsPanel.this.m_currentColumns[n] == 5) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = MonitorsPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            return class$java$lang$String == null ? (class$java$lang$String = MonitorsPanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int n, int n2) {
            switch (MonitorsPanel.this.m_currentColumns[n2]) {
                case 0: {
                    VariableDescriptor variableDescriptor = MonitorsPanel.this.getVariableDescriptor(n);
                    switch (variableDescriptor.getType()) {
                        case 0: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            return false;
                        }
                    }
                    return true;
                }
                case 5: {
                    return true;
                }
            }
            return false;
        }
    }

    protected class MonitorTreeNode
    extends DefaultMutableTreeNode {
        private MonitorDescriptor m_monitor;
        private Boolean m_watch;
        private int m_watchNum;

        public MonitorTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, VariableDescriptor variableDescriptor) {
            MonitorTreeNode monitorTreeNode;
            super(variableDescriptor);
            this.m_monitor = null;
            this.m_watch = null;
            this.m_watchNum = -1;
            if (defaultMutableTreeNode == MonitorsPanel.this.m_root) {
                int n = Collections.binarySearch(MonitorsPanel.this.m_monitors, variableDescriptor.getName());
                this.m_monitor = (MonitorDescriptor)MonitorsPanel.this.m_monitors.get(n);
            } else {
                TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                monitorTreeNode = (MonitorTreeNode)treePath.getPathComponent(1);
                this.m_monitor = monitorTreeNode.m_monitor;
            }
            if (MonitorsPanel.this.m_watches.size() > 0) {
                String string = MonitorsPanel.this.key(variableDescriptor);
                monitorTreeNode = (MonitorTreeNode)MonitorsPanel.this.m_watches.get(string);
                if (monitorTreeNode != null) {
                    this.m_watch = monitorTreeNode.m_watch;
                    this.m_watchNum = monitorTreeNode.m_watchNum;
                    MonitorsPanel.this.m_watches.put(string, this);
                } else {
                    this.m_watch = new Boolean(false);
                }
            } else {
                this.m_watch = new Boolean(false);
            }
        }
    }
}

