/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.event.MemoryEvent;
import com.ibm.iseries.debug.manager.MemoryManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.packet.DebuggerPacket;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.MRI;
import java.io.IOException;

public class MemoryAddrPacket
extends DebuggerPacket {
    private static final int READ = 1;
    private static final int WRITE = 2;
    private static final int READ_ONLY = 1;
    private int m_action;
    private String m_addr;
    private String m_hexData;
    private String m_tags;
    private int m_dataFlags;
    private ISeriesMessage m_msgObj;

    public MemoryAddrPacket() {
        super(1525);
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_addr = null;
        this.m_hexData = null;
        this.m_tags = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        this.m_action = commLink.readInt();
        this.m_addr = commLink.readString();
        this.m_hexData = commLink.readString();
        this.m_tags = commLink.readString();
        this.m_dataFlags = commLink.readInt();
        int n2 = commLink.readInt();
        if (n2 == 1) {
            this.m_msgObj = new ISeriesMessage();
            this.m_msgObj.read(commLink);
        }
    }

    public void run() {
        MemoryManager memoryManager = (MemoryManager)this.m_ctxt.getManager("memmgr");
        if (this.m_msgObj == null) {
            MemoryEvent memoryEvent = new MemoryEvent((Object)this, this.m_action, new MemoryAddress(this.m_addr), this.m_hexData, this.m_tags, this.m_dataFlags);
            memoryManager.fireMemoryEvent(memoryEvent);
            if (this.m_action == 2) {
                this.m_ctxt.setMessage(MRI.get("DBG_MEMORY_EDIT_SUCCESSFUL"));
            }
        } else {
            MemoryEvent memoryEvent = new MemoryEvent(this, this.m_action == 1 ? 3 : 4, new MemoryAddress(this.m_addr), this.m_hexData.length() / 2);
            memoryManager.fireMemoryEvent(memoryEvent);
            this.displayMessage(this.m_msgObj);
        }
        this.cleanUp();
    }
}

