/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.packet;

import com.ibm.iseries.debug.ViewDescriptor;
import com.ibm.iseries.debug.event.SourceViewEvent;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.memory.MemoryAddress;
import com.ibm.iseries.debug.packet.SourceViewPacket;
import com.ibm.iseries.debug.util.CommLink;
import java.io.IOException;

public class AssemblerViewPacket
extends SourceViewPacket {
    private static final int DISPLAY_FULL_SCREEN = 0;
    private static final int DISPLAY_IN_SPLIT_SCREEN = 1;
    private String m_startAddress;
    private int m_displayMode;

    public AssemblerViewPacket() {
        this.m_type = 1527;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_startAddress = null;
    }

    public void read(CommLink commLink, int n) throws IOException {
        super.read(commLink, n);
        this.m_startAddress = commLink.readString();
        this.m_displayMode = commLink.readInt();
    }

    public void run() {
        if (this.m_msgObj == null) {
            switch (this.m_displayMode) {
                case 0: {
                    this.displayFullScreen();
                    break;
                }
                case 1: {
                    this.displaySplitScreen();
                }
            }
        } else {
            this.displayMessage(this.m_msgObj);
        }
        this.m_ctxt.retractClock();
        this.cleanUp();
    }

    public void displayFullScreen() {
        PgmManager pgmManager;
        ViewDescriptor viewDescriptor;
        SourceViewEvent sourceViewEvent = new SourceViewEvent(this, this.m_viewId, this.m_source, new MemoryAddress(this.m_startAddress), this.m_startLineNum, this.m_endLineNum, this.m_lineCount);
        SourceViewManager sourceViewManager = (SourceViewManager)this.m_ctxt.getManager("srcmgr");
        sourceViewManager.fireSourceViewEvent(sourceViewEvent);
        if (this.m_lineCount > 0 && (viewDescriptor = (pgmManager = (PgmManager)this.m_ctxt.getManager("pgmmgr")).getView(this.m_viewId)) != null && viewDescriptor.getTotalLineCount() != this.m_lineCount) {
            viewDescriptor.setTotalLineCount(this.m_lineCount);
        }
    }

    public void displaySplitScreen() {
        if (!this.m_ctxt.isDisassemblyShown()) {
            this.m_ctxt.showDisassembly(true, false);
        }
        if (!this.m_ctxt.isDisassemblyActive()) {
            this.m_ctxt.getDisassembly().viewRequestFocus();
        }
        SourceViewEvent sourceViewEvent = new SourceViewEvent(this, this.m_viewId, this.m_source, new MemoryAddress(this.m_startAddress), this.m_startLineNum, this.m_endLineNum, this.m_lineCount);
        this.m_ctxt.getDisassembly().setSourceCode(sourceViewEvent);
        this.m_ctxt.getDisassembly().scrollToLineNum(this.m_startLineNum);
        this.m_ctxt.setActiveSource(this.m_ctxt.getDisassembly());
    }
}

