/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.memory;

import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.memory.MemoryHexView;
import com.ibm.iseries.debug.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class MemoryTagEditor
extends JTextArea
implements CaretListener {
    private static Color s_fg = UIManager.getColor("TextArea.foreground");
    private static Color s_bg = UIManager.getColor("TextArea.background");
    private static Color s_caret = UIManager.getColor("TextArea.caretForeground");
    private MemoryHexView m_view;
    private int m_cursorDirection;
    private boolean m_cursorNotify;
    private boolean m_forceMaxSizeEval;
    private int m_width;
    private boolean m_editing;

    public MemoryTagEditor(MemoryHexView memoryHexView) {
        this.m_view = memoryHexView;
        this.m_cursorDirection = 1;
        this.m_cursorNotify = true;
        this.m_width = -1;
        this.clear();
        this.addCaretListener(this);
    }

    public void cleanUp() {
        this.removeCaretListener(this);
        this.m_view = null;
    }

    public void setEditMode(boolean bl) {
        this.m_editing = bl;
        if (bl) {
            this.setBackground(s_fg);
            this.setForeground(s_bg);
            this.setCaretColor(s_bg);
        } else {
            this.setBackground(s_bg);
            this.setForeground(s_fg);
            this.setCaretColor(s_caret);
        }
    }

    public void clear() {
        if (this.m_width != 0) {
            this.setText("");
            Dimension dimension = this.getMaximumSize();
            if (dimension.width > 0) {
                dimension.width = 0;
                this.setMaximumSize(dimension);
            }
            this.m_forceMaxSizeEval = true;
            this.m_cursorDirection = 1;
            this.m_width = 0;
        }
    }

    public void setTags(String string, boolean bl) {
        int n = string.length();
        if (n == 0) {
            this.clear();
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 3);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(string.charAt(i));
            if (i + 1 >= n) continue;
            stringBuffer.append('\n');
        }
        this.m_cursorNotify = false;
        this.setText(stringBuffer.toString());
        this.setEditable(bl);
        this.m_cursorNotify = true;
        if (this.m_forceMaxSizeEval) {
            this.m_forceMaxSizeEval = false;
            try {
                String string2 = this.getText(0, this.getLineEndOffset(0));
                Dimension dimension = this.getMaximumSize();
                this.m_width = dimension.width = this.getFontMetrics(this.getFont()).stringWidth(string2) + 1;
                this.setMaximumSize(dimension);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public String getTags() {
        StringBuffer stringBuffer = new StringBuffer(this.getText());
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c != ' ' && c != '\n') continue;
            stringBuffer.deleteCharAt(i--);
        }
        return stringBuffer.toString();
    }

    public void setCursorToOffset(int n, boolean bl) {
        if (this.getDocument().getLength() > 0) {
            try {
                int n2 = n / 16;
                int n3 = this.getLineStartOffset(n2) + 1;
                if (n3 < this.getDocument().getLength()) {
                    this.m_cursorNotify = bl;
                    this.setCaretPosition(n3);
                    this.m_cursorNotify = true;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public String getLine(int n) {
        String string = "";
        try {
            int n2 = this.getLineStartOffset(n);
            int n3 = this.getLineEndOffset(n);
            string = this.getText(n2, n3 - n2 - 1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    protected boolean hasSelection() {
        return this.getSelectionStart() != this.getSelectionEnd();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        try {
            int n = this.getDocument().getLength();
            int n2 = caretEvent.getDot();
            if (n > 0 && !this.hasSelection()) {
                if (n2 < n) {
                    char c;
                    String string = this.getText(n2, 1);
                    if (string.length() > 0 && ((c = string.charAt(0)) == ' ' || c == '\n')) {
                        if (n2 == 0) {
                            this.setCaretPosition(1);
                        } else {
                            this.setCaretPosition(n2 + this.m_cursorDirection);
                        }
                    }
                } else {
                    this.setCaretPosition(n - 1);
                }
                if (this.m_cursorNotify) {
                    this.m_view.syncTagCursor(this.getLineOfOffset(n2) * 16);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean isFocusTraversable() {
        return this.getDocument().getLength() > 0 && this.isEditable();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        boolean bl = keyEvent.getID() == 401;
        switch (keyEvent.getKeyCode()) {
            case 8: {
                int n;
                if (bl && (n = this.getCaretPosition()) > 1) {
                    this.m_cursorDirection = -1;
                    this.setCaretPosition(n - 1);
                }
                keyEvent.consume();
                break;
            }
            case 127: {
                if (bl) {
                    this.getToolkit().beep();
                }
                keyEvent.consume();
                break;
            }
            case 35: {
                if (bl) {
                    try {
                        if (keyEvent.getModifiers() == 2) {
                            this.setCaretPosition(this.getDocument().getLength() - 1);
                        } else {
                            this.setCaretPosition(this.getLineEndOffset(this.getLineOfOffset(this.getCaretPosition())) - 1);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                keyEvent.consume();
                break;
            }
            case 37: 
            case 38: 
            case 224: 
            case 226: {
                this.m_cursorDirection = -1;
                break;
            }
            default: {
                this.m_cursorDirection = 1;
                break;
            }
            case 27: {
                if (bl && this.m_editing) {
                    this.m_view.signalCancelEdit();
                }
                keyEvent.consume();
                break;
            }
            case 10: {
                if (bl && this.m_editing) {
                    this.m_view.signalAcceptEdit();
                }
                keyEvent.consume();
            }
        }
        super.processKeyEvent(keyEvent);
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (keyEvent.getKeyChar() == '\b') {
            return true;
        }
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        return bl2 || bl && Character.isLetterOrDigit(keyEvent.getKeyChar());
    }

    public void cut() {
    }

    public void replaceSelection(String string) {
        int n = this.getCaretPosition();
        int n2 = string.length();
        if (n2 == 0 || n >= this.getDocument().getLength()) {
            return;
        }
        if ((string = Util.validateTagData(string)) == null) {
            return;
        }
        n2 = string.length();
        if (this.hasSelection()) {
            this.setCaretPosition(this.getSelectionEnd());
            n = this.getCaretPosition();
        }
        if (n2 == 1) {
            this.replaceRange(string, n, n + 1);
        } else {
            try {
                StringBuffer stringBuffer = new StringBuffer(this.getTags());
                int n3 = this.getLineOfOffset(n);
                if (n3 + n2 > stringBuffer.length()) {
                    string = string.substring(0, stringBuffer.length() - n3);
                    n2 = string.length();
                }
                stringBuffer.replace(n3, n3 + n2, string);
                this.setTags(stringBuffer.toString(), true);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.m_view.tagsModified();
    }

    public void updateUI() {
        super.updateUI();
        this.setFont(SettingsManager.getFixedPitchFont());
    }
}

