/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.memory;

import com.ibm.iseries.debug.DebugConstants;
import java.math.BigInteger;

public class MemoryAddress
implements DebugConstants {
    public static final int ZERO = 0;
    public static final int MAX = 15;
    private String m_addr;

    public MemoryAddress(String string) {
        this.init(string);
    }

    public MemoryAddress(MemoryAddress memoryAddress) {
        this.init(memoryAddress.m_addr);
    }

    public MemoryAddress(int n, int n2) {
        if (n2 > "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF".length()) {
            n2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF".length();
        }
        switch (n) {
            case 15: {
                this.m_addr = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF".substring(0, n2);
                break;
            }
            default: {
                this.m_addr = "0000000000000000000000000000000000000000000000000000000000000000".substring(0, n2);
            }
        }
    }

    private void init(String string) {
        int n = string.length();
        this.m_addr = n == 4 || n == 8 || n == 16 ? new String(string) : (n < 4 ? this.prefixZeros(string, 4) : (n < 8 ? this.prefixZeros(string, 8) : this.prefixZeros(string, 16)));
    }

    private String prefixZeros(String string, int n) {
        if (string.length() < n) {
            string = "0000000000000000000000000000000000000000000000000000000000000000".substring(0, n - string.length()) + string;
        }
        return new String(string);
    }

    private String prefixZeros(BigInteger bigInteger, int n) {
        String string = bigInteger.toString(16).toUpperCase();
        if (string.length() < n) {
            string = "0000000000000000000000000000000000000000000000000000000000000000".substring(0, n - string.length()) + string;
        }
        return string;
    }

    public int getBitCount() {
        return this.m_addr.length() * 4;
    }

    public int getNibbleCount() {
        return this.m_addr.length();
    }

    public int getByteCount() {
        return this.m_addr.length() / 2;
    }

    public String toString() {
        return this.m_addr;
    }

    public String toString(int n) {
        return this.m_addr.substring(0, n) + " " + this.m_addr.substring(n);
    }

    public boolean equals(MemoryAddress memoryAddress) {
        return this.m_addr.equals(memoryAddress.m_addr);
    }

    public boolean equals(String string) {
        return this.m_addr.equals(string);
    }

    public MemoryAddress align(int n) {
        BigInteger bigInteger = new BigInteger(this.m_addr, 16);
        BigInteger bigInteger2 = new BigInteger(String.valueOf(n));
        BigInteger bigInteger3 = bigInteger.mod(bigInteger2);
        int n2 = bigInteger3.intValue();
        if (n2 != 0) {
            bigInteger = bigInteger.subtract(bigInteger3);
        }
        this.m_addr = this.prefixZeros(bigInteger, this.m_addr.length());
        return this;
    }

    public MemoryAddress quadWordAlign() {
        StringBuffer stringBuffer = new StringBuffer(this.m_addr);
        stringBuffer.setCharAt(stringBuffer.length() - 1, '0');
        this.m_addr = stringBuffer.toString();
        return this;
    }

    public boolean isZero() {
        int n = this.m_addr.length();
        for (int i = 0; i < n; ++i) {
            if (this.m_addr.charAt(i) == '0') continue;
            return false;
        }
        return true;
    }

    public boolean isMax() {
        int n = this.m_addr.length();
        for (int i = 0; i < n; ++i) {
            if (this.m_addr.charAt(i) == 'F') continue;
            return false;
        }
        return true;
    }

    public MemoryAddress setZero() {
        this.m_addr = "0000000000000000000000000000000000000000000000000000000000000000".substring(0, this.m_addr.length());
        return this;
    }

    public MemoryAddress setMax() {
        this.m_addr = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF".substring(0, this.m_addr.length());
        return this;
    }

    public int compareTo(MemoryAddress memoryAddress) {
        BigInteger bigInteger = new BigInteger("00" + this.m_addr, 16);
        BigInteger bigInteger2 = new BigInteger("00" + memoryAddress.m_addr, 16);
        return bigInteger.compareTo(bigInteger2);
    }

    public MemoryAddress add(int n) {
        if (n == 0) {
            return new MemoryAddress(this.m_addr);
        }
        BigInteger bigInteger = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF".substring(0, this.m_addr.length()), 16);
        BigInteger bigInteger2 = new BigInteger(this.m_addr, 16);
        BigInteger bigInteger3 = new BigInteger(String.valueOf(n));
        if (bigInteger.subtract(bigInteger3).compareTo(bigInteger2) >= 0) {
            return new MemoryAddress(this.prefixZeros(bigInteger2.add(bigInteger3), this.m_addr.length()));
        }
        return new MemoryAddress(15, this.m_addr.length());
    }

    public MemoryAddress add(String string) {
        if (string == null || string.length() == 0) {
            return new MemoryAddress(this.m_addr);
        }
        BigInteger bigInteger = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF".substring(0, this.m_addr.length()), 16);
        BigInteger bigInteger2 = new BigInteger(this.m_addr, 16);
        BigInteger bigInteger3 = new BigInteger(string, 16);
        if (bigInteger.subtract(bigInteger3).compareTo(bigInteger2) >= 0) {
            return new MemoryAddress(this.prefixZeros(bigInteger2.add(bigInteger3), this.m_addr.length()));
        }
        return new MemoryAddress(15, this.m_addr.length());
    }

    public MemoryAddress addWrap(String string) {
        if (string == null || string.length() == 0) {
            return new MemoryAddress(this.m_addr);
        }
        BigInteger bigInteger = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF".substring(0, this.m_addr.length()), 16);
        BigInteger bigInteger2 = new BigInteger(this.m_addr, 16);
        BigInteger bigInteger3 = new BigInteger(string, 16);
        if (bigInteger.subtract(bigInteger3).compareTo(bigInteger2) >= 0) {
            return new MemoryAddress(this.prefixZeros(bigInteger2.add(bigInteger3), this.m_addr.length()));
        }
        return new MemoryAddress(this.prefixZeros(bigInteger2.add(bigInteger3).clearBit(bigInteger.bitLength()), this.m_addr.length()));
    }

    public MemoryAddress subtract(int n) {
        if (n == 0) {
            return new MemoryAddress(this.m_addr);
        }
        BigInteger bigInteger = new BigInteger(this.m_addr, 16);
        BigInteger bigInteger2 = new BigInteger(String.valueOf(n));
        if (bigInteger.compareTo(bigInteger2) >= 0) {
            return new MemoryAddress(this.prefixZeros(bigInteger.subtract(bigInteger2), this.m_addr.length()));
        }
        return new MemoryAddress(0, this.m_addr.length());
    }

    public MemoryAddress subtract(String string) {
        if (string == null || string.length() == 0) {
            return new MemoryAddress(this.m_addr);
        }
        BigInteger bigInteger = new BigInteger(this.m_addr, 16);
        BigInteger bigInteger2 = new BigInteger(string, 16);
        if (bigInteger.compareTo(bigInteger2) >= 0) {
            return new MemoryAddress(this.prefixZeros(bigInteger.subtract(bigInteger2), this.m_addr.length()));
        }
        return new MemoryAddress(0, this.m_addr.length());
    }

    public MemoryAddress subtractWrap(String string) {
        if (string == null || string.length() == 0) {
            return new MemoryAddress(this.m_addr);
        }
        BigInteger bigInteger = new BigInteger(this.m_addr, 16);
        BigInteger bigInteger2 = new BigInteger(string, 16);
        if (this.m_addr.length() == 16 || bigInteger.subtract(bigInteger2).compareTo(BigInteger.ZERO) >= 0) {
            return new MemoryAddress(this.prefixZeros(bigInteger.subtract(bigInteger2), this.m_addr.length()));
        }
        return new MemoryAddress(this.prefixZeros(Integer.toHexString(bigInteger.subtract(bigInteger2).intValue()).toUpperCase(), this.m_addr.length()));
    }

    public int difference(MemoryAddress memoryAddress) {
        BigInteger bigInteger = new BigInteger(this.m_addr, 16);
        BigInteger bigInteger2 = new BigInteger(memoryAddress.m_addr, 16);
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        return bigInteger3.intValue();
    }

    public boolean canAdd(int n) {
        if (n == 0) {
            return true;
        }
        BigInteger bigInteger = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF".substring(0, this.m_addr.length()), 16);
        BigInteger bigInteger2 = new BigInteger(this.m_addr, 16);
        BigInteger bigInteger3 = new BigInteger(String.valueOf(n));
        return bigInteger.subtract(bigInteger3).compareTo(bigInteger2) >= 0;
    }

    public boolean canAdd(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        BigInteger bigInteger = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF".substring(0, this.m_addr.length()), 16);
        BigInteger bigInteger2 = new BigInteger(this.m_addr, 16);
        BigInteger bigInteger3 = new BigInteger(string, 16);
        return bigInteger.subtract(bigInteger3).compareTo(bigInteger2) >= 0;
    }

    public boolean canSubtract(int n) {
        if (n == 0) {
            return true;
        }
        BigInteger bigInteger = new BigInteger(this.m_addr, 16);
        BigInteger bigInteger2 = new BigInteger(String.valueOf(n));
        return bigInteger.compareTo(bigInteger2) >= 0;
    }

    public boolean canSubtract(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        BigInteger bigInteger = new BigInteger(this.m_addr, 16);
        BigInteger bigInteger2 = new BigInteger(string, 16);
        return bigInteger.compareTo(bigInteger2) >= 0;
    }
}

