/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.manager;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.event.SettingsEvent;
import com.ibm.iseries.debug.listener.SettingsListener;
import com.ibm.iseries.debug.source.AutoEvalTooltip;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Manager;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Tokenizer;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class SettingsManager
extends Manager
implements DebugConstants {
    public static final String KEY = "settmgr";
    public static final int IDBG = 0;
    public static final int PASE = 1;
    public static final int PIRANHA = 2;
    public static final String IDBG_CFG = "com/ibm/iseries/debug/idbg.cfg";
    public static final String IDBG_USER_CFG = ".idbg";
    public static final String IDBG_COMMENT = MRI.get("DBG_SYSTEM_DEBUGGER");
    public static final String PASE_CFG = "com/ibm/iseries/pase/idbgpase.cfg";
    public static final String PASE_USER_CFG = ".idbgpase";
    public static final String PASE_COMMENT = MRI.get("DBG_PASE_DEBUGGER");
    public static final String PIRANHA_CFG = "com/ibm/iseries/piranha/jpiranha.cfg";
    public static final String PIRANHA_USER_CFG = ".jpiranha";
    public static final String PIRANHA_COMMENT = "JPiranha";
    public static final String IDBG_USER_FILE = ".idbguprm";
    public static final String USER_FILE_COMMENT = MRI.get("DBG2_USER_FILE");
    public static final int MAX_RECENT = 20;
    private static SettingsManager[] s_instance = new SettingsManager[3];
    private static FontUIResource s_fixedPitchFontUI = null;
    private Settings m_cfg;
    private Settings m_userCfg;
    private Settings m_userAliases;
    public int m_srcDblClick = 250;
    public FontUIResource m_srcFont;
    public int m_srcTabSize = 4;
    public String m_srcSpaces = "           ";
    public String m_srcTab;
    public int m_srcMaxLines = 5000;
    public ColorUIResource m_srcActiveBg;
    public ColorUIResource m_srcActiveFg;
    public ColorUIResource m_regChangedBg;
    public ColorUIResource m_regChangedFg;
    private int m_pgmMax = 8;
    private ArrayList m_pgms = new ArrayList();
    private ArrayList m_addPgms = new ArrayList();
    private int m_envMax = 8;
    private ArrayList m_envs = new ArrayList();

    public static SettingsManager instance(int n) {
        if (s_instance[n] == null) {
            SettingsManager.s_instance[n] = new SettingsManager();
        }
        return s_instance[n];
    }

    public static Font getFixedPitchFont() {
        return s_fixedPitchFontUI;
    }

    private SettingsManager() {
    }

    public String getKey() {
        return KEY;
    }

    public void init(String string, String string2, String string3) {
        if (this.m_cfg == null && string.length() > 0) {
            boolean bl = false;
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
            if (inputStream != null) {
                try {
                    this.m_cfg = new Settings(inputStream);
                    inputStream.close();
                    bl = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (!bl) {
                System.out.println("SettingsManager.init() " + string + " could not be located...");
                System.exit(-1);
            }
        }
        if (this.m_userCfg == null) {
            this.m_userCfg = new Settings(string2, string3);
            this.m_userCfg.load();
            this.restoreSourceSettings(15);
            this.restoreRegSettings(15);
            this.restoreRecentPgms();
            this.restoreRecentEnvs();
        }
        if (this.m_userAliases == null) {
            String string4 = this.m_userCfg.getString("userFile", "");
            this.m_userAliases = string4 != "" ? new Settings(string4, "", USER_FILE_COMMENT) : new Settings(IDBG_USER_FILE, USER_FILE_COMMENT);
            this.m_userAliases.load();
        }
    }

    public void cleanUp() {
    }

    public Settings getConfig() {
        return this.m_cfg;
    }

    public Settings getUserConfig() {
        return this.m_userCfg;
    }

    public Settings getUserAliases() {
        return this.m_userAliases;
    }

    public void commitUserConfig() {
        this.saveRecentPgms();
        this.saveRecentEnvs();
        this.m_userCfg.commit();
    }

    public void fireSettingsEvent(SettingsEvent settingsEvent) {
        int n = this.m_listeners.size();
        this.m_userCfg.commit();
        this.restoreSourceSettings(settingsEvent.getType());
        this.restoreRegSettings(settingsEvent.getType());
        for (int i = 0; i < n; ++i) {
            SettingsListener settingsListener = (SettingsListener)this.m_listeners.get(i);
            settingsListener.settingsChanged(settingsEvent);
        }
    }

    public int getRecentPgmMax() {
        return this.m_pgmMax;
    }

    public ArrayList getRecentPgms() {
        return this.m_pgms;
    }

    public ArrayList getRecentlyAddedPgms() {
        return this.m_addPgms;
    }

    public void insertRecentPgm(PgmDescriptor pgmDescriptor) {
        int n = this.m_pgms.size();
        String string = pgmDescriptor.getPgmPath();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            PgmDescriptor pgmDescriptor2 = (PgmDescriptor)this.m_pgms.get(i);
            if (!string.equals(pgmDescriptor2.getPgmPath())) continue;
            if (i == 0) {
                if (!pgmDescriptor.getPgmParms().equals(pgmDescriptor2.getPgmParms())) {
                    pgmDescriptor2.setPgmParms(pgmDescriptor.getPgmParms());
                }
                return;
            }
            n2 = i;
            break;
        }
        if (n2 >= 0) {
            this.m_pgms.remove(n2);
        }
        this.m_pgms.add(0, pgmDescriptor);
        if (this.m_pgms.size() > this.m_pgmMax) {
            this.m_pgms.remove(this.m_pgms.size() - 1);
        }
        this.fireSettingsEvent(new SettingsEvent(this, 16));
    }

    public void insertRecentlyAddedPgm(PgmDescriptor pgmDescriptor) {
        int n = this.m_addPgms.size();
        String string = pgmDescriptor.getPgmPath();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            PgmDescriptor pgmDescriptor2 = (PgmDescriptor)this.m_addPgms.get(i);
            if (!string.equals(pgmDescriptor2.getPgmPath())) continue;
            if (i == 0) {
                return;
            }
            n2 = i;
            break;
        }
        if (n2 >= 0) {
            this.m_addPgms.remove(n2);
        }
        this.m_addPgms.add(0, pgmDescriptor);
        if (this.m_addPgms.size() > this.m_pgmMax) {
            this.m_addPgms.remove(this.m_addPgms.size() - 1);
        }
    }

    public int getRecentEnvMax() {
        return this.m_envMax;
    }

    public ArrayList getRecentEnvs() {
        return this.m_envs;
    }

    public void insertRecentEnv(String string, String string2) {
        if (string.endsWith(File.separator + string2)) {
            return;
        }
        int n = this.m_envs.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            String string3 = (String)this.m_envs.get(i);
            if (!string3.equals(string)) continue;
            if (i == 0) {
                return;
            }
            n2 = i;
            break;
        }
        if (n2 >= 0) {
            this.m_envs.remove(n2);
        }
        this.m_envs.add(0, string);
        if (this.m_envs.size() > this.m_envMax) {
            this.m_envs.remove(this.m_envs.size() - 1);
        }
        this.fireSettingsEvent(new SettingsEvent(this, 32));
    }

    private void restoreSourceSettings(int n) {
        int n2;
        if (SettingsEvent.generalChanged(n)) {
            this.m_srcDblClick = this.m_userCfg.getInt("srcDoubleClick", 250);
            this.m_srcTabSize = this.m_userCfg.getInt("srcTabSize", 4);
            this.m_srcTab = this.m_srcSpaces.substring(0, this.m_srcTabSize);
            this.m_srcMaxLines = this.m_userCfg.getInt("srcMaxLines", 5000);
            this.m_pgmMax = this.m_userCfg.getInt("pgmMax", 8);
            while (this.m_pgms.size() > this.m_pgmMax) {
                this.m_pgms.remove(this.m_pgms.size() - 1);
            }
            while (this.m_addPgms.size() > this.m_pgmMax) {
                this.m_addPgms.remove(this.m_addPgms.size() - 1);
            }
            this.m_envMax = this.m_userCfg.getInt("pgmEnvMax", 8);
            while (this.m_envs.size() > this.m_envMax) {
                this.m_envs.remove(this.m_envs.size() - 1);
            }
            int n3 = this.m_userCfg.getInt("autoEvalShowMs", 250);
            n2 = this.m_userCfg.getInt("autoEvalHideMs", 4000);
            AutoEvalTooltip.setShowTimeInMilliseconds(n3);
            AutoEvalTooltip.setHideTimeInMilliseconds(n2);
        }
        if (SettingsEvent.fontsChanged(n)) {
            String string = this.m_userCfg.getString("srcFont", "Monospaced");
            n2 = this.m_userCfg.getInt("srcFontSize", 12);
            this.m_srcFont = new FontUIResource(new Font(string, 0, n2));
        }
        if (SettingsEvent.colorsChanged(n)) {
            this.m_srcActiveBg = this.m_userCfg.getColor("srcStopPosBackground", Color.yellow);
            this.m_srcActiveFg = this.m_userCfg.getColor("srcStopPosForeground", Color.black);
        }
    }

    private void restoreRegSettings(int n) {
        if (SettingsEvent.colorsChanged(n)) {
            this.m_regChangedBg = this.m_userCfg.getColor("regChangedBackground", Color.yellow);
            this.m_regChangedFg = this.m_userCfg.getColor("regChangedForeground", Color.black);
        }
    }

    private void restoreRecentPgms() {
        PgmDescriptor pgmDescriptor;
        String string;
        int n;
        this.m_pgmMax = this.m_userCfg.getInt("pgmMax", 8);
        int n2 = this.m_userCfg.getInt("pgmCount", 0);
        if (n2 > this.m_pgmMax) {
            n2 = this.m_pgmMax;
        }
        for (n = 0; n < n2; ++n) {
            string = this.m_userCfg.getString("pgm" + n, "");
            pgmDescriptor = this.stringToPgmDescriptor(string);
            if (pgmDescriptor == null) continue;
            this.m_pgms.add(pgmDescriptor);
        }
        n2 = this.m_userCfg.getInt("addPgmCount", 0);
        if (n2 > this.m_pgmMax) {
            n2 = this.m_pgmMax;
        }
        for (n = 0; n < n2; ++n) {
            string = this.m_userCfg.getString("addPgm" + n, "");
            pgmDescriptor = this.stringToPgmDescriptor(string);
            if (pgmDescriptor == null) continue;
            this.m_addPgms.add(pgmDescriptor);
        }
    }

    private void saveRecentPgms() {
        PgmDescriptor pgmDescriptor;
        int n;
        this.m_userCfg.setInt("pgmCount", this.m_pgms.size());
        this.m_userCfg.setInt("addPgmCount", this.m_addPgms.size());
        for (n = 0; n < this.m_pgms.size(); ++n) {
            pgmDescriptor = (PgmDescriptor)this.m_pgms.get(n);
            this.m_userCfg.setString("pgm" + n, this.pgmDescriptorToString(pgmDescriptor));
        }
        while (n < 20) {
            this.m_userCfg.remove("pgm" + n);
            ++n;
        }
        for (n = 0; n < this.m_addPgms.size(); ++n) {
            pgmDescriptor = (PgmDescriptor)this.m_addPgms.get(n);
            this.m_userCfg.setString("addPgm" + n, this.pgmDescriptorToString(pgmDescriptor));
        }
        while (n < 20) {
            this.m_userCfg.remove("addPgm" + n);
            ++n;
        }
    }

    private PgmDescriptor stringToPgmDescriptor(String string) {
        String[] stringArray;
        PgmDescriptor pgmDescriptor = null;
        if (string.length() > 0 && (stringArray = Tokenizer.tokenize(string)).length >= 3) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            int n = Integer.parseInt(stringArray[2]);
            String string4 = "";
            if (n == 2 && string2.equals("*DEFAULT")) {
                string2 = "";
            }
            for (int i = 3; i < stringArray.length; ++i) {
                string4 = string4 + stringArray[i];
                string4 = string4 + ' ';
            }
            pgmDescriptor = new PgmDescriptor(string2, string3, n, string4);
        }
        return pgmDescriptor;
    }

    private String pgmDescriptorToString(PgmDescriptor pgmDescriptor) {
        String string;
        StringBuffer stringBuffer = new StringBuffer(100);
        if (pgmDescriptor.isJavaClass()) {
            string = pgmDescriptor.getPgmLibrary();
            if (string.length() == 0) {
                stringBuffer.append("*DEFAULT");
            } else {
                stringBuffer.append(string);
            }
        } else {
            stringBuffer.append(pgmDescriptor.getPgmLibrary());
        }
        stringBuffer.append(' ');
        stringBuffer.append(pgmDescriptor.getPgmName());
        stringBuffer.append(' ');
        stringBuffer.append(pgmDescriptor.getPgmType());
        string = pgmDescriptor.getPgmParms();
        if (string.length() > 0) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private void restoreRecentEnvs() {
        this.m_envMax = this.m_userCfg.getInt("pgmEnvMax", 8);
        int n = this.m_userCfg.getInt("pgmEnvCount", 0);
        if (n > this.m_envMax) {
            n = this.m_envMax;
        }
        for (int i = 0; i < n; ++i) {
            String string = this.m_userCfg.getString("pgmEnv" + i, "");
            if (string.length() <= 0) continue;
            this.m_envs.add(string);
        }
    }

    private void saveRecentEnvs() {
        int n;
        this.m_userCfg.setInt("pgmEnvCount", this.m_envs.size());
        for (n = 0; n < this.m_envs.size(); ++n) {
            this.m_userCfg.setString("pgmEnv" + n, (String)this.m_envs.get(n));
        }
        while (n < 20) {
            this.m_userCfg.remove("pgmEnv" + n);
            ++n;
        }
    }

    static {
        String string = "Monospaced";
        Font font = UIManager.getFont("TextField.font");
        s_fixedPitchFontUI = new FontUIResource(new Font(string, 0, font.getSize()));
    }
}

