/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.event;

import com.ibm.iseries.debug.ISeriesMessage;
import com.ibm.iseries.debug.event.DebuggerEvent;

public class ContextEvent
extends DebuggerEvent {
    public static final int CONTEXT_CHANGE = 0;
    public static final int CONTEXT_REFRESH = 1;
    public static final int CONTEXT_CALLSTACK = 2;
    public static final int PROGRAM_RUNNING = 3;
    public static final int PROGRAM_COMPLETED = 4;
    public static final int MASK_EXCEPTION = 1;
    public static final int MASK_BRK = 2;
    public static final int MASK_STEP = 4;
    public static final int MASK_BRK_ERROR = 8;
    public static final int MASK_WATCH = 16;
    public static final int MASK_WATCH_ERROR = 32;
    public static final int MASK_HALT = 64;
    public static final int MASK_CURRENT_THREAD = 4096;
    public static final int MASK_ASM_EXCEPTION = 65536;
    public static final int MASK_ASM_BRK = 131072;
    public static final int MASK_ASM_STEP = 262144;
    public static final int MASK_ASM_HALT = 524288;
    public static final int MASK_ASM = 983040;
    private String m_viewId;
    private int m_lineNum;
    private String m_asmViewId;
    private int m_asmLineNum;
    private String m_asmAddress;
    private int m_mask;
    private int m_watchNum;
    private ISeriesMessage m_msgObj;
    private int m_pgmType;
    private String m_pgmName;
    private String m_moduleName;

    public ContextEvent(Object object, int n) {
        super(object, n);
        this.m_viewId = "";
        this.m_lineNum = -1;
        this.m_asmViewId = "";
        this.m_asmLineNum = -1;
    }

    public ContextEvent(Object object, int n, String string, int n2) {
        super(object, n);
        this.m_viewId = string;
        this.m_lineNum = n2;
        this.m_asmViewId = "";
        this.m_asmLineNum = -1;
    }

    public ContextEvent(Object object, String string, int n, int n2, int n3, ISeriesMessage iSeriesMessage) {
        super(object, 0);
        this.m_viewId = string;
        this.m_lineNum = n;
        this.m_asmViewId = "";
        this.m_asmLineNum = -1;
        this.m_mask = n2;
        this.m_watchNum = n3;
        this.m_msgObj = iSeriesMessage;
    }

    public ContextEvent(Object object, int n, String string, int n2, String string2, int n3) {
        super(object, n);
        this.m_viewId = string;
        this.m_lineNum = n2;
        this.m_asmViewId = string2;
        this.m_asmLineNum = n3;
        this.m_mask = 0;
    }

    public ContextEvent(Object object, String string, int n, String string2, int n2, String string3, int n3, int n4, ISeriesMessage iSeriesMessage) {
        super(object, 0);
        this.m_viewId = string;
        this.m_lineNum = n;
        this.m_asmViewId = string2;
        this.m_asmLineNum = n2;
        this.m_asmAddress = string3;
        this.m_mask = n3;
        this.m_watchNum = n4;
        this.m_msgObj = iSeriesMessage;
    }

    public ContextEvent(Object object, int n, String string, String string2, String string3, int n2, int n3, int n4, ISeriesMessage iSeriesMessage) {
        super(object, 0);
        this.m_pgmType = n;
        this.m_pgmName = string;
        this.m_moduleName = string2;
        this.m_viewId = string3;
        this.m_lineNum = n2;
        this.m_asmViewId = "";
        this.m_asmLineNum = -1;
        this.m_mask = n3;
        this.m_watchNum = n4;
        this.m_msgObj = iSeriesMessage;
    }

    public String getViewId() {
        return this.m_viewId;
    }

    public int getLineNum() {
        return this.m_lineNum;
    }

    public String getAsmViewId() {
        return this.m_asmViewId;
    }

    public int getAsmLineNum() {
        return this.m_asmLineNum;
    }

    public String getAsmAddress() {
        return this.m_asmAddress;
    }

    public int getMask() {
        return this.m_mask;
    }

    public int getPgmType() {
        return this.m_pgmType;
    }

    public String getPgmName() {
        return this.m_pgmName;
    }

    public String getModuleName() {
        return this.m_moduleName;
    }

    public boolean isExceptionMask() {
        return (this.m_mask & 1) != 0;
    }

    public boolean isBreakMask() {
        return (this.m_mask & 2) != 0;
    }

    public boolean isStepMask() {
        return (this.m_mask & 4) != 0;
    }

    public boolean isWatchMask() {
        return (this.m_mask & 0x10) != 0;
    }

    public boolean isHaltMask() {
        return (this.m_mask & 0x40) != 0;
    }

    public boolean isCurrentThreadMask() {
        return (this.m_mask & 0x1000) != 0;
    }

    public boolean isAsmExceptionMask() {
        return (this.m_mask & 0x10000) != 0;
    }

    public boolean isAsmBreakMask() {
        return (this.m_mask & 0x20000) != 0;
    }

    public boolean isAsmStepMask() {
        return (this.m_mask & 0x40000) != 0;
    }

    public boolean isAsmHaltMask() {
        return (this.m_mask & 0x80000) != 0;
    }

    public boolean isAsmMask() {
        return (this.m_mask & 0xF0000) != 0;
    }

    public static boolean isAsmMask(int n) {
        return (n & 0xF0000) != 0;
    }

    public int getWatchNum() {
        return this.m_watchNum;
    }

    public ISeriesMessage getMsgObj() {
        return this.m_msgObj;
    }

    public void cleanUp() {
        this.m_viewId = null;
        this.m_asmViewId = null;
        this.m_asmAddress = null;
        this.m_msgObj = null;
        this.m_pgmName = null;
        this.m_moduleName = null;
    }
}

