/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Tokenizer;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.accessibility.Accessible;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TokenEditorDialog
extends Dialog
implements ListSelectionListener {
    private static final String LIST = "list";
    private static final String AFTER = "after";
    private static final String BEFORE = "before";
    private static final String REMOVE = "remove";
    private static final String TOKEN = "token";
    private static final String DELETE = "delete";
    private static final char QUOTE = '\'';
    private static final String QUOTE_STR = "'";
    private static final char SPACE = ' ';
    private JPanel m_panel;
    private JPanel m_basePanel;
    private JPanel m_buttonPanel;
    private JPanel m_tokenPanel;
    private JScrollPane m_scrollPane;
    private JList m_list;
    private JTextField m_tokenCtrl;
    private JButton m_addAfter;
    private JButton m_addBefore;
    private JButton m_remove;
    private String m_tokenStr;
    private String m_delimiters;
    private char m_defaultDelim;

    public TokenEditorDialog(JDialog jDialog, String string, String string2, String string3, String string4, String string5, char c) {
        super(jDialog, string, true, "");
        this.m_tokenStr = string4;
        this.m_delimiters = string5;
        this.m_defaultDelim = c;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_panel.setBorder(this.getEmptyBorder(15, 15, 15, 15));
        this.listenForEscape(this.m_panel);
        this.m_basePanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JLabel jLabel = Util.getAccessibleLabel(string2);
        jPanel.add(jLabel);
        jPanel.setBorder(this.getEmptyBorder(0, 0, 10, 0));
        jLabel.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        String[] stringArray = Tokenizer.tokenize(string4, string5);
        this.m_list = new JList<String>(stringArray);
        this.m_scrollPane = new JScrollPane(this.m_list);
        this.m_list.setSelectionMode(0);
        this.m_list.setVisibleRowCount(15);
        this.m_list.addListSelectionListener(this);
        Dimension dimension = this.m_list.getPreferredSize();
        if (dimension.width < 250) {
            dimension.width = 250;
            this.m_list.setPreferredSize(dimension);
        }
        this.m_buttonPanel = new JPanel();
        this.m_buttonPanel.setBorder(this.getEmptyBorder(0, 10, 0, 0));
        this.m_buttonPanel.setLayout(new BoxLayout(this.m_buttonPanel, 1));
        this.m_addAfter = new JButton(MRI.get("DBG_ADD_AFTER"));
        this.m_addAfter.setEnabled(true);
        this.m_addAfter.setActionCommand(AFTER);
        this.m_addAfter.addActionListener(this);
        this.m_addBefore = new JButton(MRI.get("DBG_ADD_BEFORE"));
        this.m_addBefore.setEnabled(false);
        this.m_addBefore.setActionCommand(BEFORE);
        this.m_addBefore.addActionListener(this);
        this.m_remove = new JButton(MRI.get("DBG_REMOVE"));
        this.m_remove.setEnabled(false);
        this.m_remove.setActionCommand(REMOVE);
        this.m_remove.addActionListener(this);
        Dimension dimension2 = this.m_addBefore.getMaximumSize();
        Dimension dimension3 = this.m_addAfter.getMaximumSize();
        Dimension dimension4 = this.m_remove.getMaximumSize();
        if (dimension2.width < dimension3.width) {
            dimension2.width = dimension3.width;
        }
        if (dimension2.width < dimension4.width) {
            dimension2.width = dimension4.width;
        }
        this.m_addBefore.setMaximumSize(dimension2);
        this.m_addAfter.setMaximumSize(dimension2);
        this.m_remove.setMaximumSize(dimension2);
        this.m_buttonPanel.add(this.m_addAfter);
        this.m_buttonPanel.add(Box.createRigidArea(new Dimension(0, 3)));
        this.m_buttonPanel.add(this.m_addBefore);
        this.m_buttonPanel.add(Box.createRigidArea(new Dimension(0, 3)));
        this.m_buttonPanel.add(this.m_remove);
        JLabel jLabel2 = new JLabel(string3);
        this.m_tokenPanel = new JPanel(new BorderLayout());
        this.m_tokenCtrl = new JTextField();
        this.m_tokenCtrl.setActionCommand(TOKEN);
        this.m_tokenCtrl.addActionListener(this);
        this.m_tokenPanel.setBorder(this.getEmptyBorder(10, 0, 0, 0));
        this.m_tokenPanel.add((Component)jLabel2, "North");
        this.m_tokenPanel.add((Component)this.m_tokenCtrl, "South");
        Util.setAccessible((Accessible)this.m_list, jLabel);
        Util.setAccessible((Accessible)this.m_addAfter, this.m_addAfter.getText());
        Util.setAccessible((Accessible)this.m_addBefore, this.m_addBefore.getText());
        Util.setAccessible((Accessible)this.m_remove, this.m_remove.getText());
        Util.setAccessible((Accessible)this.m_tokenCtrl, jLabel2);
        Util.setOrientation(jLabel);
        Util.setOrientation(this.m_scrollPane);
        Util.setOrientation(this.m_list);
        Util.setOrientation(this.m_addAfter);
        Util.setOrientation(this.m_addBefore);
        Util.setOrientation(this.m_remove);
        Util.setOrientation(this.m_tokenCtrl, jLabel2);
        this.m_basePanel.add((Component)jPanel, "North");
        this.m_basePanel.add((Component)this.m_scrollPane, "Center");
        this.m_basePanel.add((Component)this.m_buttonPanel, this.m_isLtoR ? "East" : "West");
        this.m_basePanel.add((Component)this.m_tokenPanel, "South");
        this.m_panel.add((Component)this.m_basePanel, "Center");
        this.m_panel.add((Component)this.defaultButtons(MRI.get("DBG_OK"), true, false), "South");
        this.setContentPane(this.m_panel);
        if (stringArray.length > 0) {
            this.m_list.setSelectedIndex(stringArray.length - 1);
        }
        this.m_list.registerKeyboardAction(this, DELETE, KeyStroke.getKeyStroke(127, 0), 2);
        this.addWindowListener(new WndAdapter());
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_buttonPanel = null;
        this.m_tokenPanel = null;
        this.m_scrollPane = null;
        this.m_list = null;
        this.m_tokenCtrl = null;
        this.m_addAfter = null;
        this.m_addBefore = null;
        this.m_remove = null;
        this.m_tokenCtrl = null;
    }

    public String getTokenString() {
        return this.m_tokenStr;
    }

    private void doIt() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        ListModel listModel = this.m_list.getModel();
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(listModel.getElementAt(i));
            if (i + 1 >= n) continue;
            stringBuffer.append(this.m_defaultDelim);
        }
        this.m_tokenStr = stringBuffer.toString();
        this.setCanceled(false);
        this.dispose();
    }

    private String getToken() {
        String string = this.m_tokenCtrl.getText().trim();
        if (string.length() == 0) {
            this.getToolkit().beep();
            return null;
        }
        if (this.m_delimiters.indexOf(39) >= 0 && string.indexOf(32) >= 0) {
            if (!string.startsWith(QUOTE_STR)) {
                string = QUOTE_STR + string;
            }
            if (!string.endsWith(QUOTE_STR)) {
                string = string + QUOTE_STR;
            }
        }
        this.m_tokenCtrl.setText("");
        return string;
    }

    private void doAddAfter() {
        String string = this.getToken();
        if (string == null) {
            return;
        }
        ListModel listModel = this.m_list.getModel();
        int n = this.m_list.getSelectedIndex();
        int n2 = listModel.getSize();
        String[] stringArray = new String[n2 + 1];
        if (n2 > 0) {
            n = n < 0 ? listModel.getSize() : ++n;
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                stringArray[n3++] = (String)listModel.getElementAt(i);
                if (i + 1 != n) continue;
                stringArray[n3++] = string;
            }
        } else {
            n = 0;
            stringArray[0] = string;
        }
        this.m_list.setListData(stringArray);
        this.m_list.setSelectedIndex(n);
        this.m_list.ensureIndexIsVisible(n);
        this.m_tokenCtrl.requestFocus();
    }

    private void doAddBefore() {
        String string = this.getToken();
        if (string == null) {
            return;
        }
        ListModel listModel = this.m_list.getModel();
        int n = this.m_list.getSelectedIndex();
        int n2 = listModel.getSize();
        String[] stringArray = new String[n2 + 1];
        if (n2 > 0) {
            if (n < 0) {
                n = listModel.getSize() - 1;
            }
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (i == n) {
                    stringArray[n3++] = string;
                }
                stringArray[n3++] = (String)listModel.getElementAt(i);
            }
        } else {
            n = 0;
            stringArray[0] = string;
        }
        this.m_list.setListData(stringArray);
        this.m_list.setSelectedIndex(n);
        this.m_list.ensureIndexIsVisible(n);
        this.m_tokenCtrl.requestFocus();
    }

    private void doRemove() {
        int n = this.m_list.getSelectedIndex();
        if (n >= 0) {
            ListModel listModel = this.m_list.getModel();
            int n2 = listModel.getSize();
            String[] stringArray = new String[n2 - 1];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (i == n) continue;
                stringArray[n3++] = (String)listModel.getElementAt(i);
            }
            this.m_list.setListData(stringArray);
            if (n2 > 1) {
                if (n == n2 - 1) {
                    n = n2 - 2;
                }
                this.m_list.setSelectedIndex(n);
                this.m_list.ensureIndexIsVisible(n);
                this.m_list.requestFocus();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals("doit")) {
            this.doIt();
        } else if (string.equals(AFTER) || string.equals(TOKEN)) {
            this.doAddAfter();
        } else if (string.equals(BEFORE)) {
            this.doAddBefore();
        } else if (string.equals(REMOVE) || string.equals(DELETE)) {
            this.doRemove();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl;
        int n = this.m_list.getSelectedIndex();
        boolean bl2 = bl = n >= 0;
        if (bl) {
            this.m_tokenCtrl.setText((String)this.m_list.getSelectedValue());
            this.m_tokenCtrl.selectAll();
        }
        this.m_addBefore.setEnabled(bl);
        this.m_remove.setEnabled(bl);
    }

    private class WndAdapter
    extends WindowAdapter {
        private WndAdapter() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            TokenEditorDialog.this.m_tokenCtrl.requestFocus();
        }
    }
}

