/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.util.DialogTabPanel;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class PreferencesFontsPage
extends DialogTabPanel
implements ActionListener {
    private static String[] s_fontName = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static String[] s_fontCategory = new String[1];
    private static String[] s_fontAttribute;
    private static String[] s_fontNameDefault;
    private static int[] s_fontSizeDefault;
    private Settings m_userCfg;
    private JPanel m_panel;
    private JPanel m_basePanel;
    private JComboBox m_category;
    private JComboBox m_name;
    private JComboBox m_size;
    private JLabel m_preview;
    private String[] m_fontName;
    private int[] m_fontSize;
    private JButton m_restoreButton;
    private boolean m_modified;

    public PreferencesFontsPage(Settings settings) {
        super(MRI.get("DBG_FONTS"), 4);
        int n;
        this.m_userCfg = settings;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_panel.setBorder(this.getEmptyBorder(5, 5, 5, 5));
        this.m_fontName = new String[s_fontAttribute.length];
        this.m_fontSize = new int[s_fontAttribute.length];
        for (int i = 0; i < s_fontAttribute.length; ++i) {
            this.m_fontName[i] = this.m_userCfg.getString(s_fontAttribute[i], s_fontNameDefault[i]);
            this.m_fontSize[i] = this.m_userCfg.getInt(s_fontAttribute[i] + "Size", s_fontSizeDefault[i]);
        }
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_basePanel = new JPanel(new BorderLayout());
        this.m_basePanel.add((Component)jPanel, this.m_isLtoR ? "West" : "East");
        this.m_basePanel.add((Component)jPanel2, "Center");
        this.m_panel.add((Component)this.m_basePanel, "North");
        JLabel jLabel = Util.getAccessibleLabel(MRI.get("DBG_CATEGORY_LABEL"));
        JLabel jLabel2 = Util.getAccessibleLabel(MRI.get("DBG_FONT_LABEL"));
        JLabel jLabel3 = Util.getAccessibleLabel(MRI.get("DBG_FONT_SIZE_LABEL"));
        jPanel.setBorder(this.getEmptyBorder(0, 0, 0, 10));
        jPanel.add(jLabel);
        jPanel.add(new JLabel());
        jPanel.add(jLabel2);
        jPanel.add(jLabel3);
        this.m_category = new JComboBox();
        this.m_name = new JComboBox();
        this.m_size = new JComboBox();
        this.m_category.setRenderer(new DummyRenderer());
        this.m_name.setRenderer(new DummyRenderer());
        this.m_size.setRenderer(new DummyRenderer());
        jPanel2.setBorder(this.getEmptyBorder(0, 10, 0, 0));
        jPanel2.add(this.m_category);
        jPanel2.add(new JLabel());
        jPanel2.add(this.m_name);
        jPanel2.add(this.m_size);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JLabel jLabel4 = Util.getAccessibleLabel(MRI.get("DBG_PREVIEW_LABEL"));
        JPanel jPanel4 = new JPanel();
        Dimension dimension = jPanel.getPreferredSize();
        Dimension dimension2 = jLabel4.getPreferredSize();
        dimension2.height = this.m_name.getPreferredSize().height;
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        } else {
            dimension2.width = dimension.width;
        }
        dimension2.width += 10;
        jLabel4.setPreferredSize(dimension2);
        jPanel.setPreferredSize(dimension);
        String string = MRI.get("DBG_RESTORE_DEFAULTS");
        this.m_restoreButton = new JButton(string);
        this.m_restoreButton.addActionListener(this);
        jPanel4.setBorder(this.getEmptyBorder(30, 0, 0, 0));
        jPanel4.add(this.m_restoreButton);
        this.m_preview = Util.getAccessibleLabel(MRI.get("DBG_SAMPLE_TEXT"));
        this.m_preview.setOpaque(true);
        this.m_preview.setHorizontalAlignment(0);
        this.m_preview.setForeground(UIManager.getColor("TextArea.foreground"));
        this.m_preview.setBackground(UIManager.getColor("TextArea.background"));
        jPanel3.setBorder(this.getEmptyBorder(dimension2.height + 3, 0, 0, 0));
        jPanel3.add((Component)jLabel4, this.m_isLtoR ? "West" : "East");
        jPanel3.add((Component)this.m_preview, "Center");
        jPanel3.add((Component)jPanel4, "South");
        this.m_basePanel.add((Component)jPanel3, "South");
        Util.setAccessible((Accessible)this.m_category, jLabel);
        Util.setAccessible((Accessible)this.m_name, jLabel2);
        Util.setAccessible((Accessible)this.m_size, jLabel3);
        Util.setAccessible((Accessible)this.m_preview, jLabel4);
        Util.setAccessible((Accessible)this.m_restoreButton, string);
        Util.setOrientation(this.m_category, jLabel);
        Util.setOrientation(this.m_name, jLabel2);
        Util.setOrientation(this.m_size, jLabel3);
        Util.setOrientation(this.m_preview, jLabel4);
        Util.setOrientation(this.m_restoreButton);
        for (n = 0; n < s_fontName.length; ++n) {
            this.m_name.addItem(s_fontName[n]);
        }
        this.m_size.addItem("8");
        this.m_size.addItem("10");
        this.m_size.addItem("12");
        this.m_size.addItem("14");
        this.m_size.addItem("16");
        this.m_size.addItem("18");
        this.m_size.addItem("20");
        this.m_size.addItem("22");
        this.m_size.addItem("24");
        this.m_size.addItem("26");
        this.m_size.addItem("28");
        this.m_size.addItem("36");
        this.m_size.addItem("48");
        this.m_size.addItem("72");
        this.m_size.setMaximumRowCount(this.m_size.getItemCount());
        for (n = 0; n < s_fontCategory.length; ++n) {
            this.m_category.addItem(s_fontCategory[n]);
        }
        this.m_category.addActionListener(this);
        this.m_category.setSelectedIndex(0);
    }

    public JComponent getComponent() {
        return this.m_panel;
    }

    public void cleanUp() {
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_category = null;
        this.m_name = null;
        this.m_size = null;
        this.m_preview = null;
        this.m_fontName = null;
        this.m_fontSize = null;
        this.m_restoreButton = null;
    }

    public boolean doOk() {
        if (this.m_modified) {
            for (int i = 0; i < s_fontAttribute.length; ++i) {
                if (!this.m_fontName[i].equals(s_fontNameDefault[i])) {
                    this.m_userCfg.setString(s_fontAttribute[i], this.m_fontName[i]);
                } else {
                    this.m_userCfg.remove(s_fontAttribute[i]);
                }
                if (this.m_fontSize[i] != s_fontSizeDefault[i]) {
                    this.m_userCfg.setInt(s_fontAttribute[i] + "Size", this.m_fontSize[i]);
                    continue;
                }
                this.m_userCfg.remove(s_fontAttribute[i] + "Size");
            }
        }
        return this.m_modified;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_category) {
            int n = this.m_category.getSelectedIndex();
            this.m_name.removeActionListener(this);
            this.m_name.setSelectedItem(this.m_fontName[n]);
            this.m_name.addActionListener(this);
            this.m_size.removeActionListener(this);
            this.m_size.setSelectedItem(String.valueOf(this.m_fontSize[n]));
            this.m_size.addActionListener(this);
            Font font = new Font(this.m_fontName[n], 0, this.m_fontSize[n]);
            if (font != null) {
                this.m_preview.setFont(font);
            }
        } else if (object == this.m_name || object == this.m_size) {
            int n;
            int n2 = this.m_category.getSelectedIndex();
            String string = (String)this.m_name.getSelectedItem();
            Font font = new Font(string, 0, n = Integer.parseInt((String)this.m_size.getSelectedItem()));
            if (font != null) {
                this.m_fontName[n2] = string;
                this.m_fontSize[n2] = n;
                this.m_preview.setFont(font);
            }
            this.m_modified = true;
        } else if (object == this.m_restoreButton) {
            int n = this.m_category.getSelectedIndex();
            this.m_name.setSelectedItem(s_fontNameDefault[n]);
            this.m_size.setSelectedItem(String.valueOf(s_fontSizeDefault[n]));
            this.m_modified = true;
        }
    }

    static {
        PreferencesFontsPage.s_fontCategory[0] = MRI.get("DBG_SOURCE_CODE_VIEW");
        s_fontAttribute = new String[1];
        PreferencesFontsPage.s_fontAttribute[0] = "srcFont";
        s_fontNameDefault = new String[1];
        PreferencesFontsPage.s_fontNameDefault[0] = "Monospaced";
        s_fontSizeDefault = new int[1];
        PreferencesFontsPage.s_fontSizeDefault[0] = 12;
    }

    private class DummyRenderer
    extends DefaultListCellRenderer {
    }
}

