/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PickFromListDialog
extends Dialog
implements MouseListener,
KeyListener {
    public static final int SELECT_NONE = -1;
    public static final int SELECT_ALL = -2;
    private static final String LIST = "list";
    private JPanel m_panel;
    private JScrollPane m_scrollPane;
    private JList m_list;
    private String m_title;
    private String[] m_items;

    public PickFromListDialog(JFrame jFrame, String string, String string2, String string3, String string4, String[] stringArray, int n) {
        super(jFrame, string, true, string4);
        this.init(string, string2, string3, string4, stringArray, n);
    }

    public PickFromListDialog(JDialog jDialog, String string, String string2, String string3, String string4, String[] stringArray, int n) {
        super(jDialog, string, true, string4);
        this.init(string, string2, string3, string4, stringArray, n);
    }

    private void init(String string, String string2, String string3, String string4, String[] stringArray, int n) {
        this.m_items = stringArray;
        this.m_title = string;
        this.m_panel = new JPanel(new BorderLayout());
        this.m_panel.setBorder(this.getEmptyBorder(15, 15, 15, 15));
        this.listenForEscape(this.m_panel);
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JLabel jLabel = Util.getAccessibleLabel(string2);
        jPanel.add(jLabel);
        jPanel.setBorder(this.getEmptyBorder(0, 0, 10, 0));
        jLabel.setAlignmentX(this.m_isLtoR ? 0.0f : 1.0f);
        this.m_list = new JList<String>(stringArray);
        this.m_scrollPane = new JScrollPane(this.m_list);
        this.m_list.addMouseListener(this);
        this.m_list.addKeyListener(this);
        this.m_list.setSelectionMode(2);
        this.m_list.setVisibleRowCount(stringArray.length < 20 ? stringArray.length : 20);
        switch (n) {
            case -1: {
                break;
            }
            case -2: {
                this.m_list.setSelectionInterval(0, stringArray.length - 1);
                break;
            }
            default: {
                if (n < 0 || n >= stringArray.length) break;
                this.m_list.setSelectedIndex(n);
            }
        }
        Util.setAccessible((Accessible)this.m_list, jLabel);
        Util.setOrientation(jLabel);
        Util.setOrientation(this.m_scrollPane);
        Util.setOrientation(this.m_list);
        this.m_panel.add((Component)jPanel, "North");
        this.m_panel.add((Component)this.m_scrollPane, "Center");
        if (string4 != null && string4.length() > 0) {
            this.m_panel.add((Component)this.defaultButtons(string3), "South");
        } else {
            this.m_panel.add((Component)this.defaultButtons(string3, true, false), "South");
        }
        this.setContentPane(this.m_panel);
        this.m_doItButton.requestFocus();
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_panel = null;
        this.m_scrollPane = null;
        this.m_title = null;
    }

    public void setSingleSelect() {
        this.m_list.setSelectionMode(0);
    }

    public void setMultiSelect() {
        this.m_list.setSelectionMode(2);
    }

    public int getSelectedIndex() {
        return this.m_list.getSelectedIndex();
    }

    public int[] getSelectedIndices() {
        return this.m_list.getSelectedIndices();
    }

    public String[] getSelectedItems() {
        int[] nArray = this.m_list.getSelectedIndices();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.m_items[nArray[i]];
        }
        return stringArray;
    }

    private void doIt() {
        if (this.m_list.getSelectedIndex() == -1) {
            this.getToolkit().beep();
            Util.errorMessage(this, this.m_title, MRI.get("DBG_NO_ITEMS_SELECTED_ERROR"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals("doit")) {
            this.doIt();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.m_list && mouseEvent.getClickCount() == 2) {
            this.doIt();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 10) {
            this.doIt();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

