/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.BreakpointDescriptor;
import com.ibm.iseries.debug.BreakpointGroup;
import com.ibm.iseries.debug.BreakpointSwatchIcon;
import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.manager.BreakpointGroupManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class BreakpointEditDialog
extends Dialog
implements DebugConstants {
    private static final String GROUP_CHECK = "grpchk";
    private static final String GROUP = "grp";
    private static final String STYLE_CHECK = "stylechk";
    private static final String STYLE = "style";
    private static final String COND_CHECK = "condchk";
    private static final String THD_CHECK = "thdchk";
    private static final String USER_CHECK = "userchk";
    private static final int COL_COUNT = 5;
    private static final int GROUP_COL = 0;
    private static final int PGM_COL = 1;
    private static final int MODULE_COL = 2;
    private static final int LINE_COL = 3;
    private static final int STYLE_COL = 4;
    private DebugContext m_ctxt;
    private BreakpointGroupManager m_brkGrpMgr;
    private PgmManager m_pgmMgr;
    private JPanel m_panel;
    private JPanel m_basePanel;
    private JPanel m_labelPanel;
    private JPanel m_ctrlPanel;
    private Tbl m_table;
    private TblModel m_tableModel;
    private JScrollPane m_scrollPane;
    private JCheckBox m_groupCheck;
    private JCheckBox m_styleCheck;
    private JComboBox m_styleCtrl;
    private int m_style;
    private JComboBox m_groupCtrl;
    private JCheckBox m_conditionCheck;
    private JTextField m_conditionCtrl;
    private JCheckBox m_threadCheck;
    private JComboBox m_threadCtrl;
    private JCheckBox m_userCheck;
    private JTextField m_userCtrl;
    private ArrayList m_descriptors;
    private boolean m_svcEntryPtSupported;
    private boolean m_groupChanged;
    static /* synthetic */ Class class$java$lang$String;

    public BreakpointEditDialog(DebugContext debugContext, String string, ArrayList arrayList) {
        super(debugContext.getJFrame(), string, true, "dbgeditbrk");
        this.m_ctxt = debugContext;
        this.m_descriptors = arrayList;
        this.m_brkGrpMgr = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
        this.m_pgmMgr = (PgmManager)this.m_ctxt.getManager("pgmmgr");
        this.m_panel = new JPanel(new BorderLayout());
        this.m_basePanel = new JPanel(new BorderLayout());
        this.m_labelPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_ctrlPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_tableModel = new TblModel();
        this.m_table = new Tbl(this.m_tableModel);
        this.m_scrollPane = new JScrollPane(this.m_table);
        Dimension dimension = this.m_table.getPreferredSize();
        this.m_panel.setBorder(this.getEmptyBorder(15, 15, 15, 15));
        this.m_labelPanel.setBorder(this.getEmptyBorder(30, 10, 10, 10));
        this.m_ctrlPanel.setBorder(this.getEmptyBorder(30, 10, 10, 10));
        this.m_basePanel.add((Component)this.m_scrollPane, "North");
        this.m_basePanel.add((Component)this.m_labelPanel, this.m_isLtoR ? "West" : "East");
        this.m_basePanel.add((Component)this.m_ctrlPanel, "Center");
        this.m_panel.add((Component)this.m_basePanel, "North");
        this.m_panel.add((Component)this.defaultButtons(MRI.get("DBG_OK")), "South");
        this.setContentPane(this.m_panel);
        this.m_svcEntryPtSupported = this.m_ctxt.isSupported(5, this.m_ctxt.getSystemVersion());
        this.addComponents();
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_ctxt = null;
        this.m_brkGrpMgr = null;
        this.m_pgmMgr = null;
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_labelPanel = null;
        this.m_ctrlPanel = null;
        this.m_table = null;
        this.m_tableModel = null;
        this.m_groupCheck = null;
        this.m_groupCtrl = null;
        this.m_styleCheck = null;
        this.m_styleCtrl = null;
        this.m_conditionCheck = null;
        this.m_conditionCtrl = null;
        this.m_threadCheck = null;
        this.m_threadCtrl = null;
        this.m_userCheck = null;
        this.m_userCtrl = null;
        this.m_descriptors = null;
    }

    private void addComponents() {
        Object object;
        Comparable comparable;
        this.listenForEscape(this.m_panel);
        this.setColumnWidths();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = true;
        int n5 = -1;
        boolean bl2 = true;
        String string = "";
        boolean bl3 = true;
        String string2 = "";
        for (int i = 0; i < this.m_descriptors.size(); ++i) {
            comparable = (BreakpointDescriptor)this.m_descriptors.get(i);
            if (bl) {
                if (n5 == -1) {
                    n5 = comparable.getGroupId();
                } else if (comparable.getGroupId() != n5) {
                    n5 = -1;
                    bl = false;
                }
            }
            if (comparable.isDefaultStyle()) {
                ++n;
                if (bl2) {
                    object = comparable.getCondition();
                    if (string.length() == 0) {
                        string = object;
                    } else if (!((String)object).equals(string)) {
                        string = "";
                        bl2 = false;
                    }
                }
                if (comparable.getThreadId().length() == 0) {
                    ++n3;
                    continue;
                }
                ++n4;
                continue;
            }
            ++n2;
            if (!bl3) continue;
            object = comparable.getUser();
            if (string2.length() == 0) {
                string2 = object;
                continue;
            }
            if (((String)object).equals(string2)) continue;
            string2 = "";
            bl3 = false;
        }
        this.m_groupCheck = new JCheckBox(MRI.get("DBG_BREAKPOINT_GROUP_LABEL"));
        this.m_groupCheck.setActionCommand(GROUP_CHECK);
        this.m_groupCheck.addActionListener(this);
        this.m_conditionCheck = new JCheckBox(MRI.get("DBG_CONDITION_LABEL"));
        this.m_conditionCheck.setActionCommand(COND_CHECK);
        this.m_conditionCheck.addActionListener(this);
        this.m_conditionCheck.setEnabled(!this.m_svcEntryPtSupported);
        this.m_threadCheck = new JCheckBox(MRI.get("DBG_THREAD_LABEL"));
        this.m_threadCheck.setActionCommand(THD_CHECK);
        this.m_threadCheck.addActionListener(this);
        this.m_threadCheck.setEnabled(!this.m_svcEntryPtSupported);
        if (this.m_svcEntryPtSupported) {
            this.m_styleCheck = new JCheckBox(MRI.get("DBG_BREAKPOINT_STYLE_LABEL"));
            this.m_styleCheck.setActionCommand(STYLE_CHECK);
            this.m_styleCheck.addActionListener(this);
            this.m_userCheck = new JCheckBox(MRI.get("DBG_USER_LABEL"));
            this.m_userCheck.setActionCommand(USER_CHECK);
            this.m_userCheck.addActionListener(this);
            this.m_userCheck.setEnabled(false);
        }
        this.m_labelPanel.add(this.m_groupCheck);
        if (this.m_svcEntryPtSupported) {
            this.m_labelPanel.add(this.m_styleCheck);
            if (n >= n2) {
                this.m_labelPanel.add(this.m_conditionCheck);
                this.m_labelPanel.add(this.m_threadCheck);
            } else {
                this.m_labelPanel.add(this.m_userCheck);
            }
        } else {
            this.m_labelPanel.add(this.m_conditionCheck);
            this.m_labelPanel.add(this.m_threadCheck);
        }
        BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
        comparable = breakpointGroupManager.getCurrentGroup();
        object = breakpointGroupManager.getGroups();
        int n6 = ((ArrayList)object).size();
        if (this.m_svcEntryPtSupported) {
            this.m_style = n >= n2 ? 0 : 1;
            this.m_styleCtrl = new JComboBox();
            this.m_styleCtrl.setRenderer(new DummyRenderer());
            this.m_styleCtrl.addItem(MRI.get("DBG_DEFAULT"));
            this.m_styleCtrl.addItem(MRI.get("DBG_SERVICE_ENTRY_POINT"));
            this.m_styleCtrl.setSelectedIndex(this.m_style);
            this.m_styleCtrl.setActionCommand(STYLE);
            this.m_styleCtrl.addActionListener(this);
            this.m_styleCtrl.setEnabled(false);
            if (string2.length() == 0) {
                string2 = Util.firstUpper(this.m_ctxt.getUser());
            }
            this.m_userCtrl = new JTextField(string2);
            this.m_userCtrl.setEnabled(false);
        }
        this.m_groupCtrl = new JComboBox();
        this.m_groupCtrl.setRenderer(new ComboRenderer());
        this.m_groupCtrl.setMaximumRowCount(n6 > 20 ? 20 : n6);
        this.m_groupCtrl.setEnabled(false);
        this.m_groupCtrl.setActionCommand(GROUP);
        this.m_groupCtrl.addActionListener(this);
        for (int i = 0; i < n6; ++i) {
            BreakpointGroup breakpointGroup = (BreakpointGroup)((ArrayList)object).get(i);
            this.m_groupCtrl.addItem(breakpointGroup.getGroupName());
        }
        this.m_groupCtrl.setSelectedItem(n5 >= 0 ? breakpointGroupManager.getGroupName(n5) : breakpointGroupManager.getCurrentGroupName());
        this.m_groupCheck.setEnabled(n6 > 1);
        this.m_conditionCtrl = new JTextField(string);
        this.m_conditionCtrl.setEnabled(false);
        this.m_conditionCtrl.setOpaque(false);
        this.m_threadCtrl = new JComboBox();
        this.m_threadCtrl.setRenderer(new DummyRenderer());
        this.m_threadCtrl.addItem(MRI.get("DBG_APPLY_TO_ALL_THREADS"));
        this.m_threadCtrl.addItem(MRI.get("DBG_APPLY_TO_CURRENT_THREAD"));
        this.m_threadCtrl.setEnabled(false);
        this.m_threadCtrl.setSelectedIndex(n3 >= n4 ? 0 : 1);
        this.m_ctrlPanel.add(this.m_groupCtrl);
        if (this.m_svcEntryPtSupported) {
            this.m_ctrlPanel.add(this.m_styleCtrl);
            if (n >= n2) {
                this.m_ctrlPanel.add(this.m_conditionCtrl);
                this.m_ctrlPanel.add(this.m_threadCtrl);
            } else {
                this.m_ctrlPanel.add(this.m_userCtrl);
            }
        } else {
            this.m_ctrlPanel.add(this.m_conditionCtrl);
            this.m_ctrlPanel.add(this.m_threadCtrl);
        }
        Util.setAccessible((Accessible)this.m_groupCheck, this.m_groupCheck.getText());
        Util.setAccessible((Accessible)this.m_groupCtrl, this.m_groupCheck.getText());
        Util.setAccessible((Accessible)this.m_conditionCheck, this.m_conditionCheck.getText());
        Util.setAccessible((Accessible)this.m_conditionCtrl, this.m_conditionCheck.getText());
        Util.setAccessible((Accessible)this.m_threadCheck, this.m_threadCheck.getText());
        Util.setAccessible((Accessible)this.m_threadCtrl, this.m_threadCheck.getText());
        if (this.m_svcEntryPtSupported) {
            Util.setAccessible((Accessible)this.m_styleCheck, this.m_styleCheck.getText());
            Util.setAccessible((Accessible)this.m_styleCtrl, this.m_styleCheck.getText());
            Util.setAccessible((Accessible)this.m_userCheck, this.m_userCheck.getText());
            Util.setAccessible((Accessible)this.m_userCtrl, this.m_userCheck.getText());
        }
        Util.setOrientation(this.m_groupCheck);
        Util.setOrientation(this.m_groupCtrl);
        Util.setOrientation(this.m_conditionCheck);
        Util.setOrientation(this.m_conditionCtrl);
        Util.setOrientation(this.m_threadCheck);
        Util.setOrientation(this.m_threadCtrl);
        if (this.m_svcEntryPtSupported) {
            Util.setOrientation(this.m_styleCheck);
            Util.setOrientation(this.m_styleCtrl);
            Util.setOrientation(this.m_userCheck);
            Util.setOrientation(this.m_userCtrl);
        }
    }

    private void setColumnWidths() {
        int n = this.m_tableModel.getRowCount();
        int n2 = this.m_tableModel.getColumnCount();
        int n3 = 0;
        FontMetrics fontMetrics = this.m_table.getFontMetrics(this.m_table.getFont());
        for (int i = 0; i < n2; ++i) {
            int n4 = fontMetrics.stringWidth(this.m_tableModel.getColumnName(i)) + 20;
            for (int j = 0; j < n; ++j) {
                int n5 = fontMetrics.stringWidth(this.m_tableModel.getValueAt(j, i).toString()) + 20;
                if (i == 0) {
                    n5 += this.m_table.getIconWidth();
                }
                if (n5 <= n4) continue;
                n4 = n5;
            }
            this.m_table.getColumnModel().getColumn(i).setPreferredWidth(n4);
            n3 += n4;
        }
        this.m_table.setOptimumWidth(n3);
    }

    public void doOk() {
        BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)this.m_ctxt.getManager("brkgrpmgr");
        String string = (String)this.m_groupCtrl.getSelectedItem();
        int n = this.m_svcEntryPtSupported ? this.m_styleCtrl.getSelectedIndex() : 0;
        String string2 = this.m_conditionCtrl.getText().trim();
        int n2 = this.m_threadCtrl.getSelectedIndex();
        String string3 = this.m_svcEntryPtSupported ? this.m_userCtrl.getText().trim() : "";
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        ArrayList<Comparable> arrayList2 = new ArrayList<Comparable>();
        if (string3.length() == 0) {
            string3 = Util.firstUpper(this.m_ctxt.getUser());
        }
        for (int i = 0; i < this.m_descriptors.size(); ++i) {
            Comparable comparable;
            BreakpointDescriptor breakpointDescriptor = (BreakpointDescriptor)this.m_descriptors.get(i);
            if (this.m_groupCheck.isSelected() && this.m_groupChanged && !string.equals(((BreakpointGroup)(comparable = breakpointGroupManager.getGroup(breakpointDescriptor.getGroupId()))).getGroupName())) {
                BreakpointGroup breakpointGroup = breakpointGroupManager.getGroup(string);
                ArrayList<BreakpointDescriptor> arrayList3 = new ArrayList<BreakpointDescriptor>(1);
                arrayList3.add(breakpointDescriptor);
                breakpointGroupManager.moveBreakpoints(((BreakpointGroup)comparable).getGroupId(), breakpointGroup.getGroupId(), arrayList3);
            }
            if (this.m_svcEntryPtSupported && !this.m_styleCheck.isSelected()) continue;
            comparable = new BreakpointDescriptor(breakpointDescriptor);
            ((BreakpointDescriptor)comparable).setStyle(n);
            if (n == 0) {
                if (this.m_conditionCheck.isSelected()) {
                    ((BreakpointDescriptor)comparable).setCondition(string2);
                }
                if (this.m_threadCheck.isSelected()) {
                    switch (n2) {
                        case 0: {
                            ((BreakpointDescriptor)comparable).setThreadId("");
                            break;
                        }
                        case 1: {
                            ((BreakpointDescriptor)comparable).setThreadId("*CURRENT");
                        }
                    }
                }
                ((BreakpointDescriptor)comparable).setUser("");
            } else {
                if (this.m_userCheck.isSelected() || ((BreakpointDescriptor)comparable).getUser().length() == 0) {
                    ((BreakpointDescriptor)comparable).setUser(string3);
                }
                ((BreakpointDescriptor)comparable).setCondition("");
                ((BreakpointDescriptor)comparable).setThreadId("");
            }
            if (((BreakpointDescriptor)comparable).isEnabled()) {
                arrayList.add(comparable);
                continue;
            }
            arrayList2.add(comparable);
        }
        if (arrayList.size() > 0) {
            this.m_ctxt.getActionGroup().setLnBrkContext(arrayList);
            this.m_ctxt.getAction("ebrk").run();
        }
        if (arrayList2.size() > 0) {
            this.m_ctxt.getActionGroup().setLnBrkContext(arrayList2);
            this.m_ctxt.getAction("dbrk").run();
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void doStyle() {
        int n = this.m_styleCtrl.getSelectedIndex();
        if (this.m_style != n) {
            this.m_style = n;
            switch (this.m_style) {
                case 0: {
                    this.m_labelPanel.remove(this.m_userCheck);
                    this.m_ctrlPanel.remove(this.m_userCtrl);
                    this.m_labelPanel.add(this.m_conditionCheck);
                    this.m_labelPanel.add(this.m_threadCheck);
                    this.m_ctrlPanel.add(this.m_conditionCtrl);
                    this.m_ctrlPanel.add(this.m_threadCtrl);
                    this.m_conditionCtrl.requestFocus();
                    break;
                }
                case 1: {
                    this.m_labelPanel.remove(this.m_conditionCheck);
                    this.m_labelPanel.remove(this.m_threadCheck);
                    this.m_ctrlPanel.remove(this.m_conditionCtrl);
                    this.m_ctrlPanel.remove(this.m_threadCtrl);
                    this.m_labelPanel.add(this.m_userCheck);
                    this.m_ctrlPanel.add(this.m_userCtrl);
                    this.m_userCtrl.requestFocus();
                }
            }
            this.pack();
            this.m_panel.repaint(this.m_panel.getVisibleRect());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals("doit")) {
            this.doOk();
        } else if (string.equals(GROUP_CHECK)) {
            this.m_groupCtrl.setEnabled(this.m_groupCheck.isSelected());
        } else if (string.equals(GROUP)) {
            this.m_groupChanged = true;
        } else if (string.equals(STYLE_CHECK)) {
            boolean bl = this.m_styleCheck.isSelected();
            this.m_styleCtrl.setEnabled(bl);
            this.m_conditionCheck.setEnabled(bl);
            this.m_conditionCtrl.setEnabled(bl && this.m_conditionCheck.isSelected());
            this.m_conditionCtrl.setOpaque(bl && this.m_conditionCheck.isSelected());
            this.m_threadCheck.setEnabled(bl);
            this.m_threadCtrl.setEnabled(bl && this.m_threadCheck.isSelected());
            if (this.m_svcEntryPtSupported) {
                this.m_userCheck.setEnabled(bl);
                this.m_userCtrl.setEnabled(bl && this.m_userCheck.isSelected());
                this.m_userCtrl.setOpaque(bl && this.m_userCheck.isSelected());
            }
        } else if (string.equals(STYLE)) {
            this.doStyle();
        } else if (string.equals(COND_CHECK)) {
            this.m_conditionCtrl.setEnabled(this.m_conditionCheck.isSelected());
            this.m_conditionCtrl.setOpaque(this.m_conditionCheck.isSelected());
        } else if (string.equals(THD_CHECK)) {
            this.m_threadCtrl.setEnabled(this.m_threadCheck.isSelected());
        } else if (string.equals(USER_CHECK)) {
            this.m_userCtrl.setEnabled(this.m_userCheck.isSelected());
            this.m_userCtrl.setOpaque(this.m_userCheck.isSelected());
        }
    }

    protected class TblModel
    extends AbstractTableModel {
        protected TblModel() {
        }

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return BreakpointEditDialog.this.m_descriptors.size();
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return MRI.get("DBG_GROUP");
                }
                case 1: {
                    return MRI.get("DBG_PROGRAM");
                }
                case 2: {
                    return MRI.get("DBG_MODULE");
                }
                case 3: {
                    return MRI.get("DBG_LINE");
                }
                case 4: {
                    return MRI.get("DBG_STYLE");
                }
            }
            return "";
        }

        public Object getValueAt(int n, int n2) {
            BreakpointDescriptor breakpointDescriptor = (BreakpointDescriptor)BreakpointEditDialog.this.m_descriptors.get(n);
            switch (n2) {
                case 0: {
                    return BreakpointEditDialog.this.m_brkGrpMgr.getGroupName(breakpointDescriptor.getGroupId());
                }
                case 1: {
                    return BreakpointEditDialog.this.m_pgmMgr.getProgram(breakpointDescriptor.getViewId()).getPgmPath();
                }
                case 2: {
                    return BreakpointEditDialog.this.m_pgmMgr.getModuleName(breakpointDescriptor.getViewId());
                }
                case 3: {
                    String string = breakpointDescriptor.getAddress();
                    if (string != null) {
                        return string;
                    }
                    return String.valueOf(breakpointDescriptor.getLineNum());
                }
                case 4: {
                    return breakpointDescriptor.getStyle() == 0 ? MRI.get("DBG_DEFAULT") : MRI.get("DBG_SERVICE_ENTRY_POINT");
                }
            }
            return "";
        }

        public Class getColumnClass(int n) {
            return class$java$lang$String == null ? (class$java$lang$String = BreakpointEditDialog.class$("java.lang.String")) : class$java$lang$String;
        }
    }

    protected class Tbl
    extends JTable {
        private int m_optimumWidth;
        private DefaultTableCellRenderer m_renderer;
        private BreakpointSwatchIcon m_icon;

        public Tbl(TblModel tblModel) {
            super(tblModel);
            int n = this.getFontMetrics(this.getFont()).getHeight() - 4;
            this.m_icon = new BreakpointSwatchIcon(n);
            this.m_renderer = new DefaultTableCellRenderer();
            this.m_renderer.setIcon(this.m_icon);
        }

        public int getIconWidth() {
            return this.m_icon.getIconWidth();
        }

        public void setOptimumWidth(int n) {
            Rectangle rectangle = BreakpointEditDialog.this.getParent().getBounds();
            if (n <= rectangle.width) {
                this.m_optimumWidth = n;
            }
        }

        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension = super.getPreferredScrollableViewportSize();
            int n = BreakpointEditDialog.this.m_descriptors.size() < 20 ? BreakpointEditDialog.this.m_descriptors.size() : 20;
            dimension.height = n * this.getRowHeight();
            if (this.m_optimumWidth > dimension.width) {
                dimension.width = this.m_optimumWidth;
            }
            return dimension;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                BreakpointDescriptor breakpointDescriptor = (BreakpointDescriptor)BreakpointEditDialog.this.m_descriptors.get(n);
                this.m_icon.setColor(BreakpointEditDialog.this.m_brkGrpMgr.getGroupColor(breakpointDescriptor.getGroupId()));
                return this.m_renderer;
            }
            return super.getCellRenderer(n, n2);
        }
    }

    private class ComboRenderer
    extends DefaultListCellRenderer {
        private BreakpointSwatchIcon m_icon;

        public ComboRenderer() {
            int n = BreakpointEditDialog.this.m_groupCtrl.getFontMetrics(BreakpointEditDialog.this.m_groupCtrl.getFont()).getHeight() - 4;
            this.m_icon = new BreakpointSwatchIcon(n);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)BreakpointEditDialog.this.m_ctxt.getManager("brkgrpmgr");
                this.m_icon.setColor(breakpointGroupManager.getGroupColor((String)object));
            }
            this.setIcon(this.m_icon);
            return this;
        }
    }

    private class DummyRenderer
    extends DefaultListCellRenderer {
    }
}

