/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug.dialog;

import com.ibm.iseries.debug.DebugConstants;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.dialog.ISeriesObjName;
import com.ibm.iseries.debug.dialog.PickFromListDialog;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.request.AddPgmRequest;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.Dialog;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AddPgmDialog
extends Dialog
implements DebugConstants {
    private static final String TYPE = "type";
    private static final String OBJ1 = "obj1";
    private static final String OBJ2 = "obj2";
    private static final String RECENT = "recent";
    private DebugContext m_ctxt;
    private SettingsManager m_settingsMgr;
    private JPanel m_panel;
    private JPanel m_basePanel;
    private JPanel m_labelPanel;
    private JPanel m_ctrlPanel;
    private JPanel m_recentPanel;
    private JComboBox m_typeCtrl;
    private JLabel m_typeLabel;
    private JLabel m_label1;
    private JLabel m_label2;
    private ISeriesObjName m_obj1Ctrl;
    private ISeriesObjName m_obj2Ctrl;
    private JButton m_recentButton;
    private String m_pgmLib;
    private String m_pgmName;
    private int m_pgmType;

    public AddPgmDialog(DebugContext debugContext, int n) {
        super(debugContext.getJFrame(), MRI.get("DBG_ADD_PGM_DIALOG_TITLE"), true, "dbgaddobj");
        this.m_ctxt = debugContext;
        this.m_settingsMgr = (SettingsManager)this.m_ctxt.getManager("settmgr");
        Settings settings = this.m_ctxt.getUserConfig();
        this.m_pgmLib = settings.getString("addpgmPgmLib", "");
        this.m_pgmName = settings.getString("addpgmPgmName", "");
        boolean bl = false;
        int n2 = settings.getInt("addpgmPgmType", 1);
        if (n >= 0) {
            this.m_pgmType = n;
            bl = this.m_pgmType == n2;
        } else {
            this.m_pgmType = n2;
        }
        this.m_panel = new JPanel(new BorderLayout());
        this.m_labelPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_ctrlPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.m_basePanel = new JPanel(new BorderLayout());
        this.m_recentPanel = new JPanel(new FlowLayout());
        this.m_panel.setBorder(this.getEmptyBorder(15, 15, 15, 15));
        this.m_labelPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_ctrlPanel.setBorder(this.getEmptyBorder(10, 10, 10, 10));
        this.m_recentPanel.setBorder(this.getEmptyBorder(5, 0, 0, 0));
        this.m_basePanel.add((Component)this.m_labelPanel, this.m_isLtoR ? "West" : "East");
        this.m_basePanel.add((Component)this.m_ctrlPanel, "Center");
        this.m_basePanel.add((Component)this.m_recentPanel, this.m_isLtoR ? "East" : "West");
        this.m_panel.add((Component)this.m_basePanel, "North");
        this.m_panel.add((Component)this.defaultButtons(MRI.get("DBG_OK")), "South");
        this.setContentPane(this.m_panel);
        this.addComponents(bl);
        this.addWindowListener(new WndAdapter());
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_ctxt = null;
        this.m_settingsMgr = null;
        this.m_panel = null;
        this.m_basePanel = null;
        this.m_labelPanel = null;
        this.m_ctrlPanel = null;
        this.m_recentPanel = null;
        this.m_typeCtrl = null;
        this.m_typeLabel = null;
        this.m_label1 = null;
        this.m_label2 = null;
        this.m_obj1Ctrl = null;
        this.m_obj2Ctrl = null;
        this.m_recentButton = null;
        this.m_pgmLib = null;
        this.m_pgmName = null;
    }

    private void addComponents(boolean bl) {
        this.listenForEscape(this.m_panel);
        this.m_typeLabel = Util.getAccessibleLabel(MRI.get("DBG_TYPE_LABEL"));
        this.m_label1 = Util.getAccessibleLabel(this.m_pgmType == 2 ? MRI.get("DBG_PACKAGE_LABEL") : MRI.get("DBG_NAME_LABEL"));
        this.m_label2 = Util.getAccessibleLabel(this.m_pgmType == 2 ? MRI.get("DBG_CLASS_NAME_LABEL") : MRI.get("DBG_LIBRARY_LABEL"));
        this.m_labelPanel.add(this.m_typeLabel);
        this.m_labelPanel.add(this.m_label1);
        this.m_labelPanel.add(this.m_label2);
        this.m_typeCtrl = new JComboBox();
        this.m_typeCtrl.setRenderer(new DummyRenderer());
        this.m_typeCtrl.addItem(MRI.get("DBG_PROGRAM"));
        this.m_typeCtrl.addItem(MRI.get("DBG_SERVICE_PROGRAM"));
        this.m_typeCtrl.addItem(MRI.get("DBG_CLASS_FILE"));
        this.m_typeCtrl.setSelectedIndex(this.m_pgmType);
        this.m_typeCtrl.setActionCommand(TYPE);
        this.m_typeCtrl.addActionListener(this);
        this.m_obj1Ctrl = new ISeriesObjName(this.m_pgmType != 2);
        this.m_obj1Ctrl.setActionCommand(OBJ1);
        this.m_obj1Ctrl.addActionListener(this);
        this.m_obj2Ctrl = new ISeriesObjName(this.m_pgmType != 2);
        this.m_obj2Ctrl.setActionCommand(OBJ2);
        this.m_obj2Ctrl.addActionListener(this);
        this.m_ctrlPanel.add(this.m_typeCtrl);
        this.m_ctrlPanel.add(this.m_obj1Ctrl);
        this.m_ctrlPanel.add(this.m_obj2Ctrl);
        String string = MRI.get("DBG_RECENT_WITH_ELLIPSIS");
        this.m_recentButton = new JButton(string);
        this.m_recentButton.setActionCommand(RECENT);
        this.m_recentButton.addActionListener(this);
        this.m_recentPanel.add(this.m_recentButton);
        Dimension dimension = this.m_typeCtrl.getPreferredSize();
        Dimension dimension2 = this.m_recentButton.getPreferredSize();
        if (dimension2.height - dimension.height < 10) {
            dimension2.height = dimension.height;
        }
        this.m_recentButton.setPreferredSize(dimension2);
        Util.setAccessible((Accessible)this.m_typeCtrl, this.m_typeLabel);
        Util.setAccessible((Accessible)this.m_obj1Ctrl, this.m_label1);
        Util.setAccessible((Accessible)this.m_obj2Ctrl, this.m_label2);
        Util.setAccessible((Accessible)this.m_recentButton, string);
        Util.setOrientation(this.m_typeCtrl, this.m_typeLabel);
        Util.setOrientation(this.m_obj1Ctrl, this.m_label1);
        Util.setOrientation(this.m_obj2Ctrl, this.m_label2);
        Util.setOrientation(this.m_recentButton);
        if (this.m_settingsMgr.getRecentlyAddedPgms().size() == 0) {
            this.m_recentButton.setEnabled(false);
        }
        if (bl) {
            try {
                switch (this.m_typeCtrl.getSelectedIndex()) {
                    case 0: 
                    case 1: {
                        this.m_obj1Ctrl.setText(this.m_pgmName);
                        this.m_obj2Ctrl.setText(this.m_pgmLib);
                        break;
                    }
                    case 2: {
                        this.m_obj1Ctrl.setText(this.m_pgmLib);
                        this.m_obj2Ctrl.setText(this.m_pgmName);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void validateType() {
        int n = this.m_typeCtrl.getSelectedIndex();
        String string = "";
        String string2 = "";
        switch (n) {
            case 0: 
            case 1: {
                string = MRI.get("DBG_NAME_LABEL");
                string2 = MRI.get("DBG_LIBRARY_LABEL");
                this.m_obj1Ctrl.setQsysObject(true);
                this.m_obj2Ctrl.setQsysObject(true);
                break;
            }
            case 2: {
                string = MRI.get("DBG_PACKAGE_LABEL");
                string2 = MRI.get("DBG_CLASS_NAME_LABEL");
                this.m_obj1Ctrl.setQsysObject(false);
                this.m_obj2Ctrl.setQsysObject(false);
            }
        }
        this.m_label1.setText(string);
        this.m_label2.setText(string2);
        Util.setAccessible((Accessible)this.m_typeCtrl, this.m_typeLabel);
        Util.setAccessible((Accessible)this.m_label1, string);
        Util.setAccessible((Accessible)this.m_label2, string2);
        Util.setAccessible((Accessible)this.m_obj1Ctrl, this.m_label1);
        Util.setAccessible((Accessible)this.m_obj2Ctrl, this.m_label2);
        if (this.m_pgmType != n) {
            if (this.m_pgmType == 2 && n != 2 || n == 2 && this.m_pgmType != 2) {
                this.m_obj1Ctrl.setText("");
                this.m_obj2Ctrl.setText("");
            }
            this.m_pgmType = n;
        }
    }

    public void doOk() {
        String string = this.m_obj1Ctrl.getText().trim();
        String string2 = this.m_obj2Ctrl.getText().trim();
        int n = this.m_typeCtrl.getSelectedIndex();
        if ((n == 2 || string.length() > 0) && string2.length() > 0) {
            AddPgmRequest addPgmRequest = null;
            this.m_pgmType = n;
            switch (this.m_pgmType) {
                case 0: 
                case 1: {
                    addPgmRequest = new AddPgmRequest(string2, string, this.m_pgmType);
                    this.m_pgmLib = Util.firstUpper(string2);
                    this.m_pgmName = Util.firstUpper(string);
                    break;
                }
                case 2: {
                    addPgmRequest = new AddPgmRequest(string, string2, this.m_pgmType);
                    this.m_pgmLib = string;
                    this.m_pgmName = string2;
                }
            }
            Settings settings = this.m_ctxt.getUserConfig();
            settings.setString("addpgmPgmLib", this.m_pgmLib);
            settings.setString("addpgmPgmName", this.m_pgmName);
            settings.setInt("addpgmPgmType", this.m_pgmType);
            this.m_ctxt.postClock();
            this.m_ctxt.sendRequest(addPgmRequest);
            this.m_settingsMgr.insertRecentlyAddedPgm(new PgmDescriptor(this.m_pgmLib, this.m_pgmName, this.m_pgmType));
            this.setCanceled(false);
            this.dispose();
        } else if (string.length() == 0) {
            this.m_obj1Ctrl.requestFocus();
            this.getToolkit().beep();
        } else if (string2.length() == 0) {
            this.m_obj2Ctrl.requestFocus();
            this.getToolkit().beep();
        }
    }

    private void doRecent() {
        ArrayList arrayList = this.m_settingsMgr.getRecentlyAddedPgms();
        int n = arrayList.size();
        if (n == 0) {
            this.m_recentButton.setEnabled(false);
            return;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            PgmDescriptor pgmDescriptor = (PgmDescriptor)arrayList.get(i);
            stringArray[i] = pgmDescriptor.getPgmPath();
        }
        PickFromListDialog pickFromListDialog = new PickFromListDialog(this, MRI.get("DBG_RECENT_PGM_DIALOG_TITLE"), MRI.get("DBG_SELECT_PGM_LABEL"), MRI.get("DBG_OK"), null, stringArray, 0);
        pickFromListDialog.setSingleSelect();
        pickFromListDialog.display(this.m_ctxt);
        if (!pickFromListDialog.wasCanceled()) {
            int n2 = pickFromListDialog.getSelectedIndex();
            PgmDescriptor pgmDescriptor = (PgmDescriptor)arrayList.get(n2);
            int n3 = pgmDescriptor.getPgmType();
            if (n3 != this.m_pgmType) {
                this.m_pgmType = n3;
                this.m_typeCtrl.setSelectedIndex(this.m_pgmType);
            }
            switch (n3) {
                case 0: 
                case 1: {
                    this.m_obj1Ctrl.setText(pgmDescriptor.getPgmName());
                    this.m_obj2Ctrl.setText(pgmDescriptor.getPgmLibrary());
                    break;
                }
                case 2: {
                    this.m_obj1Ctrl.setText(pgmDescriptor.getPgmLibrary());
                    this.m_obj2Ctrl.setText(pgmDescriptor.getPgmName());
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        String string = actionEvent.getActionCommand();
        if (string.equals(OBJ1) || string.equals(OBJ2) || string.equals("doit")) {
            this.doOk();
        } else if (string.equals(TYPE)) {
            this.validateType();
        } else if (string.equals(RECENT)) {
            this.doRecent();
        }
    }

    private class WndAdapter
    extends WindowAdapter {
        private WndAdapter() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            String string = AddPgmDialog.this.m_obj1Ctrl.getText();
            String string2 = AddPgmDialog.this.m_obj2Ctrl.getText();
            switch (AddPgmDialog.this.m_typeCtrl.getSelectedIndex()) {
                case 0: 
                case 1: {
                    AddPgmDialog.this.m_obj1Ctrl.requestFocus();
                    AddPgmDialog.this.m_obj1Ctrl.selectAll();
                    break;
                }
                case 2: {
                    if (string.length() == 0) {
                        AddPgmDialog.this.m_obj1Ctrl.requestFocus();
                        AddPgmDialog.this.m_obj1Ctrl.selectAll();
                        break;
                    }
                    AddPgmDialog.this.m_obj2Ctrl.requestFocus();
                    AddPgmDialog.this.m_obj2Ctrl.selectAll();
                }
            }
        }
    }

    private class DummyRenderer
    extends DefaultListCellRenderer {
    }
}

