/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iseries.debug;

import com.ibm.iseries.debug.AbstractDebugContext;
import com.ibm.iseries.debug.DebugFrame;
import com.ibm.iseries.debug.DebuggerMenubar;
import com.ibm.iseries.debug.DebuggerToolbar;
import com.ibm.iseries.debug.Desktop;
import com.ibm.iseries.debug.PgmDescriptor;
import com.ibm.iseries.debug.PgmEnvironment;
import com.ibm.iseries.debug.manager.BreakpointGroupManager;
import com.ibm.iseries.debug.manager.BreakpointManager;
import com.ibm.iseries.debug.manager.ContextManager;
import com.ibm.iseries.debug.manager.CursorManager;
import com.ibm.iseries.debug.manager.LAFManager;
import com.ibm.iseries.debug.manager.MemoryManager;
import com.ibm.iseries.debug.manager.PgmManager;
import com.ibm.iseries.debug.manager.SettingsManager;
import com.ibm.iseries.debug.manager.SourceViewManager;
import com.ibm.iseries.debug.manager.VariableManager;
import com.ibm.iseries.debug.packet.DebuggerPacketInflater;
import com.ibm.iseries.debug.packet.StartDebugPacket;
import com.ibm.iseries.debug.request.StartDebugServerRequest;
import com.ibm.iseries.debug.request.TranslatePidRequest;
import com.ibm.iseries.debug.util.ActionGroup;
import com.ibm.iseries.debug.util.CommLink;
import com.ibm.iseries.debug.util.DebugContext;
import com.ibm.iseries.debug.util.DebugDesktop;
import com.ibm.iseries.debug.util.DebugPgmEnv;
import com.ibm.iseries.debug.util.DebugSource;
import com.ibm.iseries.debug.util.MRI;
import com.ibm.iseries.debug.util.Menubar;
import com.ibm.iseries.debug.util.Packet;
import com.ibm.iseries.debug.util.PacketInflater;
import com.ibm.iseries.debug.util.Settings;
import com.ibm.iseries.debug.util.TabPanel;
import com.ibm.iseries.debug.util.Toolbar;
import com.ibm.iseries.debug.util.Util;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.UnknownHostException;
import java.text.MessageFormat;

public class IleDebugContext
extends AbstractDebugContext {
    private PacketInflater m_inflater = new DebuggerPacketInflater(this);
    private PgmDescriptor m_pgm;
    private String m_cmdArg = "";
    private String m_classPathArg = "";
    private String m_srcPathArg = "";
    private int m_hubPortArg = -1;
    private boolean m_svcEntryPt;

    public IleDebugContext(DebugFrame debugFrame, String[] stringArray) {
        super(debugFrame);
        this.loadSettings("com/ibm/iseries/debug/idbg.cfg", ".idbg", SettingsManager.IDBG_COMMENT);
        this.parseArgs(stringArray);
        this.loadConfig();
    }

    public String getDebuggerName() {
        return MRI.get("DBG_SYSTEM_DEBUGGER");
    }

    public int getHelpSetId() {
        return 0;
    }

    public boolean isSupported(int n, double d) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                return d >= 5.10002 && d < 5.20001 || d >= 5.20002;
            }
            case 5: {
                return d >= 5.20002;
            }
            case 8: {
                return d >= 5.20003;
            }
            case 6: 
            case 7: {
                return d >= 5.30001;
            }
            case 9: {
                return d >= 5.30002 && !this.hasPartnerContext();
            }
            case 10: {
                return d >= 7.10001;
            }
            case 11: {
                return d >= 7.10002 && d < 7.2 || d >= 7.20002;
            }
        }
        return super.isSupported(n, d);
    }

    public void init() {
        if (this.m_pidArg >= 0) {
            this.establishCommLink();
            this.sendRequest(new TranslatePidRequest(this.m_pidArg));
            this.m_initialized = true;
        } else if (this.m_pgmArg.length() == 0 || this.m_jobIdArg.length() == 0) {
            this.m_initialized = true;
            this.getAction("strdbg").run();
        } else if (this.m_sysArg.length() > 0) {
            this.establishCommLink();
            this.m_initialized = true;
        } else {
            this.m_initialized = true;
        }
    }

    public void cleanUp() {
        this.m_inflater = null;
        this.m_pgm = null;
        this.m_cmdArg = null;
        this.m_classPathArg = null;
        this.m_srcPathArg = null;
        super.cleanUp();
    }

    public void clear(int n) {
        super.clear(n);
        this.m_cmdArg = "";
        this.m_classPathArg = "";
        this.m_srcPathArg = "";
        this.m_svcEntryPt = false;
    }

    public DebugContext clone(String[] stringArray) {
        IleDebugContext ileDebugContext = IleDebugContext.createIleDebugger(stringArray);
        ileDebugContext.m_initialized = false;
        return ileDebugContext;
    }

    public void firstContextEvent() {
        if (this.m_svcEntryPt) {
            this.m_svcEntryPt = false;
            if (this.m_pgm != null) {
                this.m_pgmEnv.autoOpen(this.m_pgm.getPgmLibrary(), this.m_pgm.getPgmName(), this.m_pgm.getPgmType());
            }
        }
    }

    public int getDebugOptions() {
        Settings settings = this.getUserConfig();
        int n = 0;
        if (this.m_svcEntryPt) {
            n |= 1;
        }
        if (settings.getBool("pgmCompletionOff", false)) {
            n |= 2;
        }
        if (settings.getBool("varsIncBaseClass", false)) {
            n |= 4;
        }
        if (settings.getBool("strdbgRedirectIO", false) && this.m_jobIdArg.equals("*SUBMIT")) {
            n |= 8;
        }
        if (settings.getBool("strdbgIlePase", false)) {
            n |= 0x10;
        }
        return n;
    }

    public void setTitle() {
        Object[] objectArray = new Object[]{this.m_pgmArg, Util.firstUpperJobId(this.m_jobIdArg), Util.firstUpper(Util.getSystemShortName(this.m_sysArg)), Util.firstUpper(this.m_userArg)};
        String string = MessageFormat.format(MRI.get("DBG_TITLE_BAR_FMT"), objectArray);
        this.setTitle(string);
    }

    public void setProgramInfo(Packet packet) {
        if (!(packet instanceof StartDebugPacket)) {
            return;
        }
        StartDebugPacket startDebugPacket = (StartDebugPacket)packet;
        if (startDebugPacket.strdbgFailed()) {
            this.m_initialized = true;
            return;
        }
        this.postClock();
        TabPanel tabPanel = this.getPanel("io");
        if (tabPanel != null) {
            tabPanel.setSupported(startDebugPacket.initiatedFromGUI() && this.isSupported(8, this.getSystemVersion()) && this.getUserConfig().getBool("strdbgRedirectIO", false));
        }
        if (startDebugPacket.getPgmType() != -1) {
            this.m_pgm = new PgmDescriptor(startDebugPacket.getPgmLib(), startDebugPacket.getPgmName(), startDebugPacket.getPgmType());
            this.m_pgmArg = this.m_pgm.getPgmPath();
        } else {
            this.m_pgm = null;
        }
        this.m_jobIdArg = startDebugPacket.getJobId();
        this.m_pidArg = startDebugPacket.getPID();
        this.setTitle();
        this.setDebugIcon(8);
        if (this.m_pgm != null && !this.m_svcEntryPt) {
            this.m_pgmEnv.autoOpen(this.m_pgm.getPgmLibrary(), this.m_pgm.getPgmName(), this.m_pgm.getPgmType());
        }
        this.m_initialized = true;
        this.retractClock();
    }

    public int getAddrSizeInBits() {
        return 64;
    }

    public int getAddrOffsetSizeInBits() {
        return 0;
    }

    public void primePartnerStep() {
        if (this.m_lastRunAction != 4) {
            this.m_lastRunAction = 4;
            this.m_ctxtMgr.synchronizePartnerStep();
        }
    }

    public void loadSettings(String string, String string2, String string3) {
        this.m_settingsMgr = SettingsManager.instance(0);
        this.m_settingsMgr.init(string, string2, string3);
    }

    protected ActionGroup loadActionGroup(Settings settings) {
        return new ActionGroup(this, settings);
    }

    protected DebugPgmEnv loadPgmEnv(Settings settings) {
        return new PgmEnvironment(this, ".idbgenv", MRI.get("DBG_ENV_FILTER_TITLE"));
    }

    protected void loadManagers(Settings settings) {
        this.m_mgrs.put(this.m_settingsMgr.getKey(), this.m_settingsMgr);
        BreakpointGroupManager breakpointGroupManager = new BreakpointGroupManager(this);
        BreakpointManager breakpointManager = new BreakpointManager(this);
        ContextManager contextManager = new ContextManager(this);
        PgmManager pgmManager = new PgmManager(this);
        SourceViewManager sourceViewManager = new SourceViewManager(this);
        MemoryManager memoryManager = new MemoryManager(this);
        VariableManager variableManager = new VariableManager(this);
        CursorManager cursorManager = new CursorManager();
        this.m_mgrs.put(breakpointGroupManager.getKey(), breakpointGroupManager);
        this.m_mgrs.put(breakpointManager.getKey(), breakpointManager);
        this.m_mgrs.put(contextManager.getKey(), contextManager);
        this.m_mgrs.put(pgmManager.getKey(), pgmManager);
        this.m_mgrs.put(sourceViewManager.getKey(), sourceViewManager);
        this.m_mgrs.put(memoryManager.getKey(), memoryManager);
        this.m_mgrs.put(variableManager.getKey(), variableManager);
        this.m_mgrs.put(cursorManager.getKey(), cursorManager);
        this.m_mgrs.put(LAFManager.instance().getKey(), LAFManager.instance());
    }

    protected Menubar loadMenuBar(Settings settings) {
        DebuggerMenubar debuggerMenubar = (DebuggerMenubar)Util.loadObject(settings.getString("menuBar", null));
        debuggerMenubar.init(this);
        return debuggerMenubar;
    }

    protected Toolbar loadToolBar(Settings settings) {
        DebuggerToolbar debuggerToolbar = (DebuggerToolbar)Util.loadObject(settings.getString("toolBar", null));
        debuggerToolbar.init(this);
        return debuggerToolbar;
    }

    protected DebugDesktop loadDesktop(Settings settings) {
        return new Desktop(this);
    }

    protected DebugSource loadDisassembly(Settings settings) {
        return null;
    }

    protected CommLink createCommLink() throws UnknownHostException {
        return new CommLink(this, this.m_sysArg, this.m_userArg, this.m_hubPortArg, "as-debug", this.m_inflater);
    }

    protected boolean startDebugServer() {
        StartDebugServerRequest startDebugServerRequest = new StartDebugServerRequest(this.m_pgmArg, this.m_pgmParmsArg, this.m_cmdArg, this.m_jobIdArg, this.m_userArg, this.getUserConfig().getString("strdbgJVM", ""), this.m_classPathArg, this.m_srcPathArg, this.getDebugOptions());
        startDebugServerRequest.setContext(this);
        return this.sendRequest(startDebugServerRequest);
    }

    protected void validateDebugServer(double d) {
        TabPanel tabPanel;
        super.validateDebugServer(d);
        TabPanel tabPanel2 = this.getPanel("memory");
        if (tabPanel2 != null) {
            tabPanel2.setSupported(this.isSupported(2, d));
        }
        if ((tabPanel = this.getPanel("io")) != null) {
            tabPanel.setSupported(this.isSupported(8, d) && this.getUserConfig().getBool("strdbgRedirectIO", false));
        }
    }

    public void loadConfig() {
        super.loadConfig();
        this.setTitle();
        BreakpointGroupManager breakpointGroupManager = (BreakpointGroupManager)this.getManager("brkgrpmgr");
        breakpointGroupManager.init();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseArgs(String[] stringArray) {
        Settings settings = this.m_settingsMgr.getUserConfig();
        int n = 0;
        while (n < stringArray.length) {
            char c = stringArray[n].charAt(0);
            int n2 = stringArray[n].length() > 1 ? (int)stringArray[n].charAt(1) : 32;
            boolean bl = false;
            if (c == '-' && n + 1 < stringArray.length) {
                switch (n2) {
                    case 99: {
                        if (stringArray[n].equals("-c") || stringArray[n].equals("-classpath")) {
                            this.m_classPathArg = stringArray[++n];
                            settings.setString("strdbgClassPath", this.m_classPathArg);
                            break;
                        }
                        if (stringArray[n].equals("-clientsourcepath")) {
                            settings.setString("strdbgClientSrcPath", stringArray[++n]);
                            break;
                        }
                        if (stringArray[n].equals("-command")) {
                            this.m_cmdArg = stringArray[++n];
                            settings.setString("strdbgCmd", this.m_cmdArg);
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 101: {
                        Object object;
                        if (!stringArray[n].equals("e") && !stringArray[n].equals("-exit")) break;
                        if (((String)(object = stringArray[++n].toUpperCase())).equals("YES")) {
                            this.m_frame.enableExit();
                            break;
                        }
                        this.m_frame.disableExit();
                        break;
                    }
                    case 106: {
                        if (stringArray[n].equals("-j") || stringArray[n].equals("-job")) {
                            this.m_jobIdArg = stringArray[++n];
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 108: {
                        int n3;
                        Object object;
                        if (!stringArray[n].equals("-location") || (n3 = ((String)(object = stringArray[++n])).indexOf(120)) <= 0) break;
                        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                        int n4 = Integer.parseInt(((String)object).substring(0, n3));
                        int n5 = Integer.parseInt(((String)object).substring(n3 + 1));
                        if (n4 >= 0 && n4 < dimension.width) {
                            settings.setInt("windowLeft", n4);
                        }
                        if (n5 < 0 || n5 >= dimension.height) break;
                        settings.setInt("windowTop", n5);
                        break;
                    }
                    case 112: {
                        Object object;
                        if (stringArray[n].equals("-p") || stringArray[n].equals("-program")) {
                            this.m_pgmArg = stringArray[++n];
                            if (this.m_pgmArg.trim().length() <= 0 || (object = new PgmDescriptor(this.m_pgmArg)) == null) break;
                            settings.setString("strdbgPgmLib", ((PgmDescriptor)object).getPgmLibrary());
                            settings.setString("strdbgPgmName", ((PgmDescriptor)object).getPgmName());
                            settings.setInt("strdbgPgmType", ((PgmDescriptor)object).getPgmType());
                            break;
                        }
                        if (stringArray[n].equals("-parms")) {
                            while (++n < stringArray.length) {
                                this.m_pgmParmsArg = this.m_pgmParmsArg + stringArray[n];
                                this.m_pgmParmsArg = this.m_pgmParmsArg + " ";
                            }
                            this.m_pgmParmsArg.trim();
                            settings.setString("strdbgPgmParms", this.m_pgmParmsArg);
                            break;
                        }
                        if (stringArray[n].equals("-pid")) {
                            this.m_pidArg = Integer.parseInt(stringArray[++n]);
                            break;
                        }
                        if (stringArray[n].equals("-port")) {
                            this.m_hubPortArg = Integer.parseInt(stringArray[++n]);
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 115: {
                        Object object;
                        if (stringArray[n].equals("-s") || stringArray[n].equals("-system")) {
                            this.m_sysArg = stringArray[++n];
                            break;
                        }
                        if (stringArray[n].equals("-sourcepath")) {
                            this.m_srcPathArg = stringArray[++n];
                            settings.setString("strdbgHostSrcPath", this.m_srcPathArg);
                            break;
                        }
                        if (stringArray[n].equals("-svcept")) {
                            this.m_svcEntryPt = true;
                            break;
                        }
                        if (stringArray[n].equals("-srcUnicode")) {
                            object = stringArray[++n].toUpperCase();
                            SourceViewManager.setUnicodeSrc(((String)object).equals("YES"));
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 117: {
                        if (stringArray[n].equals("-u") || stringArray[n].equals("-user")) {
                            this.m_userArg = stringArray[++n];
                            break;
                        }
                        bl = true;
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                System.out.println("Bad argument: " + stringArray[n]);
            }
            ++n;
        }
        return;
    }

    public static IleDebugContext createIleDebugger(String[] stringArray) {
        DebugFrame debugFrame = new DebugFrame();
        IleDebugContext ileDebugContext = new IleDebugContext(debugFrame, stringArray);
        debugFrame.addInitialDebugContext(ileDebugContext);
        debugFrame.pack();
        debugFrame.setVisible(true);
        ileDebugContext.init();
        return ileDebugContext;
    }
}

