/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.cl.ast;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import miworkplace.ui.editor.cl.ast.AbstractToken;
import miworkplace.ui.editor.cl.ast.Token;
import org.apache.commons.lang3.StringUtils;

public class Tokenizer {
    public List<AbstractToken> tokenize(String text) throws IOException {
        text = (String)text + "\n";
        LinkedList<AbstractToken> tokens = new LinkedList<AbstractToken>();
        if (((String)text).trim().length() == 0) {
            return tokens;
        }
        AtomicInteger offset = new AtomicInteger(0);
        AtomicInteger line = new AtomicInteger(0);
        StringBuilder builder = new StringBuilder();
        PushbackReader reader = new PushbackReader(new BufferedReader(new StringReader((String)text)), 1000);
        int rawChar = reader.read();
        do {
            char c = (char)rawChar;
            if (builder.length() > 0) {
                switch (c) {
                    case '(': 
                    case ')': 
                    case '+': 
                    case '-': 
                    case '/': 
                    case ':': {
                        if (builder.length() > 0) {
                            tokens.add(new Token(offset.get() - builder.length(), line.get(), builder.toString()));
                            builder.delete(0, builder.length());
                        }
                        tokens.add(new Token(offset.get() - 1, line.get(), String.valueOf(c)));
                        break;
                    }
                    case ' ': {
                        tokens.add(new Token(offset.get() - builder.length(), line.get(), builder.toString()));
                        builder.delete(0, builder.length());
                        break;
                    }
                    case '\n': {
                        tokens.add(new Token(offset.get() - builder.length(), line.get(), builder.toString()));
                        builder.delete(0, builder.length());
                        line.incrementAndGet();
                        break;
                    }
                    default: {
                        builder.append(c);
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '/': {
                        int nextRaw = reader.read();
                        char nextChar = (char)nextRaw;
                        if (nextChar == '*') {
                            reader.unread(nextChar);
                            reader.unread(c);
                            this.parseComment(reader, offset, line, tokens);
                            break;
                        }
                        if (nextChar == '/') {
                            tokens.add(new Token(offset.get() - builder.length(), line.get(), "//"));
                            builder.setLength(0);
                            break;
                        }
                        reader.unread(nextRaw);
                        break;
                    }
                    case '\'': {
                        reader.unread(rawChar);
                        this.parseString('\'', reader, offset, line, tokens);
                        break;
                    }
                    case '\"': {
                        reader.unread(rawChar);
                        this.parseString('\"', reader, offset, line, tokens);
                        break;
                    }
                    case '\n': {
                        line.incrementAndGet();
                        break;
                    }
                    case '(': 
                    case ')': 
                    case '+': 
                    case '-': {
                        tokens.add(new Token(offset.get() - 1, line.get(), String.valueOf(c)));
                        break;
                    }
                    case ' ': {
                        break;
                    }
                    default: {
                        builder.append(c);
                    }
                }
            }
            rawChar = reader.read();
            offset.incrementAndGet();
        } while (rawChar != -1);
        return tokens;
    }

    private void parseComment(PushbackReader reader, AtomicInteger offset, AtomicInteger line, List<AbstractToken> tokens) throws IOException {
        StringBuilder builder = new StringBuilder();
        int rawChar = reader.read();
        block6: do {
            char c = (char)rawChar;
            switch (c) {
                case ' ': {
                    if (builder.length() <= 0) break;
                    tokens.add(new Token(offset.get() - builder.length(), line.get(), builder.toString()));
                    builder.delete(0, builder.length());
                    break;
                }
                case '+': 
                case '-': {
                    if (this.isLastNonWhitespace(reader)) {
                        if (builder.length() > 0) {
                            tokens.add(new Token(offset.get() - builder.length(), line.get(), builder.toString()));
                            builder.delete(0, builder.length());
                        }
                        tokens.add(new Token(offset.get() - 1, line.get(), String.valueOf(c)));
                        break;
                    }
                    builder.append(c);
                    break;
                }
                case '/': {
                    builder.append(c);
                    if (builder.length() <= 1 || builder.charAt(builder.length() - 2) != '*') break;
                    tokens.add(new Token(offset.get() - builder.length(), line.get(), builder.toString()));
                    break block6;
                }
                case '\n': {
                    line.incrementAndGet();
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            rawChar = reader.read();
            offset.incrementAndGet();
        } while (rawChar != -1);
        if (rawChar == -1) {
            tokens.add(new Token(offset.get() - builder.length(), line.get(), builder.toString()));
        }
    }

    private void parseString(char startChar, PushbackReader reader, AtomicInteger offset, AtomicInteger line, List<AbstractToken> tokens) throws IOException {
        StringBuilder builder = new StringBuilder();
        int rawChar = reader.read();
        do {
            char c;
            if ((c = (char)rawChar) == startChar) {
                builder.append(c);
                if (builder.length() > 1) {
                    tokens.add(new Token(offset.get() - builder.length(), line.get(), builder.toString()));
                    break;
                }
            } else {
                switch (c) {
                    case '+': 
                    case '-': {
                        if (this.isLastNonWhitespace(reader)) {
                            if (builder.length() > 0) {
                                tokens.add(new Token(offset.get() - builder.length(), line.get(), builder.toString()));
                                builder.delete(0, builder.length());
                            }
                            tokens.add(new Token(offset.get() - 1, line.get(), String.valueOf(c)));
                            break;
                        }
                        builder.append(c);
                        break;
                    }
                    case ' ': {
                        if (builder.length() == 0) break;
                        builder.append(c);
                        break;
                    }
                    case '\n': {
                        line.incrementAndGet();
                        break;
                    }
                    default: {
                        builder.append(c);
                    }
                }
            }
            rawChar = reader.read();
            offset.incrementAndGet();
        } while (rawChar != -1);
        if (rawChar == -1) {
            tokens.add(new Token(offset.get() - builder.length(), line.get(), builder.toString()));
        }
    }

    private boolean isLastNonWhitespace(PushbackReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        int raw = reader.read();
        while (raw != -1) {
            char c = (char)raw;
            if (c == '\n') break;
            sb.append(c);
            if (!Character.isWhitespace(c)) break;
            raw = reader.read();
        }
        if (sb.length() == 0) {
            if (raw >= 0) {
                reader.unread(raw);
            }
            return true;
        }
        reader.unread(sb.toString().toCharArray());
        return StringUtils.isWhitespace((CharSequence)sb.toString());
    }
}

