/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor.cl.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import miworkplace.ui.editor.cl.ast.AbstractToken;
import miworkplace.ui.editor.cl.ast.Comment;
import miworkplace.ui.editor.cl.ast.File;
import miworkplace.ui.editor.cl.ast.Label;
import miworkplace.ui.editor.cl.ast.Parameter;
import miworkplace.ui.editor.cl.ast.Subroutine;
import miworkplace.ui.editor.cl.ast.Variable;

public class Ast {
    private final List<Parameter> parameters = new LinkedList<Parameter>();
    private final List<Variable> variables = new ArrayList<Variable>();
    private final List<File> files = new LinkedList<File>();
    private final List<Subroutine> subroutines = new LinkedList<Subroutine>();
    private final List<Comment> comments = new LinkedList<Comment>();
    private final List<Label> labels = new LinkedList<Label>();
    private List<AbstractToken> tokens;

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public List<Parameter> listParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public void addVariable(Variable v) {
        this.variables.add(v);
    }

    public List<Variable> listVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public List<Label> listLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public void addLabel(Label l) {
        this.labels.add(l);
    }

    public void addFile(File f) {
        this.files.add(f);
    }

    public void addComment(Comment comment) {
        this.comments.add(comment);
    }

    public List<File> listFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public void addSubroutine(Subroutine subroutine) {
        this.subroutines.add(subroutine);
    }

    public List<Subroutine> listSubroutines() {
        return Collections.unmodifiableList(this.subroutines);
    }

    public List<Comment> listComments() {
        return Collections.unmodifiableList(this.comments);
    }

    public void setTokens(List<AbstractToken> tokens) {
        this.tokens = tokens;
    }

    public List<AbstractToken> listTokens() {
        return Collections.unmodifiableList(this.tokens);
    }
}

