/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.url;

import java.io.IOException;
import miworkplace.services.api.IUrlService;
import org.osgi.service.log.LogService;

public class UrlService
implements IUrlService {
    private LogService logger;

    void bindLogService(LogService logger) {
        this.logger = logger;
    }

    void unbindLogService(LogService logger) {
        this.logger = null;
    }

    @Override
    public void open(String url) {
        try {
            if (this.isLinux()) {
                Runtime.getRuntime().exec("xdg-open " + url);
            } else if (this.isMac()) {
                Runtime.getRuntime().exec("open " + url);
            } else if (this.isWindows()) {
                Runtime.getRuntime().exec("cmd /c start " + url);
            } else {
                this.logger.log(2, "Unsupported system for opening url " + url + ". OS: " + System.getProperty("os.name"));
            }
        }
        catch (IOException ioe) {
            this.logger.log(2, "Could not open url " + url + ". Error: " + ioe.getMessage());
        }
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    private boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }
}

