/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.saved;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.services.api.ISavedResourceStore;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.LogService;

public class SavedResourceStore
implements ISavedResourceStore,
EventHandler {
    private static final int MAX_RESOURCES = 10;
    private LinkedList<String> resources = new LinkedList();
    private IPath bundleStateLocation;
    private LogService logger;

    void activate() {
        Bundle bundle = Platform.getBundle((String)"miworkplace.services");
        this.bundleStateLocation = Platform.getStateLocation((Bundle)bundle);
        this.load();
    }

    public void bindLogService(LogService logger) {
        this.logger = logger;
    }

    public void unbindLogService(LogService logger) {
        this.logger = null;
    }

    private void load() {
        File file = this.getFile();
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileReader in = new FileReader(file);
            List lines = IOUtils.readLines((Reader)in);
            this.resources.addAll(lines);
        }
        catch (Exception e) {
            this.logger.log(1, "Could not load saved resources.", (Throwable)e);
        }
    }

    private void persist() {
        File file = this.getFile();
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
            String data = String.join((CharSequence)"\n", this.resources);
            FileWriter out = new FileWriter(file);
            IOUtils.write((String)data, (Writer)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.logger.log(1, "Could not store saved resources.", (Throwable)e);
        }
    }

    private File getFile() {
        return this.bundleStateLocation.append("miworkplace.services.saved.txt").toFile();
    }

    @Override
    public List<String> list() {
        return Collections.unmodifiableList(this.resources);
    }

    @Override
    public void add(String url) {
        this.resources.remove(url);
        this.resources.addFirst(url);
        if (this.resources.size() > 10) {
            this.resources.removeLast();
        }
        this.persist();
    }

    public void handleEvent(Event event) {
        String connection = event.getProperty("connection").toString();
        String ifsPath = event.getProperty("memberPath").toString();
        this.add(EditorInputUriUtil.buildInputUri((String)connection, (String)ifsPath));
    }
}

