/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.properties;

import com.ibm.as400.access.IFSFile;
import jakarta.inject.Inject;
import java.util.Date;
import java.util.HashMap;
import miworkplace.common.model.IRemoteObject;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import miworkplace.services.properties.MemberPropertyValueMapper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;

public class StreamFilePropertiesLoader
extends Job {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IObjectPropertiesStore objectPropertiesStore;
    @Inject
    private IRemoteObject object;
    private MemberPropertyValueMapper valueMapper;

    public StreamFilePropertiesLoader() {
        super("Retrieving member description information");
        this.setPriority(20);
        this.valueMapper = new MemberPropertyValueMapper();
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            IFSFile ifs = new IFSFile(this.object.getConnection().getSystem(), this.object.getPath());
            ifs.clearCachedAttributes();
            HashMap<ObjectProperty, Object> properties = new HashMap<ObjectProperty, Object>();
            properties.put(ObjectProperty.ccsid, this.valueMapper.map(ObjectProperty.ccsid, ifs.getCCSID()));
            properties.put(ObjectProperty.changedate, this.valueMapper.map(ObjectProperty.changedate, new Date(ifs.lastModified())));
            properties.put(ObjectProperty.creationdate, this.valueMapper.map(ObjectProperty.creationdate, new Date(ifs.created())));
            properties.put(ObjectProperty.lastuseddate, this.valueMapper.map(ObjectProperty.lastuseddate, new Date(ifs.lastAccessed())));
            properties.put(ObjectProperty.filename, this.valueMapper.map(ObjectProperty.filename, ifs.getName()));
            properties.put(ObjectProperty.freeSpace, this.valueMapper.map(ObjectProperty.freeSpace, ifs.getFreeSpace()));
            properties.put(ObjectProperty.directory, this.valueMapper.map(ObjectProperty.directory, ifs.getParent()));
            properties.put(ObjectProperty.name, this.valueMapper.map(ObjectProperty.name, ifs.getName()));
            properties.put(ObjectProperty.access, this.valueMapper.map(ObjectProperty.access, (ifs.canRead() ? "R" : "") + (ifs.canWrite() ? "W" : "") + (ifs.canExecute() ? "X" : "")));
            properties.put(ObjectProperty.owner, this.valueMapper.map(ObjectProperty.owner, ifs.getOwnerName()));
            properties.put(ObjectProperty.fileSystemType, this.valueMapper.map(ObjectProperty.fileSystemType, ifs.getFileSystemType()));
            try {
                properties.put(ObjectProperty.symbolicLink, this.valueMapper.map(ObjectProperty.symbolicLink, ifs.getPathPointedTo() == null ? "*N" : ifs.getPathPointedTo()));
                properties.put(ObjectProperty.asp, this.valueMapper.map(ObjectProperty.asp, ifs.getASP()));
            }
            catch (Exception exception) {
                properties.put(ObjectProperty.symbolicLink, this.valueMapper.map(ObjectProperty.symbolicLink, "*N"));
                properties.put(ObjectProperty.asp, this.valueMapper.map(ObjectProperty.asp, ifs.getASP()));
            }
            this.objectPropertiesStore.put(this.object, properties);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org.eclipse.e4.data", this.object);
            map.put("connection", this.object.getConnection().getName());
            map.put("path", this.object.getPath());
            this.eventBroker.post("miworkplace/ui/loader/description/loaded", map);
            return new Status(0, "miworkplace.services", "Finished loading IFS description of " + this.object.getName() + ".");
        }
        catch (Exception e) {
            return new Status(4, "miworkplace.services", "Error during loading IFS description of " + this.object.getName() + ".", (Throwable)e);
        }
    }
}

