/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.properties;

import com.ibm.as400.access.MemberDescription;
import jakarta.inject.Inject;
import java.util.HashMap;
import miworkplace.common.model.IRemoteObject;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import miworkplace.services.properties.MemberPropertyValueMapper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;

public class MemberPropertiesLoader
extends Job {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IObjectPropertiesStore objectPropertiesStore;
    @Inject
    private IRemoteObject object;
    private MemberPropertyValueMapper valueMapper;

    public MemberPropertiesLoader() {
        super("Retrieving member description information");
        this.setPriority(20);
        this.valueMapper = new MemberPropertyValueMapper();
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            MemberDescription memberDesc = new MemberDescription(this.object.getConnection().getSystem(), this.object.getPath());
            memberDesc.refresh();
            HashMap<ObjectProperty, Object> properties = new HashMap<ObjectProperty, Object>();
            properties.put(ObjectProperty.changedate, this.valueMapper.map(ObjectProperty.changedate, memberDesc.getValue(17)));
            properties.put(ObjectProperty.creationdate, this.valueMapper.map(ObjectProperty.creationdate, memberDesc.getValue(6)));
            properties.put(ObjectProperty.lastuseddate, this.valueMapper.map(ObjectProperty.lastuseddate, memberDesc.getValue(22)));
            properties.put(ObjectProperty.filename, this.valueMapper.map(ObjectProperty.filename, memberDesc.getValue(1)));
            properties.put(ObjectProperty.library, this.valueMapper.map(ObjectProperty.library, memberDesc.getValue(2)));
            properties.put(ObjectProperty.name, this.valueMapper.map(ObjectProperty.name, memberDesc.getValue(3)));
            properties.put(ObjectProperty.textdescription, this.valueMapper.map(ObjectProperty.textdescription, memberDesc.getValue(8)));
            properties.put(ObjectProperty.daysused, this.valueMapper.map(ObjectProperty.daysused, memberDesc.getValue(21)));
            properties.put(ObjectProperty.restoredate, this.valueMapper.map(ObjectProperty.restoredate, memberDesc.getValue(19)));
            properties.put(ObjectProperty.savedate, this.valueMapper.map(ObjectProperty.savedate, memberDesc.getValue(18)));
            properties.put(ObjectProperty.attribute, this.valueMapper.map(ObjectProperty.attribute, memberDesc.getValue(5)));
            this.objectPropertiesStore.put(this.object, properties);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org.eclipse.e4.data", this.object);
            map.put("connection", this.object.getConnection().getName());
            map.put("path", this.object.getPath());
            this.eventBroker.post("miworkplace/ui/loader/description/loaded", map);
            return new Status(0, "miworkplace.services", "Finished loading of member description of " + this.object.getName() + ".");
        }
        catch (Exception e) {
            return new Status(4, "miworkplace.services", "Error during loading of member description of " + this.object.getName() + ".", (Throwable)e);
        }
    }
}

