/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.lock;

import com.ibm.as400.access.QSYSObjectPathName;
import java.text.MessageFormat;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.services.api.ILock;
import miworkplace.services.lock.AbstractLock;

public class ObjectLock
extends AbstractLock {
    Debug logger = Debug.getInstance();

    public ObjectLock(IConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ILock lock(IConnectionUtilities pUtil) throws Exception {
        QSYSObjectPathName ifsPath = new QSYSObjectPathName(this.getResourcePath());
        String command = "ALCOBJ OBJ((" + ifsPath.getLibraryName() + "/" + ifsPath.getObjectName() + " *" + ifsPath.getObjectType() + ") *EXCLRD) WAIT(1)";
        try {
            pUtil.executeRemoteCommand(this.getConnection(), command);
            this.logger.debug((Option)miworkplace.services.debug.Option.conn, "Object " + ifsPath.getObjectName() + " locked.");
        }
        catch (Exception e) {
            Exception exception = new Exception(MessageFormat.format("Could not acquire lock on object {0}.", this.getResourcePath()), e);
            this.logger.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        return this;
    }

    @Override
    public ILock unlock(IConnectionUtilities pUtil) throws Exception {
        QSYSObjectPathName ifsPath = new QSYSObjectPathName(this.getResourcePath());
        String command = "DLCOBJ OBJ((" + ifsPath.getLibraryName() + "/" + ifsPath.getObjectName() + " *" + ifsPath.getObjectType() + " *EXCLRD))";
        try {
            pUtil.executeRemoteCommand(this.getConnection(), command);
        }
        catch (Exception e) {
            Exception exception = new Exception(MessageFormat.format("Could not release lock on object {0}.", this.getResourcePath()), e);
            this.logger.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        return this;
    }
}

