/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.doubleclick;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import miworkplace.services.api.IDoubleClickExecutor;
import miworkplace.services.api.IDoubleClickServiceProvider;
import org.eclipse.e4.core.commands.ECommandService;
import org.osgi.service.log.LogService;

public class DoubleClickServiceProvider
implements IDoubleClickServiceProvider {
    private List<IDoubleClickExecutor> executors = new LinkedList<IDoubleClickExecutor>();
    @Inject
    private LogService logger;
    @Inject
    private ECommandService commandService;

    @Override
    public IDoubleClickExecutor get(Object object) {
        for (IDoubleClickExecutor executor : this.executors) {
            if (!executor.canExecute(this.commandService, object)) continue;
            return executor;
        }
        return null;
    }

    @Override
    public void register(IDoubleClickExecutor executor) {
        this.executors.add(executor);
        this.executors.add(executor);
        Collections.sort(this.executors, new Comparator<IDoubleClickExecutor>(){

            @Override
            public int compare(IDoubleClickExecutor dce1, IDoubleClickExecutor dce2) {
                return dce1.getRanking().compareTo(dce2.getRanking());
            }
        });
        this.logger.log(4, "Added executor " + executor.getClass().getName());
    }

    @Override
    public void deregister(IDoubleClickExecutor executor) {
        this.executors.remove(executor);
        this.logger.log(4, "Removed executor " + executor.getClass().getName());
    }
}

