/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.contenttype;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.ContentType;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.services.api.IContentTypeRegistry;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ContentTypeRegistry
implements IContentTypeRegistry {
    private static final String DOT = ".";
    private Debug fLogger = Debug.getInstance();
    private IEclipsePreferences fPreferences;
    private Map<String, ContentType> contentTypes = new HashMap<String, ContentType>();
    private PreferenceChangeListener preferenceChangeListener = new PreferenceChangeListener();

    @Override
    public void registerContentType(ContentType contentType) {
        this.contentTypes.put(contentType.getId(), contentType);
    }

    @Override
    public void unregisterContentType(ContentType contentType) {
        this.contentTypes.remove(contentType.getId());
    }

    @Override
    public List<ContentType> list() {
        return Collections.unmodifiableList(new LinkedList<ContentType>(this.contentTypes.values()));
    }

    @Override
    public List<ContentType> getContentType(IRemoteObject input) {
        LinkedList<ContentType> matches = new LinkedList<ContentType>();
        block0: for (ContentType contentType : this.contentTypes.values()) {
            for (String mapping : contentType.getMappings()) {
                if (!this.match(mapping, input)) continue;
                matches.add(contentType);
                continue block0;
            }
        }
        return matches;
    }

    @Override
    public List<ContentType> getContentType(String relativeName) {
        LinkedList<ContentType> matches = new LinkedList<ContentType>();
        block0: for (ContentType contentType : this.contentTypes.values()) {
            for (String mapping : contentType.getMappings()) {
                if (!ContentTypeRegistry.match(mapping, relativeName)) continue;
                matches.add(contentType);
                continue block0;
            }
        }
        return matches;
    }

    private boolean match(String pattern, IRemoteObject input) {
        String p = ContentTypeRegistry.escapePattern(pattern.toLowerCase());
        this.fLogger.debug((Option)miworkplace.services.debug.Option.general, "Using pattern " + p + " on " + input.getPath());
        boolean matchResult = input.getName().toLowerCase().matches(p);
        if (!matchResult) {
            if (input instanceof SourceMember) {
                Object filename = input.getName() + DOT + ((SourceMember)input).getSourceType();
                filename = ((String)filename).toLowerCase();
                matchResult = ((String)filename).matches(p);
            } else if (!(input instanceof StreamFile)) {
                Object filename = input.getName() + DOT + input.getType().abbr();
                filename = ((String)filename).toLowerCase();
                matchResult = ((String)filename).matches(pattern);
            }
        }
        this.fLogger.debug((Option)miworkplace.services.debug.Option.general, "Matching " + input.getPath() + " is " + matchResult);
        return matchResult;
    }

    private static boolean match(String pattern, String relativeName) {
        return relativeName.toLowerCase().matches(ContentTypeRegistry.escapePattern(pattern.toLowerCase()));
    }

    private static String escapePattern(String pattern) {
        String s = pattern.replaceAll("\\.", "\\\\.");
        s = s.replaceAll("\\*", ".*");
        return s;
    }

    public IEclipsePreferences getPreferences() {
        return this.fPreferences;
    }

    @Override
    public void setPreferences(IEclipsePreferences preferences) {
        this.fPreferences = preferences;
        this.addPreferencesListener();
        this.updateContentTypes();
    }

    private void updateContentType(String id) {
        String value = this.fPreferences.get(id, "");
        if (!value.isEmpty()) {
            String[] mappings = value.split("\";\"");
            this.contentTypes.get(id).setMappings(Arrays.asList(mappings));
            this.fLogger.debug((Option)miworkplace.services.debug.Option.general, "Content type " + id + " updated");
        }
    }

    private void updateContentTypes() {
        for (ContentType contentType : this.contentTypes.values()) {
            this.updateContentType(contentType.getId());
        }
    }

    private void addPreferencesListener() {
        this.getPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.preferenceChangeListener);
    }

    class PreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        PreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (ContentTypeRegistry.this.contentTypes.containsKey(event.getKey())) {
                ContentTypeRegistry.this.updateContentType(event.getKey());
            }
        }
    }
}

