/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.api;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import miworkplace.services.api.ICompileSettings;

public class CompileSettings
implements ICompileSettings {
    private String id;
    private String name;
    private String command;
    private String arguments;
    private List<String> defaultSourceTypes = new LinkedList<String>();
    private Boolean ifs = Boolean.FALSE;

    public CompileSettings(ICompileSettings pCompileSettings) {
        this.id = pCompileSettings.getId();
        this.name = pCompileSettings.getName();
        this.command = pCompileSettings.getCompileCommand();
        this.arguments = pCompileSettings.getCompileArguments();
        this.defaultSourceTypes.addAll(pCompileSettings.getDefaultSourceTypes());
        this.ifs = pCompileSettings.isIfsSetting();
    }

    public CompileSettings() {
    }

    @Override
    public CompileSettings setCompileCommand(String command) {
        this.command = command;
        return this;
    }

    @Override
    public CompileSettings setArguments(String arguments) {
        this.arguments = arguments;
        return this;
    }

    @Override
    public CompileSettings setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public CompileSettings setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name == null ? "??" : this.name;
    }

    @Override
    public String getCompileCommand() {
        return this.command == null ? "??" : this.command;
    }

    @Override
    public String getCompileArguments() {
        return this.arguments == null ? "" : this.arguments;
    }

    public CompileSettings addDefaultSourceType(String sourceType) {
        this.defaultSourceTypes.add(sourceType.toLowerCase());
        return this;
    }

    @Override
    public List<String> getDefaultSourceTypes() {
        return Collections.unmodifiableList(this.defaultSourceTypes);
    }

    public CompileSettings setIfsSetting(Boolean ifs) {
        this.ifs = ifs;
        return this;
    }

    @Override
    public boolean isIfsSetting() {
        return this.ifs;
    }

    @Override
    public CompileSettings setDefaultSourceTypes(List<String> sourceTypes) {
        this.defaultSourceTypes.clear();
        for (String sourceType : sourceTypes) {
            this.defaultSourceTypes.add(sourceType.toLowerCase().trim());
        }
        return this;
    }

    @Override
    public ICompileSettings setIfs(boolean IFS) {
        this.ifs = IFS;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompileSettings other = (CompileSettings)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "CompileSettings [id=" + this.id + ", name=" + this.name + ", command=" + this.command + ", arguments=" + this.arguments + ", defaultSourceTypes=" + String.valueOf(this.defaultSourceTypes) + ", ifs=" + String.valueOf(this.ifs) + "]";
    }
}

