/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.alive;

import miworkplace.common.debug.Debug;
import miworkplace.common.debug.MiWorkplaceTraceException;
import miworkplace.common.model.IConnection;
import miworkplace.services.debug.Option;

public class KeepAliveWorker
implements Runnable {
    private Debug logger = Debug.getInstance();
    private final IConnection connection;
    private boolean fStop = false;

    public KeepAliveWorker(IConnection connection) {
        this.connection = connection;
        this.fStop = false;
        Thread thread = new Thread((Runnable)this, "Keep alive worker for " + connection.getName());
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this.logger.debug((miworkplace.common.debug.Option)Option.keepAlive, "Keep alive worker stop requested.", (Throwable)new MiWorkplaceTraceException());
        this.fStop = true;
    }

    @Override
    public void run() {
        this.logger.debug((miworkplace.common.debug.Option)Option.conn, Thread.currentThread().getName() + " started.");
        try {
            Thread.sleep(60000L);
            while (!this.fStop) {
                boolean alive = this.connection.ping();
                this.logger.debug((miworkplace.common.debug.Option)Option.keepAlive, "Connection " + this.connection.getName() + " alive: " + alive);
                if (!alive) {
                    Thread.sleep(5000L);
                    continue;
                }
                Thread.sleep(60000L);
            }
        }
        catch (InterruptedException interruptedException) {}
    }
}

