/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ui.framework;

import com.ibm.ui.framework.ConditionalBlock2;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.lang.reflect.Method;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class MessagePump2 {
    private EventQueue m_queue;
    private boolean m_doDispatch = true;
    private static final String handlerPropName = "sun.awt.exception.handler";
    private static String handlerClassName = null;
    private static String NO_HANDLER = new String();
    private static final boolean dbgFlag = false;
    private static final boolean dbgFlag2 = false;

    public MessagePump2(EventQueue eventQueue) {
        this.m_queue = eventQueue;
    }

    public EventQueue getEventQueue() {
        return this.m_queue;
    }

    public boolean isDispatching(EventQueue eventQueue) {
        return this.m_queue.equals(eventQueue);
    }

    public void stopDispatching() {
        this.m_doDispatch = false;
        this.m_queue.postEvent(new EmptyEvent());
    }

    void pumpEvents(ConditionalBlock2 conditionalBlock2) {
        MessagePump2.debug("pumpEvents entered!");
        while (this.m_doDispatch && conditionalBlock2.evaluate()) {
            if (!Thread.currentThread().isInterrupted() && this.pumpOneEvent()) continue;
            this.m_doDispatch = false;
        }
        this.m_queue.postEvent(new EmptyEvent());
        MessagePump2.debug("pumpEvents exiting!");
    }

    boolean pumpOneEvent() {
        try {
            AWTEvent aWTEvent = this.m_queue.getNextEvent();
            MessagePump2.debug2("Processing event " + aWTEvent);
            Object object = aWTEvent.getSource();
            if (aWTEvent instanceof ActiveEvent) {
                ((ActiveEvent)((Object)aWTEvent)).dispatch();
            } else if (object instanceof Component) {
                ((Component)object).dispatchEvent(aWTEvent);
            } else if (object instanceof MenuComponent) {
                ((MenuComponent)object).dispatchEvent(aWTEvent);
            } else {
                System.err.println("unable to dispatch event: " + aWTEvent);
            }
            return true;
        }
        catch (ThreadDeath threadDeath) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (Throwable throwable) {
            if (!this.handleException(throwable)) {
                System.err.println("Exception occurred during event dispatching:");
                throwable.printStackTrace();
            }
            return true;
        }
    }

    private boolean handleException(Throwable throwable) {
        try {
            Object obj;
            Method method;
            if (handlerClassName == NO_HANDLER) {
                return false;
            }
            if (handlerClassName == null && (handlerClassName = AccessController.doPrivileged(new GetPropertyAction(handlerPropName))) == null) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = Class.forName(handlerClassName, true, classLoader);
                method = clazz.getMethod("handle", Throwable.class);
                obj = clazz.newInstance();
            }
            catch (Throwable throwable2) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            method.invoke(obj, throwable);
        }
        catch (Throwable throwable3) {
            return false;
        }
        return true;
    }

    private static final void debug(String string) {
    }

    private static final void debug2(String string) {
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 2000, 2000";
    }

    class EmptyEvent
    extends AWTEvent
    implements ActiveEvent {
        public EmptyEvent() {
            super(MessagePump2.this, 0);
        }

        public void dispatch() {
        }
    }
}

