/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.ColumnDescriptor;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.java.ComponentAttributeAssociation;
import com.ibm.as400.ui.framework.java.ItemDescriptor;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.NodeDescriptor;
import com.ibm.as400.ui.framework.java.PanelTableModel;
import com.ibm.as400.ui.framework.java.PanelTreeTable;
import com.ibm.as400.ui.framework.java.PanelTreeTableNode;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PanelTreeTableModel
extends PanelTableModel
implements TreeExpansionListener,
TreeModelListener,
TreeWillExpandListener {
    JTree m_jTree;
    DefaultTreeModel m_treeModel = null;
    PanelTreeTable m_treeTable;
    ComponentAttributeAssociation m_caa;

    public PanelTreeTableModel(Vector vector) {
        super(vector);
    }

    public void setRendererTree(JTree jTree) {
        this.m_jTree = jTree;
        this.m_jTree.addTreeWillExpandListener(this);
    }

    public void setTable(PanelTreeTable panelTreeTable) {
        this.m_treeTable = panelTreeTable;
    }

    public void setComponentAttributeAssociation(ComponentAttributeAssociation componentAttributeAssociation) {
        this.m_caa = componentAttributeAssociation;
    }

    public void setColumn(int n, Object[] objectArray, ComponentAttributeAssociation componentAttributeAssociation) {
        this.m_columnData[n] = objectArray;
        if (objectArray.length == 0) {
            return;
        }
        if (this.m_columnData[n][0] instanceof NodeDescriptor) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            this.m_rowCount = objectArray.length;
            for (int i = 0; i < this.m_columnCount; ++i) {
                Object[] objectArray2 = this.getColumn(i);
                if (objectArray2 == null || objectArray2.length <= this.m_rowCount) continue;
                this.m_rowCount = this.m_columnData[i].length;
            }
            PanelTreeTableNode panelTreeTableNode = new PanelTreeTableNode();
            for (int i = 0; i < this.m_columnData[n].length; ++i) {
                PanelTreeTableNode panelTreeTableNode2 = new PanelTreeTableNode((NodeDescriptor)this.m_columnData[n][i], componentAttributeAssociation);
                panelTreeTableNode.insert(panelTreeTableNode2, i);
            }
            panelTreeTableNode.setIsLoaded(true);
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(panelTreeTableNode);
            this.m_jTree.setModel(defaultTreeModel);
            this.m_treeModel = defaultTreeModel;
            this.m_treeModel.addTreeModelListener(this);
            this.m_jTree.setRootVisible(false);
            if (this.m_columnData[n].length == 1 && ((NodeDescriptor)this.m_columnData[n][0]).isLeaf()) {
                this.m_jTree.setShowsRootHandles(false);
            }
            if ((defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_jTree.getModel().getRoot()).getUserObject() == null) {
                defaultMutableTreeNode = defaultMutableTreeNode.getNextNode();
            }
            while (defaultMutableTreeNode != null) {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                if (((NodeDescriptor)defaultMutableTreeNode.getUserObject()).isExpandRequested()) {
                    this.m_jTree.expandRow(this.m_jTree.getRowForPath(new TreePath(defaultMutableTreeNode.getPath())));
                    defaultMutableTreeNode2 = defaultMutableTreeNode;
                    defaultMutableTreeNode = defaultMutableTreeNode.getNextNode();
                    continue;
                }
                ((PanelTreeTableNode)defaultMutableTreeNode).setDelayLoading(true);
                defaultMutableTreeNode2 = defaultMutableTreeNode;
                defaultMutableTreeNode = defaultMutableTreeNode.getNextNode();
                ((PanelTreeTableNode)defaultMutableTreeNode2).setDelayLoading(false);
            }
            this.fireTableDataChanged();
        }
    }

    public void setColumn(int n, Object[] objectArray) {
        this.m_columnData[n] = objectArray;
        if (objectArray.length == 0) {
            return;
        }
        this.m_rowCount = objectArray.length;
        for (int i = 0; i < this.m_columnCount; ++i) {
            Object[] objectArray2 = this.getColumn(i);
            if (objectArray2 == null || objectArray2.length <= this.m_rowCount) continue;
            this.m_rowCount = this.m_columnData[i].length;
        }
        if (objectArray[0] instanceof DefaultMutableTreeNode) {
            this.buildTree(objectArray);
        }
        this.fireTableDataChanged();
    }

    private void buildTree(Object[] objectArray) {
    }

    public Object getValueAt(int n, int n2) {
        TreePath treePath = this.m_jTree.getPathForRow(n);
        if (treePath == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object == null) {
            return null;
        }
        if (object instanceof NodeDescriptor) {
            if (n2 == 0) {
                return object;
            }
            for (int i = 0; i < this.m_columnData[0].length; ++i) {
                if ((NodeDescriptor)this.m_columnData[0][i] != object) continue;
                if (i < this.m_columnData[n2].length) {
                    return this.m_columnData[n2][i];
                }
                return null;
            }
            return null;
        }
        if (n2 == 0) {
            return defaultMutableTreeNode;
        }
        for (int i = 0; i < this.m_columnData[0].length; ++i) {
            if (this.m_columnData[0][i] != defaultMutableTreeNode) continue;
            if (i < this.m_columnData[n2].length) {
                return this.m_columnData[n2][i];
            }
            return null;
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = true;
        if (n2 == 0) {
            bl = true;
        } else if (n2 < this.m_tableColumns.size()) {
            Boolean bl2 = (Boolean)this.m_cellStatusDictionary.get(this.makeKey(n, n2));
            bl = bl2 != null ? bl2 : ((ColumnDescriptor)this.m_tableColumns.elementAt((int)n2)).m_editable;
        }
        return bl;
    }

    public void setCellEditable(boolean bl, int n, int n2) {
        this.m_cellStatusDictionary.put(this.makeKey(n, n2), new Boolean(bl));
    }

    public void setValueAt(Object object, int n, int n2) {
        Object[] objectArray = this.m_columnData[n2];
        if (n < objectArray.length) {
            ((ItemDescriptor)objectArray[n]).setTitle(object.toString());
            this.fireTableCellUpdated(n, n2);
        } else {
            Object[] objectArray2 = new Object[]{new Integer(n), new Integer(n2)};
            MessageLog.traceErr(SystemResourceFinder.format("noColumnData", objectArray2));
        }
    }

    public void addRow(Vector vector) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        this.addRow(vector, defaultMutableTreeNode);
    }

    public void addRow(Vector vector, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (vector == null || vector.size() == this.m_tableColumns.size()) {
            for (int i = 0; i < this.m_tableColumns.size(); ++i) {
                Object[] objectArray = new Object[this.m_rowCount + 1];
                if (this.m_rowCount > 0) {
                    System.arraycopy(this.m_columnData[i], 0, objectArray, 0, this.m_columnData[i].length);
                }
                objectArray[this.m_rowCount] = vector != null ? vector.elementAt(i) : null;
                this.m_columnData[i] = objectArray;
            }
            ++this.m_rowCount;
            if (vector != null && vector.elementAt(0) instanceof DefaultMutableTreeNode) {
                Serializable serializable;
                if (this.m_treeModel == null) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
                    serializable = new DefaultTreeModel(defaultMutableTreeNode2);
                    this.m_jTree.setModel((TreeModel)((Object)serializable));
                    this.m_treeModel = serializable;
                    this.m_treeModel.addTreeModelListener(this);
                    this.m_jTree.setRootVisible(false);
                }
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)vector.elementAt(0);
                if (defaultMutableTreeNode == null) {
                    serializable = (DefaultMutableTreeNode)this.m_jTree.getModel().getRoot();
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode3, (MutableTreeNode)((Object)serializable), ((DefaultMutableTreeNode)serializable).getChildCount());
                } else {
                    this.m_treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                }
            }
            this.fireTableDataChanged();
        }
    }

    public void insertNodeRow(Vector vector, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        if (this.m_treeModel == null && defaultMutableTreeNode != null) {
            return;
        }
        if (!(vector.elementAt(0) instanceof DefaultMutableTreeNode)) {
            return;
        }
        for (int i = 0; i < this.m_columnData[0].length; ++i) {
            if (this.m_columnData[0][i] != defaultMutableTreeNode) continue;
        }
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_jTree.getModel().getRoot();
        }
    }

    public void insertRow(int n, Vector vector) {
        if (vector == null || vector.size() == this.m_tableColumns.size()) {
            for (int i = 0; i < this.m_tableColumns.size(); ++i) {
                Object[] objectArray = new Object[this.m_rowCount + 1];
                if (this.m_rowCount > 0 && n > 0) {
                    System.arraycopy(this.m_columnData[i], 0, objectArray, 0, n);
                }
                Object object = objectArray[n] = vector != null ? (Object)vector.elementAt(i) : null;
                if (this.m_columnData[i].length >= n) {
                    System.arraycopy(this.m_columnData[i], n, objectArray, n + 1, this.m_columnData[i].length - n);
                }
                this.m_columnData[i] = objectArray;
            }
            ++this.m_rowCount;
            this.fireTableRowsInserted(n, n);
        }
    }

    public void setRows(Vector[] vectorArray) {
        if (vectorArray == null || vectorArray.length == 0) {
            return;
        }
        this.m_columnData = new Object[this.m_columnCount][];
        if (this.m_rowCount > 0) {
            this.fireTableRowsDeleted(0, this.m_rowCount - 1);
        }
        for (int i = 0; i < this.m_columnCount; ++i) {
            Object[] objectArray = new Object[vectorArray.length];
            for (int j = 0; j < vectorArray.length; ++j) {
                if (vectorArray[j].size() != this.m_columnCount) continue;
                objectArray[j] = vectorArray[j].elementAt(i);
            }
            this.setColumn(i, objectArray);
        }
        this.m_rowCount = vectorArray.length;
        this.fireTableRowsInserted(0, vectorArray.length - 1);
    }

    public Vector[] getRows() {
        Vector[] vectorArray = new Vector[this.m_rowCount];
        for (int i = 0; i < this.m_rowCount; ++i) {
            Vector<Object> vector = new Vector<Object>(this.m_columnCount);
            for (int j = 0; j < this.m_columnCount; ++j) {
                vector.addElement(this.getValueAt(i, j));
            }
            vectorArray[i] = vector;
        }
        return vectorArray;
    }

    public void removeRow(int n) {
        if (n < this.m_rowCount) {
            Object[][] objectArrayArray = new Object[this.m_columnCount][];
            for (int i = 0; i < this.m_columnCount; ++i) {
                Object[] objectArray = this.m_columnData[i];
                ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[this.m_rowCount - 1];
                int n2 = 0;
                for (int j = 0; j < objectArray.length; ++j) {
                    if (j == n) continue;
                    itemDescriptorArray[n2++] = objectArray[j];
                }
                objectArrayArray[i] = itemDescriptorArray;
            }
            this.m_columnData = objectArrayArray;
            --this.m_rowCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(n + ">=" + this.m_rowCount);
        }
        this.fireTableRowsDeleted(n, n);
    }

    public void removeRows(int[] nArray) {
        if (nArray.length > 0) {
            int n;
            Object[][] objectArrayArray = new Object[this.m_columnCount][];
            for (n = 0; n < this.m_columnCount; ++n) {
                Object[] objectArray = this.m_columnData[n];
                Object[] objectArray2 = new Object[this.m_rowCount - nArray.length];
                int n2 = 0;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.isRowInArray(i, nArray)) continue;
                    objectArray2[n2++] = objectArray[i];
                }
                objectArrayArray[n] = objectArray2;
            }
            this.m_columnData = objectArrayArray;
            this.m_rowCount -= nArray.length;
            for (n = 0; n < nArray.length; ++n) {
                this.fireTableRowsDeleted(nArray[n], nArray[n]);
            }
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        PanelTreeTableNode panelTreeTableNode;
        Object object;
        if (treeExpansionEvent.getPath().getLastPathComponent() instanceof PanelTreeTableNode && (object = (panelTreeTableNode = (PanelTreeTableNode)treeExpansionEvent.getPath().getLastPathComponent()).getUserObject()) != null && object instanceof NodeDescriptor && !panelTreeTableNode.isLoaded() && !panelTreeTableNode.isDelayLoading()) {
            panelTreeTableNode.loadChildren(this.m_treeModel);
        }
        this.fireTableDataChanged();
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.fireTableDataChanged();
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        PanelTreeTableNode panelTreeTableNode;
        Object object;
        if (treeExpansionEvent.getPath().getLastPathComponent() instanceof PanelTreeTableNode && (object = (panelTreeTableNode = (PanelTreeTableNode)treeExpansionEvent.getPath().getLastPathComponent()).getUserObject()) != null && object instanceof NodeDescriptor && !panelTreeTableNode.isLoaded() && !panelTreeTableNode.isDelayLoading()) {
            panelTreeTableNode.loadChildren(this.m_treeModel);
        }
        this.fireTableDataChanged();
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        this.fireTableDataChanged();
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().getLastPathComponent() instanceof PanelTreeTableNode) {
            this.updateTreeColumnData();
            this.reloadSecondaryColumns();
        } else {
            this.fireTableDataChanged();
        }
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().getLastPathComponent() instanceof PanelTreeTableNode) {
            this.updateTreeColumnData();
            this.reloadSecondaryColumns();
        } else {
            this.fireTableDataChanged();
        }
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().getLastPathComponent() instanceof PanelTreeTableNode) {
            this.updateTreeColumnData();
            this.reloadSecondaryColumns();
        } else {
            this.fireTableDataChanged();
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().getLastPathComponent() instanceof PanelTreeTableNode) {
            this.updateTreeColumnData();
            this.reloadSecondaryColumns();
        } else {
            this.fireTableDataChanged();
        }
    }

    public void treeNodesChanged() {
        this.m_treeModel.nodeStructureChanged((TreeNode)this.m_treeModel.getRoot());
        this.updateTreeColumnData();
        this.reloadSecondaryColumns();
    }

    private void updateTreeColumnData() {
        int n;
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_jTree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.preorderEnumeration();
        Vector<Object[]> vector = new Vector<Object[]>();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            try {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                continue;
            }
            object = (NodeDescriptor)defaultMutableTreeNode2.getUserObject();
            if (object == null) continue;
            vector.addElement((Object[])object);
        }
        object = new Object[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            object[n] = vector.elementAt(n);
        }
        this.m_columnData[0] = object;
        this.m_rowCount = ((Object[])object).length;
        for (n = 0; n < this.m_columnCount; ++n) {
            Object[] objectArray = this.getColumn(n);
            if (objectArray == null || objectArray.length <= this.m_rowCount) continue;
            this.m_rowCount = this.m_columnData[n].length;
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadSecondaryColumns() {
        for (int i = 1; i < this.m_columnCount; ++i) {
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)this.m_tableColumns.elementAt(i);
            ComponentAttributeAssociation componentAttributeAssociation = (ComponentAttributeAssociation)this.m_caa.m_tableColumns.elementAt(i);
            Object[] objectArray = new ItemDescriptor[]{null};
            if (columnDescriptor.m_itemDescriptors != null || componentAttributeAssociation.m_listGettor == null) continue;
            Method method = componentAttributeAssociation.m_listGettor;
            try {
                objectArray = (ItemDescriptor[])componentAttributeAssociation.m_listGettor.invoke((Object)componentAttributeAssociation.m_dataBean, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                Object[] objectArray2 = new Object[]{method};
                MessageLog.logError(SystemResourceFinder.format("indirectExceptionThrown", objectArray2));
                MessageLog.printStackTrace(throwable);
            }
            catch (Exception exception) {
                MessageLog.printStackTrace(exception);
            }
            finally {
                method = null;
            }
            if (objectArray == null) continue;
            this.setColumn(i, objectArray);
        }
    }

    private boolean isRowInArray(int n, int[] nArray) {
        if (nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                return true;
            }
        }
        return false;
    }

    private String makeKey(int n, int n2) {
        String string = new Integer(n).toString();
        String string2 = new Integer(n2).toString();
        return string.concat(string2);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

