/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;

class PanelFocusManager
extends ContainerOrderFocusTraversalPolicy {
    static final boolean m_debug = false;

    PanelFocusManager() {
    }

    public Component getDefaultComponent(Container container) {
        Component component = this.getFirstComponent(container);
        PanelFocusManager.debug("getDefaultComponent -- focusCycleRoot [" + container + "]");
        PanelFocusManager.debug("getDefaultComponent -- returning [" + PanelFocusManager.getMeaningfulText(component) + "] [" + component + "]");
        return component;
    }

    public Component getFirstComponent(Container container) {
        Component component = super.getFirstComponent(container);
        PanelFocusManager.debug("getFirstComponent -- focusCycleRoot [" + container + "]");
        PanelFocusManager.debug("getFirstComponent -- returning [" + PanelFocusManager.getMeaningfulText(component) + "] [" + component + "]");
        component = this.comboBoxWorkaround(component);
        return component;
    }

    public Component getLastComponent(Container container) {
        Component component = super.getLastComponent(container);
        PanelFocusManager.debug("getLastComponent -- focusCycleRoot [" + container + "]");
        PanelFocusManager.debug("getLastComponent -- returning [" + PanelFocusManager.getMeaningfulText(component) + "] [" + component + "]");
        component = this.comboBoxWorkaround(component);
        return component;
    }

    public Component getComponentAfter(Container container, Component component) {
        Component component2 = super.getComponentAfter(container, component);
        PanelFocusManager.debug("getComponentAfter -- focusCycleRoot [" + container + "]");
        PanelFocusManager.debug("getComponentAfter[" + PanelFocusManager.getMeaningfulText(component) + "] is [" + PanelFocusManager.getMeaningfulText(component2) + "] [" + component2 + "]");
        component2 = this.comboBoxWorkaround(component2);
        return component2;
    }

    public Component getComponentBefore(Container container, Component component) {
        Component component2 = super.getComponentBefore(container, component);
        if (component2 == container) {
            component2 = this.getLastComponent(container);
            PanelFocusManager.debug("getComponentAfter -- Getting Last to avoid focusCycleRoot");
        } else {
            component2 = this.comboBoxWorkaround(component2);
        }
        PanelFocusManager.debug("getComponentBefore -- focusCycleRoot [" + container + "]");
        PanelFocusManager.debug("getComponentBefore -- returning [" + PanelFocusManager.getMeaningfulText(component2) + "] [" + component2 + "]");
        return component2;
    }

    private Component comboBoxWorkaround(Component component) {
        Component component2 = component;
        if (component2 instanceof JComboBox && component2.isEnabled() && ((JComboBox)component2).isEditable()) {
            component2 = ((JComboBox)component2).getEditor().getEditorComponent();
            PanelFocusManager.debug("comboBoxWorkaround -- special code for JComboBox");
        }
        return component2;
    }

    public boolean accept(Component component) {
        boolean bl = super.accept(component);
        if (bl) {
            if (component instanceof JTextArea) {
                if (!((JTextArea)component).isEditable()) {
                    bl = false;
                    PanelFocusManager.debug("accept NOT Accepting due to non editable JTextArea test.");
                }
            } else if (component instanceof JPanel) {
                bl = false;
                PanelFocusManager.debug("accept NOT Accepting due to JPanel test.");
            } else if (component instanceof JLabel) {
                bl = false;
                PanelFocusManager.debug("accept NOT Accepting due to JLabel test.");
            } else if (component instanceof JFrame) {
                bl = false;
                PanelFocusManager.debug("accept NOT Accepting due to JFrame test.");
            } else if (component instanceof JDialog) {
                bl = false;
                PanelFocusManager.debug("accept NOT Accepting due to JDialog test.");
            } else if (component instanceof JRootPane) {
                bl = false;
                PanelFocusManager.debug("accept NOT Accepting due to JRootPane test.");
            } else if (component instanceof JLayeredPane) {
                bl = false;
                PanelFocusManager.debug("accept NOT Accepting due to JLayeredPane test.");
            } else if (component instanceof JViewport) {
                bl = false;
                PanelFocusManager.debug("accept NOT Accepting due to JViewport test.");
            } else if (component instanceof JScrollPane) {
                bl = false;
                PanelFocusManager.debug("accept NOT Accepting due to JScrollPane test.");
            }
        }
        PanelFocusManager.debug("accept [" + bl + "] for component[" + PanelFocusManager.getMeaningfulText(component) + "][" + component + "]");
        return bl;
    }

    private static void debug(String string) {
    }

    private static String getMeaningfulText(Component component) {
        String string = null;
        return string;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

