/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.ResourceLoader;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.java.ConditionalBlock;
import com.ibm.as400.ui.framework.java.MessagePump;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.framework.java.UIFramework;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class MessageBoxDialog {
    private static boolean m_debug = false;
    private static ResourceLoader m_loader = new ResourceLoader();
    private static Font m_font = UIManager.getFont("Label.font");
    private static JDialog m_dialog;
    private static int m_linesBeforeScroll;
    public static final int ERROR = 0;
    public static final int INFORMATION = 1;
    public static final int WARNING = 2;
    public static final int QUESTION = 3;
    public static final int PLAIN = -1;

    public static Object showMessageDialog(Component component, String string, String string2, int n) {
        Object[] objectArray = new Object[]{string};
        return MessageBoxDialog.showMessageDialog(component, objectArray, string2, n, true, null, null);
    }

    public static Object showMessageDialog(Component component, String string, String string2, int n, boolean bl) {
        Object[] objectArray = new Object[]{string};
        return MessageBoxDialog.showMessageDialog(component, objectArray, string2, n, bl, null, null);
    }

    public static Object showMessageDialog(Component component, String string, String string2, int n, Object[] objectArray, Object object) {
        Object[] objectArray2 = new Object[]{string};
        return MessageBoxDialog.showMessageDialog(component, objectArray2, string2, n, true, objectArray, object);
    }

    public static Object showMessageDialog(Component component, String string, String string2, int n, boolean bl, Object[] objectArray, Object object) {
        Object[] objectArray2 = new Object[]{string};
        return MessageBoxDialog.showMessageDialog(component, objectArray2, string2, n, bl, objectArray, object);
    }

    public static Object showMessageDialog(Component component, Object[] objectArray, String string, int n, boolean bl, Object[] objectArray2, Object object) {
        if (SwingUtilities.isEventDispatchThread()) {
            return MessageBoxDialog.showMessageDialog0(component, objectArray, string, n, bl, objectArray2, object);
        }
        class RunIt
        extends Thread {
            Component m_parent;
            Object[] m_message;
            String m_title;
            int m_type;
            boolean m_showIcon;
            Object[] m_options;
            Object m_initial;
            Object m_result;

            RunIt(Component component, Object[] objectArray, String string, int n, boolean bl, Object[] objectArray2, Object object) {
                this.m_parent = component;
                this.m_message = objectArray;
                this.m_title = string;
                this.m_type = n;
                this.m_showIcon = bl;
                this.m_options = objectArray2;
                this.m_initial = object;
            }

            public void run() {
                this.m_result = MessageBoxDialog.showMessageDialog0(this.m_parent, this.m_message, this.m_title, this.m_type, this.m_showIcon, this.m_options, this.m_initial);
            }
        }
        RunIt runIt = new RunIt(component, objectArray, string, n, bl, objectArray2, object);
        try {
            SwingUtilities.invokeAndWait(runIt);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (RuntimeException)invocationTargetException.getTargetException();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return runIt.m_result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Object showMessageDialog0(Component component, Object[] objectArray, String string, int n, boolean bl, Object[] objectArray2, Object object) {
        Window window;
        int n2;
        Object object2;
        Component component2;
        Object object3;
        int n3;
        Frame[] frameArray;
        Serializable serializable;
        Serializable serializable2;
        Object object4;
        Object object5;
        Vector vector = null;
        if (objectArray != null && objectArray.length == 1 && objectArray[0] instanceof String) {
            vector = MessageBoxDialog.splitString(objectArray[0].toString(), 40);
        }
        if (vector != null && vector.size() > 1) {
            int n4;
            int n5 = 0;
            object5 = "";
            object4 = "";
            serializable2 = new JTextArea(){

                public boolean isFocusTraversable() {
                    return false;
                }
            };
            serializable = ((JComponent)serializable2).getFontMetrics(m_font);
            for (n4 = 0; n4 < vector.size(); ++n4) {
                frameArray = (Frame[])vector.elementAt(n4);
                int n6 = ((FontMetrics)serializable).stringWidth((String)frameArray);
                if (n6 > n5) {
                    object4 = frameArray;
                    n5 = n6;
                }
                object5 = object5 + (String)frameArray + "\n";
            }
            n4 = vector.size() > m_linesBeforeScroll ? m_linesBeforeScroll : vector.size();
            n3 = n5 / ((FontMetrics)serializable).charWidth('m') + 1;
            ((JTextArea)serializable2).setRows(n4);
            ((JTextArea)serializable2).setColumns(n3);
            ((JTextArea)serializable2).setFont(m_font);
            ((JTextArea)serializable2).setLineWrap(true);
            ((JTextArea)serializable2).setWrapStyleWord(true);
            ((JTextComponent)serializable2).setEditable(false);
            ((JTextComponent)serializable2).setText((String)object5);
            ((JComponent)serializable2).setBackground(UIManager.getColor("OptionPane.background"));
            object3 = null;
            objectArray = new Object[1];
            if (vector.size() > m_linesBeforeScroll) {
                object3 = new JScrollPane((Component)serializable2);
                ((JComponent)object3).setBorder(null);
                objectArray[0] = object3;
            } else {
                objectArray[0] = serializable2;
            }
        }
        if (objectArray2 == null) {
            objectArray2 = new Object[]{m_loader.getString("ok")};
        }
        if (object == null) {
            object = objectArray2[0];
        }
        if (component != null) {
            while (!(component == null || component instanceof JFrame || component instanceof JDialog || component instanceof Frame)) {
                component = component.getParent();
            }
        }
        if ((component2 = component) == null) {
            component2 = new JFrame();
            object5 = null;
            try {
                object5 = SystemResourceFinder.getImageResource("com/ibm/as400/ui/framework/16message2.gif");
            }
            catch (MissingResourceException missingResourceException) {
                System.out.println(missingResourceException);
            }
            if (object5 != null) {
                ((JFrame)component2).setIconImage(((ImageIcon)object5).getImage());
            }
        }
        if (component != null) {
            if (component instanceof Window) {
                ((Window)component).toFront();
            }
            component.setEnabled(false);
        }
        MessageBoxDialog.listAllWindows("Before disabling");
        object5 = new Vector(5, 5);
        object4 = new Vector(5, 5);
        serializable2 = new Vector(5, 5);
        serializable = new Vector(5, 5);
        frameArray = Frame.getFrames();
        ArrayList arrayList = new ArrayList();
        Window[] windowArray = new Window[]{};
        for (n3 = 0; n3 < frameArray.length; ++n3) {
            if (frameArray[n3].isEnabled()) {
                ((Vector)object5).add(frameArray[n3]);
                object3 = new ActivationListener();
                ((Vector)object4).add(object3);
                frameArray[n3].addWindowListener((WindowListener)object3);
                frameArray[n3].setEnabled(false);
            } else {
                ((Vector)serializable2).add(frameArray[n3]);
                object3 = new ActivationListener();
                ((Vector)serializable).add(object3);
                frameArray[n3].addWindowListener((WindowListener)object3);
            }
            arrayList.clear();
            arrayList = MessageBoxDialog.getAllOwnedWindows(frameArray[n3], arrayList);
            windowArray = arrayList.toArray(windowArray);
            for (int i = 0; i < windowArray.length && windowArray[i] != null; ++i) {
                if (!windowArray[i].isEnabled()) continue;
                ((Vector)object5).add(windowArray[i]);
                object2 = new ActivationListener();
                ((Vector)object4).add(object2);
                windowArray[i].addWindowListener((WindowListener)object2);
                windowArray[i].setEnabled(false);
            }
        }
        JOptionPane jOptionPane = new JOptionPane();
        jOptionPane.setMessage(objectArray);
        jOptionPane.setMessageType(n);
        jOptionPane.setOptions(objectArray2);
        jOptionPane.setInitialValue(object);
        m_dialog = jOptionPane.createDialog(component2, string);
        if (!bl) {
            m_dialog.setResizable(false);
        }
        m_dialog.setModal(false);
        UIFramework.notifyGlobalRegisteredListeners(m_dialog, true);
        object3 = null;
        if (UIFramework.isApplet()) {
            m_dialog.setModal(true);
            m_dialog.setVisible(true);
        } else {
            m_dialog.setVisible(true);
            if (SwingUtilities.isEventDispatchThread()) {
                object2 = new MessagePump(PanelManager.getRealSystemEventQueue());
                ((MessagePump)object2).pumpEvents(new ConditionalBlock(){

                    public boolean evaluate() {
                        boolean bl = m_dialog == null ? false : m_dialog.isVisible();
                        return bl;
                    }
                });
            } else {
                object2 = m_dialog.getTreeLock();
                synchronized (object2) {
                    while (m_dialog.isVisible()) {
                        try {
                            m_dialog.getTreeLock().wait(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }
        UIFramework.notifyGlobalRegisteredListeners(m_dialog, false);
        for (n2 = 0; n2 < ((Vector)object5).size(); ++n2) {
            window = (Window)((Vector)object5).elementAt(n2);
            window.setEnabled(true);
            ActivationListener activationListener = (ActivationListener)((Vector)object4).elementAt(n2);
            window.removeWindowListener(activationListener);
        }
        for (n2 = 0; n2 < ((Vector)serializable2).size(); ++n2) {
            window = (Window)((Vector)serializable2).elementAt(n2);
            window.removeWindowListener((ActivationListener)((Vector)serializable).elementAt(n2));
        }
        m_dialog.dispose();
        MessageBoxDialog.dispose();
        m_dialog = null;
        if (component2 instanceof JFrame && !component2.equals(component)) {
            ((JFrame)component2).dispose();
        }
        if (component != null) {
            component.setEnabled(true);
            component.requestFocus();
        }
        object3 = jOptionPane == null ? new Integer(-1) : jOptionPane.getValue();
        return object3;
    }

    public static synchronized void dispose() {
        if (m_dialog != null) {
            m_dialog.dispose();
        }
        m_dialog = null;
    }

    public static Vector splitString(String string, int n) {
        JLabel jLabel = new JLabel();
        FontMetrics fontMetrics = jLabel.getFontMetrics(m_font);
        return MessageBoxDialog.splitString(string, n, fontMetrics);
    }

    public static Vector splitString(String string, int n, FontMetrics fontMetrics) {
        int n2;
        Locale locale = Locale.getDefault();
        int n3 = n * fontMetrics.getMaxAdvance() * 1 / 2;
        BreakIterator breakIterator = null;
        int n4 = 0;
        Vector<String> vector = new Vector<String>();
        int n5 = 0;
        while (true) {
            if ((n2 = string.indexOf(10, n5)) < 0) break;
            vector.addElement(string.substring(n5, n2));
            n5 = n2 + 1;
        }
        vector.addElement(string.substring(n5));
        n2 = vector.size();
        for (n5 = 0; n5 < n2; ++n5) {
            String string2 = (String)vector.elementAt(n5);
            char[] cArray = string2.toCharArray();
            int n6 = fontMetrics.charsWidth(cArray, 0, cArray.length);
            if (n6 <= n3) continue;
            if (breakIterator == null) {
                breakIterator = BreakIterator.getLineInstance(locale);
            }
            breakIterator.setText(string2);
            int n7 = cArray.length * n3 / n6;
            if (n7 > cArray.length || n7 < 0) {
                System.out.println("In splitString: this should not happen");
                continue;
            }
            int n8 = breakIterator.following(n7);
            if (n8 == -1) {
                n8 = breakIterator.last();
            }
            if (n8 == -1) continue;
            n7 = n8;
            boolean bl = false;
            while ((n6 = fontMetrics.charsWidth(cArray, 0, n8)) > n3) {
                bl = true;
                n8 = breakIterator.previous();
                if (n8 == -1 || n8 == 0) break;
                n7 = n8;
            }
            while (!bl && (n8 = breakIterator.next()) != -1 && fontMetrics.charsWidth(cArray, 0, n8) <= n3) {
                n7 = n8;
            }
            String string3 = string2.substring(0, n7);
            String string4 = string2.substring(n7);
            vector.setElementAt(string3, n5);
            vector.insertElementAt(string4, n5 + 1);
            ++n2;
        }
        n4 = vector.size();
        return vector;
    }

    private MessageBoxDialog() {
    }

    private static ArrayList getAllOwnedWindows(Window window, ArrayList arrayList) {
        Window[] windowArray = window.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            arrayList.add(windowArray[i]);
            MessageBoxDialog.getAllOwnedWindows(windowArray[i], arrayList);
        }
        return arrayList;
    }

    private static void listAllOwnedWindows(Window window, String string) {
        if (m_debug) {
            Window[] windowArray = window.getOwnedWindows();
            for (int i = 0; i < windowArray.length; ++i) {
                String string2 = windowArray[i] instanceof Dialog ? ((Dialog)windowArray[i]).getTitle() : "";
                MessageBoxDialog.debug(string + "Window " + i + ":  Enabled[" + windowArray[i].isEnabled() + "] Title[" + string2 + "] " + windowArray[i]);
                MessageBoxDialog.listAllOwnedWindows(windowArray[i], string + "    ");
            }
        }
    }

    public static void listAllWindows(String string) {
        if (m_debug) {
            Frame[] frameArray = Frame.getFrames();
            MessageBoxDialog.debug("begin: " + string + " Frame Count: " + frameArray.length);
            for (int i = 0; i < frameArray.length; ++i) {
                MessageBoxDialog.debug("  Frame " + i + " Enabled[" + frameArray[i].isEnabled() + "] Title[" + frameArray[i].getTitle() + "] " + frameArray[i]);
                MessageBoxDialog.listAllOwnedWindows(frameArray[i], "    ");
            }
            MessageBoxDialog.debug("end: " + string);
            MessageBoxDialog.debug("===========================");
        }
    }

    private static void debug(String string) {
        if (m_debug) {
            System.out.println("MessageBoxDialog: " + string);
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }

    static {
        m_linesBeforeScroll = 20;
        m_loader.setResourceName("com.ibm.as400.ui.framework.FRMRI");
    }

    private static class ActivationListener
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            if (m_dialog != null) {
                m_dialog.toFront();
                m_dialog.requestFocus();
            }
        }
    }
}

