/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.UIFramework;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import javax.help.BadIDException;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.swing.JFrame;

public class HelpViewer {
    private HelpSet m_hs = null;
    private String defaultHS = "com/ibm/as400/ui/framework/java/default.hs";
    private static Window m_window = null;
    private boolean m_helpSetSet = false;
    private HelpResource m_hr = null;
    private URL m_url = null;
    private String m_home = null;
    public static HelpBroker OpNavHelpBroker = null;
    private String m_help = SystemResourceFinder.format("help");
    private String tempFile;
    private static int tempFileCount = 1;
    private String tempFileName = "hlptmp";
    private String tempDir = null;
    private String curDir = null;
    private String m_osname = "";
    private String separator = File.separator;
    private String m_sJarFileName = "";
    private boolean m_entryTrace = false;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Syntax: java HelpViewer url  or  java HelpViewer document or java HelpViewer ID HelpSet");
            System.out.println("If the input is a valid URL, it is utilized as a URL.");
            System.out.println("Example URL:  java com.ibm.as400.ui.framework.java.HelpViewer \"file:///g:/myhtml/mypage.html\"");
            System.out.println("Example file : java com.ibm.as400.ui.framework.java.HelpViewer \"index.html\"");
            System.out.println("Example file : java com.ibm.as400.ui.framework.java.HelpViewer \"myID\" \"myHelpset.hs\"");
            System.exit(1);
        }
        HelpViewer helpViewer = null;
        if (stringArray.length == 1) {
            helpViewer = new HelpViewer(stringArray[0]);
            helpViewer.showPage(stringArray[0]);
        }
        if (stringArray.length == 2) {
            helpViewer = new HelpViewer();
            helpViewer.showPage(stringArray[0], stringArray[1]);
        }
        Window window = null;
        JFrame jFrame = null;
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            Component component;
            if (!(frameArray[i] instanceof JFrame) || (jFrame = (JFrame)frameArray[i]).getContentPane().getComponentCount() == 0 || (component = jFrame.getContentPane().getComponent(0)) == null || !(component instanceof JHelp)) continue;
            window = jFrame;
        }
        if (window != null) {
            window.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
    }

    public HelpViewer() {
    }

    public HelpViewer(URL uRL) {
        this.m_url = uRL;
        this.HelpViewerInitOldHelp(this.JarFileAnchor(uRL));
    }

    public HelpViewer(String string) {
        HelpResource helpResource = this.JarFileAnchor(string);
        try {
            this.m_url = new URL(helpResource.hrFileURL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.HelpViewerInitOldHelp(this.JarFileAnchor(string));
    }

    public HelpViewer(URL uRL, Window window) {
        this.m_url = uRL;
        this.HelpViewerInitOldHelp(this.JarFileAnchor(uRL));
        if (window != null) {
            this.setParentWindow(window);
        }
    }

    private void HelpViewerInitOldHelp(HelpResource helpResource) {
        this.m_home = helpResource.hrFileURL;
    }

    public void showPage(String string) {
        if (this.CheckForHelpSet(this.m_hr.hrHelpSet) && !this.m_hr.hrHelpSet.equals(this.defaultHS)) {
            try {
                this.showPage(this.helpID(string), this.m_hr.hrHelpSet);
            }
            catch (BadIDException badIDException) {
                this.showPage(this.newStyleHelpID(string), this.m_hr.hrHelpSet);
            }
            return;
        }
        URL uRL = null;
        int n = string.indexOf("!");
        int n2 = string.indexOf("jar:");
        this.debug("In ShowPage: strFile is " + string);
        if (n2 != -1) {
            n += 2;
            if (string.endsWith(".html")) {
                string = string.substring(n, string.indexOf(".html"));
            }
        }
        HelpResource helpResource = this.JarFileAnchor(string);
        try {
            uRL = new URL(helpResource.hrFileURL + helpResource.hrAnchor);
        }
        catch (MalformedURLException malformedURLException) {
            this.debug("showPage: Couldn't form file URL");
        }
        if (uRL != null && this.createHelpSet(this.m_hr.hrHelpSet)) {
            if (OpNavHelpBroker == null) {
                OpNavHelpBroker = this.m_hs.createHelpBroker();
                if (m_window != null) {
                    ((DefaultHelpBroker)OpNavHelpBroker).setActivationWindow(m_window);
                }
                OpNavHelpBroker.setDisplayed(true);
                OpNavHelpBroker.setViewDisplayed(true);
                OpNavHelpBroker.setCurrentURL(uRL);
            } else {
                if (m_window != null) {
                    ((DefaultHelpBroker)OpNavHelpBroker).setActivationWindow(m_window);
                }
                if (!this.CheckIfHelpSetMatches()) {
                    OpNavHelpBroker = null;
                    OpNavHelpBroker = this.m_hs.createHelpBroker();
                    if (m_window != null) {
                        ((DefaultHelpBroker)OpNavHelpBroker).setActivationWindow(m_window);
                    }
                    OpNavHelpBroker.setDisplayed(true);
                    OpNavHelpBroker.setViewDisplayed(true);
                    OpNavHelpBroker.setCurrentURL(uRL);
                } else {
                    OpNavHelpBroker.setDisplayed(true);
                    OpNavHelpBroker.setViewDisplayed(true);
                    OpNavHelpBroker.setCurrentURL(uRL);
                    return;
                }
            }
        }
    }

    public void showPage(URL uRL) {
        if (uRL != null && this.createHelpSet(this.m_hr.hrHelpSet)) {
            if (OpNavHelpBroker == null) {
                OpNavHelpBroker = this.m_hs.createHelpBroker();
                if (m_window != null) {
                    ((DefaultHelpBroker)OpNavHelpBroker).setActivationWindow(m_window);
                }
                OpNavHelpBroker.setDisplayed(true);
                OpNavHelpBroker.setViewDisplayed(true);
                OpNavHelpBroker.setCurrentURL(uRL);
            } else {
                if (m_window != null) {
                    ((DefaultHelpBroker)OpNavHelpBroker).setActivationWindow(m_window);
                }
                if (!this.CheckIfHelpSetMatches()) {
                    OpNavHelpBroker = null;
                    OpNavHelpBroker = this.m_hs.createHelpBroker();
                    if (m_window != null) {
                        ((DefaultHelpBroker)OpNavHelpBroker).setActivationWindow(m_window);
                    }
                    OpNavHelpBroker.setDisplayed(true);
                    OpNavHelpBroker.setViewDisplayed(true);
                    OpNavHelpBroker.setCurrentURL(uRL);
                } else {
                    OpNavHelpBroker.setDisplayed(true);
                    OpNavHelpBroker.setViewDisplayed(true);
                    OpNavHelpBroker.setCurrentURL(uRL);
                    return;
                }
            }
        }
    }

    public void showPage(String string, String string2) {
        this.debug("ShowPage: ID is " + string);
        if (this.createHelpSet(string2)) {
            if (OpNavHelpBroker == null) {
                OpNavHelpBroker = this.m_hs.createHelpBroker();
                if (m_window != null) {
                    ((DefaultHelpBroker)OpNavHelpBroker).setActivationWindow(m_window);
                }
                OpNavHelpBroker.setDisplayed(true);
                OpNavHelpBroker.setCurrentID(string);
            } else {
                if (m_window != null) {
                    ((DefaultHelpBroker)OpNavHelpBroker).setActivationWindow(m_window);
                }
                if (!this.CheckIfHelpSetMatches()) {
                    OpNavHelpBroker = null;
                    OpNavHelpBroker = this.m_hs.createHelpBroker();
                    if (m_window != null) {
                        ((DefaultHelpBroker)OpNavHelpBroker).setActivationWindow(m_window);
                    }
                    OpNavHelpBroker.setDisplayed(true);
                    OpNavHelpBroker.setCurrentID(string);
                } else {
                    OpNavHelpBroker.setDisplayed(true);
                    OpNavHelpBroker.setCurrentID(string);
                    return;
                }
            }
        }
    }

    public void showPage(URL uRL, String string) {
        if (this.createHelpSet(string)) {
            if (OpNavHelpBroker == null) {
                OpNavHelpBroker = this.m_hs.createHelpBroker();
                if (m_window != null) {
                    ((DefaultHelpBroker)OpNavHelpBroker).setActivationWindow(m_window);
                }
                OpNavHelpBroker.setDisplayed(true);
                OpNavHelpBroker.setCurrentURL(uRL);
            } else {
                if (m_window != null) {
                    ((DefaultHelpBroker)OpNavHelpBroker).setActivationWindow(m_window);
                }
                if (!this.CheckIfHelpSetMatches()) {
                    OpNavHelpBroker = null;
                    OpNavHelpBroker = this.m_hs.createHelpBroker();
                    OpNavHelpBroker.setDisplayed(true);
                    OpNavHelpBroker.setCurrentURL(uRL);
                } else {
                    OpNavHelpBroker.setDisplayed(true);
                    OpNavHelpBroker.setCurrentURL(uRL);
                    return;
                }
            }
        }
    }

    private boolean createHelpSet(String string) {
        boolean bl = true;
        if (this.m_hs != null) {
            return bl;
        }
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        try {
            URL uRL = HelpSet.findHelpSet((ClassLoader)classLoader, (String)string);
            this.debug("createHelpSet: URL is " + uRL);
            if (uRL == null) {
                this.debug("createHelpSet: URL is null");
            }
            this.m_hs = new HelpSet(classLoader, uRL);
        }
        catch (HelpSetException helpSetException) {
            this.debug("createHelpSet: HelpSetException!");
            if (helpSetException != null) {
                helpSetException.printStackTrace();
            }
            bl = false;
        }
        return bl;
    }

    public void showHTML(String string, String string2) {
        String string3;
        Integer n = new Integer(tempFileCount);
        String string4 = n.toString();
        this.curDir = System.getProperty("opnav.write.dir");
        this.tempDir = System.getProperty("opnav.temp.dir");
        if (this.curDir == null) {
            this.curDir = System.getProperty("user.dir");
        }
        if (this.tempDir == null) {
            this.tempDir = this.curDir + this.separator + "temp";
        }
        URL uRL = null;
        this.tempFile = this.tempDir + this.separator + this.tempFileName + string4 + ".html";
        this.debug("showHTML: " + this.tempFile);
        File file = new File(this.tempDir);
        if (!file.exists()) {
            file.mkdir();
        }
        if ((string3 = string.toLowerCase()).indexOf("charset") != -1 && string3.indexOf("utf8") == -1 && string3.indexOf("utf-8") == -1) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(this.tempFile));
                printWriter.println(string);
                printWriter.close();
                this.debug("showHTML: wrote temp file");
            }
            catch (IOException iOException) {
                this.debug("showHTML: IOException!");
            }
        } else if (string3.indexOf("charset") != -1 && (string3.indexOf("utf8") != -1 || string3.indexOf("utf-8") != -1)) {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.tempFile), "UTF8");
                outputStreamWriter.write(string, 0, string.length());
                outputStreamWriter.close();
                this.debug("showHTML: wrote temp file");
            }
            catch (IOException iOException) {
                this.debug("showHTML: IOException!");
            }
        } else if (string3.indexOf("charset") == -1) {
            int n2 = string3.indexOf("<head>");
            if (n2 == -1) {
                n2 = string3.indexOf("<html>");
                string = string.substring(0, n2 + 6) + "<head><META http-equiv=\"Content-Type\" CONTENT=\"text/html; charset=UTF8\"></head>" + string.substring(n2 + 6);
            } else {
                string = string.substring(0, n2 + 6) + "<META http-equiv=\"Content-Type\" CONTENT=\"text/html; charset=UTF8\">" + string.substring(n2 + 6);
            }
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.tempFile), "UTF8");
                outputStreamWriter.write(string, 0, string.length());
                outputStreamWriter.close();
                this.debug("showHTML: wrote temp file");
            }
            catch (IOException iOException) {
                this.debug("showHTML: IOException!");
            }
        }
        ++tempFileCount;
        try {
            uRL = new URL("file:///" + this.tempFile + "#" + string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.debug("showHTML: MalformedURLException!");
        }
        this.HelpViewerInitOldHelp(this.JarFileAnchor(uRL));
        this.showPage(uRL);
    }

    private HelpResource JarFileAnchor(String string) {
        String string2 = "";
        int n = string.indexOf("#");
        if (n >= 0) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        String string3 = "";
        if (string.startsWith("http:/") || string.startsWith("file:/") || string.startsWith("systemresource:/")) {
            string3 = string;
        } else {
            if (string.endsWith(".html")) {
                string = string.substring(0, string.indexOf(".html"));
            }
            this.debug("JarFileAnchor Finding: " + string);
            URL uRL = null;
            try {
                uRL = SystemResourceFinder.getHTMLDocument(string);
            }
            catch (MissingResourceException missingResourceException) {
                MessageLog.traceErr(SystemResourceFinder.format("noHelpAvailable"));
            }
            this.debug("JarFileAnchor URL: " + uRL);
            if (uRL != null) {
                string3 = uRL.toString();
            }
        }
        return this.JarFileAnchor(string3, string2);
    }

    private HelpResource JarFileAnchor(URL uRL) {
        String string = "";
        if (uRL != null) {
            string = uRL.toString();
        }
        String string2 = "";
        int n = string.indexOf("#");
        if (n >= 0) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        return this.JarFileAnchor(string, string2);
    }

    private HelpResource JarFileAnchor(String string, String string2) {
        this.debug("JarFileAnchor sURL:      " + string);
        HelpResource helpResource = new HelpResource();
        helpResource.hrAnchor = string2;
        if (string.endsWith(".jar")) {
            if (string.startsWith("file:/")) {
                string = string.substring(6);
            }
            while (string.startsWith("/")) {
                string = string.substring(1);
            }
            while (string.startsWith("\\")) {
                string = string.substring(1);
            }
            while (string.startsWith(this.separator)) {
                string = string.substring(1);
            }
            helpResource.hrJar = string;
            helpResource.hrFileURL = "";
        } else if (string.startsWith("file:/")) {
            string = string.substring(6);
            while (string.startsWith("/")) {
                string = string.substring(1);
            }
            while (string.startsWith("\\")) {
                string = string.substring(1);
            }
            while (string.startsWith(this.separator)) {
                string = string.substring(1);
            }
            if (!UIFramework.isApplet()) {
                this.m_osname = System.getProperty("os.name");
            }
            string = this.m_osname.toLowerCase().indexOf("linux") != -1 ? (string.indexOf(58) != -1 ? "file:///" : "file:/") + string : (string.indexOf(58) != -1 ? "file:///" : "file://") + string;
            helpResource.hrJar = "";
            helpResource.hrFileURL = string;
        } else if (string.startsWith("systemresource:")) {
            int n = string.indexOf("/+/");
            if (string.startsWith("systemresource:/FILE")) {
                int n2 = Integer.parseInt(string.substring(20, n));
                helpResource.hrJar = "";
                helpResource.hrFileURL = "file:///" + this.getClassPathN(n2) + string.substring(n + 2);
            } else if (string.startsWith("systemresource:/ZIP")) {
                int n3 = Integer.parseInt(string.substring(19, n));
                helpResource.hrJar = this.getClassPathN(n3);
                helpResource.hrFileURL = string.substring(n + 3);
            } else {
                this.debug("Unknown systemresource type:  '" + string + "'");
                helpResource.hrJar = "";
                helpResource.hrFileURL = "";
            }
        } else {
            this.debug("Other URL type '" + string + "'");
            if (string.startsWith("jar:")) {
                String string3;
                String string4 = string;
                int n = string4.indexOf("!");
                string4 = string4.substring(0, n);
                n = string4.lastIndexOf("/");
                string4 = string4.substring(n + 1);
                helpResource.hrID = this.helpID(string);
                helpResource.hrJar = string4;
                n = string4.indexOf("_");
                if (n != -1) {
                    string4 = string4.substring(0, n);
                    string4 = string4 + ".jar";
                }
                if (this.CheckForHelpSet(string3 = string4.substring(0, string4.lastIndexOf(".")) + ".hs")) {
                    helpResource.hrHelpSet = string3;
                }
            } else {
                helpResource.hrJar = "";
            }
            helpResource.hrFileURL = string;
        }
        this.debug("HelpResource  Jar:     " + helpResource.hrJar);
        this.debug("HelpResource  FileURL: " + helpResource.hrFileURL);
        this.debug("HelpResource  Anchor:  " + helpResource.hrAnchor);
        this.debug("HelpResource  ID:      " + helpResource.hrID);
        this.debug("HelpResource  HelpSet: " + helpResource.hrHelpSet);
        if (!this.m_helpSetSet) {
            this.m_hr = helpResource;
            this.m_helpSetSet = true;
        }
        return helpResource;
    }

    private String getClassPathN(int n) {
        int n2;
        int n3;
        String string = System.getProperty("path.separator");
        String string2 = System.getProperty("java.class.path");
        if (!string2.endsWith(string)) {
            string2 = string2 + string;
        }
        for (n3 = 0; n3 < n && (n2 = string2.indexOf(string)) >= 0; ++n3) {
            string2 = string2.substring(n2 + 1);
        }
        n3 = string2.indexOf(string);
        if (n3 >= 0) {
            string2 = string2.substring(0, n3);
        }
        if (string2.equals(".")) {
            string2 = System.getProperty("user.dir");
        }
        return string2;
    }

    public String getHome() {
        this.debug(" getHome URL: " + this.m_home.toString());
        return this.m_home;
    }

    public void setHome(URL uRL) {
        this.debug(" SetHome URL: " + uRL);
        this.m_home = uRL.toString();
    }

    public void setHome(String string) {
        this.debug(" SetHome home: " + string);
        this.m_home = string;
    }

    public void showHome() {
        this.debug("Show home: " + this.m_home);
        if (OpNavHelpBroker != null) {
            this.showPage(this.m_home);
        }
    }

    public void setIconImage(Image image) {
    }

    private boolean CheckForHelpSet(String string) {
        boolean bl = false;
        InputStream inputStream = null;
        if (string.equals("")) {
            return bl;
        }
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        inputStream = classLoader.getResourceAsStream(string);
        if (inputStream != null) {
            bl = true;
        }
        return bl;
    }

    private boolean CheckIfHelpSetMatches() {
        this.debug("CheckIfHelpSetMatches");
        boolean bl = false;
        bl = this.m_hs.toString().equals(OpNavHelpBroker.getHelpSet().toString());
        return bl;
    }

    private String getEncoding() {
        String string = "ISO-8859-1";
        BufferedReader bufferedReader = null;
        if (this.m_url == null) {
            return string;
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.m_url.openStream()));
            String string2 = bufferedReader.readLine();
            String string3 = "";
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            while (string2 != null) {
                string3 = string2.toLowerCase();
                n = string3.indexOf("charset");
                if (n != -1 && (n2 = string2.indexOf("=", n)) != -1 && (n3 = string2.indexOf("\"", n2)) != -1) {
                    string = string2.substring(n2 + 1, n3);
                    string = string.trim();
                    break;
                }
                string2 = bufferedReader.readLine();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public void setParentWindow(Window window) {
        if (window != null) {
            m_window = window;
        }
    }

    public static void setActivationWindow(Window window) {
        if (window != null) {
            m_window = window;
        }
    }

    public void setTitle(String string) {
        if (this.m_hs != null) {
            this.m_hs.setTitle(string);
        }
    }

    public void setJarFileName(String string) {
        this.m_sJarFileName = string;
        String string2 = "";
        string2 = !this.getJarFileName().equals("") ? this.getJarFileName() + ".hs" : "";
        if (this.CheckForHelpSet(string2)) {
            this.m_hr.hrHelpSet = string2;
        }
    }

    public String getJarFileName() {
        return this.m_sJarFileName;
    }

    private String helpID(String string) {
        string = string.indexOf(".html") != -1 ? string.substring(string.lastIndexOf("/") + 1, string.lastIndexOf(".")) : string.substring(string.lastIndexOf("/") + 1);
        return string.trim();
    }

    String newStyleHelpID(String string) {
        this.debug("newStyleHelpID: Creating a helpID from String: " + string);
        if (string.indexOf(".html") != -1) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        if (string.indexOf("!") != -1) {
            string = string.substring(string.lastIndexOf("!") + 2);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        string = string.replace('/', '.');
        string = string.trim();
        this.debug("newStylehelpID: Created helpID: " + string);
        return string;
    }

    public static void clearCache() {
        m_window = null;
        OpNavHelpBroker = null;
    }

    protected void finalize() {
        if (this.tempDir != null) {
            File file = new File(this.tempDir);
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2;
                if (stringArray[i].indexOf("hlptmp") == -1 || (file2 = new File(this.tempDir + this.separator + stringArray[i])) == null) continue;
                file2.delete();
            }
            this.debug("finalize: completed cleanup");
        }
    }

    private void debug(String string) {
        if (this.m_entryTrace) {
            System.out.println("HelpViewer: " + string);
        }
    }

    class HelpResource {
        String hrJar;
        String hrFileURL;
        String hrAnchor;
        String hrID;
        String hrHelpSet;

        public HelpResource(String string, String string2, String string3) {
            this.hrJar = string;
            this.hrFileURL = string2;
            this.hrAnchor = string3;
        }

        public HelpResource() {
            this.hrJar = "";
            this.hrFileURL = "";
            this.hrAnchor = "";
            this.hrID = "";
            this.hrHelpSet = "com/ibm/as400/ui/framework/java/default.hs";
        }
    }
}

