/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;
import javax.swing.SwingConstants;

class FormattedFlowLayout
implements LayoutManager2,
SwingConstants {
    Hashtable m_comptable = new Hashtable();
    int m_count = 0;
    int m_space = 10;
    int m_orient = 0;
    int m_align = 0;
    boolean m_equal = false;
    Insets m_insets;

    public FormattedFlowLayout(int n) {
        this.m_count = n;
        this.m_insets = new Insets(0, 0, 0, 0);
    }

    public void setOrientation(int n) {
        this.m_orient = n;
        this.resetAlignment();
    }

    public int getOrientation() {
        return this.m_orient;
    }

    public void setAlignment(int n) {
        this.m_align = n;
        this.resetAlignment();
    }

    public int getAlignment() {
        return this.m_align;
    }

    protected void resetAlignment() {
        if (this.m_orient == 0) {
            if (this.m_align == 2) {
                this.m_align = 1;
            } else if (this.m_align == 4) {
                this.m_align = 3;
            }
        } else if (this.m_align == 1) {
            this.m_align = 2;
        } else if (this.m_align == 3) {
            this.m_align = 4;
        }
    }

    public void setEqualSizeCells(boolean bl) {
        this.m_equal = bl;
    }

    public boolean isEqualSizeCells() {
        return this.m_equal;
    }

    public void setSpacing(int n) {
        this.m_space = n;
    }

    public int getSpacing() {
        return this.m_space;
    }

    public void setInsets(Insets insets) {
        this.m_insets = insets;
    }

    public Insets getInsets() {
        return new Insets(this.m_insets.top, this.m_insets.left, this.m_insets.bottom, this.m_insets.right);
    }

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.m_comptable.put(component, gridBagConstraints.clone());
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof GridBagConstraints) {
            this.setConstraints(component, (GridBagConstraints)object);
        } else if (!(object instanceof String) && object != null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a TableConstraint");
        }
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            int n2 = this.m_orient == 0 ? 1 : this.m_count;
            int n3 = this.m_orient == 1 ? 1 : this.m_count;
            Insets insets = container.getInsets();
            int n4 = insets.top + insets.bottom + this.m_insets.top + this.m_insets.bottom;
            int n5 = insets.left + insets.right + this.m_insets.left + this.m_insets.right;
            int n6 = 0;
            int n7 = 0;
            if (this.m_equal) {
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension = component.getMinimumSize();
                    if (n6 < dimension.width) {
                        n6 = dimension.width;
                    }
                    if (n7 >= dimension.height) continue;
                    n7 = dimension.height;
                }
                if (n == 0) {
                    n7 = 25;
                    n6 = 25;
                }
                return new Dimension(n5 + n6 * n3 + this.m_space * (n3 - 1), n4 + n7 * n2 + this.m_space * (n2 - 1));
            }
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                Dimension dimension = component.getMinimumSize();
                if (this.m_orient == 0) {
                    n6 += dimension.width;
                    if (n7 >= dimension.height) continue;
                    n7 = dimension.height;
                    continue;
                }
                n7 += dimension.height;
                if (n6 >= dimension.width) continue;
                n6 = dimension.width;
            }
            if (this.m_orient == 0) {
                n6 += (this.m_count - n) * 25;
            } else {
                n7 += (this.m_count - n) * 25;
            }
            return new Dimension(n5 + n6 + this.m_space * (n3 - 1), n4 + n7 + this.m_space * (n2 - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getComponentCount();
            int n2 = this.m_orient == 0 ? 1 : this.m_count;
            int n3 = this.m_orient == 1 ? 1 : this.m_count;
            Insets insets = container.getInsets();
            int n4 = insets.top + insets.bottom + this.m_insets.top + this.m_insets.bottom;
            int n5 = insets.left + insets.right + this.m_insets.left + this.m_insets.right;
            int n6 = 0;
            int n7 = 0;
            if (this.m_equal) {
                for (int i = 0; i < n; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension = component.getPreferredSize();
                    if (n6 < dimension.width) {
                        n6 = dimension.width;
                    }
                    if (n7 >= dimension.height) continue;
                    n7 = dimension.height;
                }
                if (n == 0) {
                    n7 = 25;
                    n6 = 25;
                }
                return new Dimension(n5 + n6 * n3 + this.m_space * (n3 - 1), n4 + n7 * n2 + this.m_space * (n2 - 1));
            }
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                Dimension dimension = component.getPreferredSize();
                if (this.m_orient == 0) {
                    n6 += dimension.width;
                    if (n7 >= dimension.height) continue;
                    n7 = dimension.height;
                    continue;
                }
                n7 += dimension.height;
                if (n6 >= dimension.width) continue;
                n6 = dimension.width;
            }
            if (this.m_orient == 0) {
                n6 += (this.m_count - n) * 25;
            } else {
                n7 += (this.m_count - n) * 25;
            }
            return new Dimension(n5 + n6 + this.m_space * (n3 - 1), n4 + n7 + this.m_space * (n2 - 1));
        }
    }

    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n = insets.top + insets.bottom + this.m_insets.top + this.m_insets.bottom;
            int n2 = insets.left + insets.right + this.m_insets.left + this.m_insets.right;
            int n3 = container.getComponentCount();
            int n4 = this.m_orient == 0 ? 1 : this.m_count;
            int n5 = this.m_orient == 1 ? 1 : this.m_count;
            int n6 = 0;
            int n7 = 0;
            if (this.m_equal) {
                if (this.m_orient == 0) {
                    n6 = (dimension.width - n2 - this.m_space * (this.m_count - 1)) / this.m_count;
                    n7 = dimension.height - n;
                } else {
                    n6 = dimension.width - n2;
                    n7 = (dimension.height - n - this.m_space * (this.m_count - 1)) / this.m_count;
                }
                for (int i = 0; i < n3; ++i) {
                    int n8;
                    int n9;
                    Component component = container.getComponent(i);
                    if (this.m_orient == 0) {
                        n9 = insets.left + this.m_insets.left + i * n6 + i * this.m_space;
                        n8 = insets.top + this.m_insets.top;
                    } else {
                        n9 = insets.left + this.m_insets.left;
                        n8 = insets.top + this.m_insets.top + i * n7 + i * this.m_space;
                    }
                    int n10 = n6;
                    int n11 = n7;
                    component.setBounds(n9, n8, n10, n11);
                }
            } else {
                int n12 = dimension.width - n2;
                int n13 = dimension.height - n;
                int n14 = insets.left + this.m_insets.left;
                int n15 = insets.top + this.m_insets.top;
                int n16 = insets.bottom + this.m_insets.bottom;
                int n17 = insets.right + this.m_insets.right;
                int n18 = n14 + (dimension.width - (n17 + n14)) / 2;
                int n19 = n15 + (dimension.height - (n15 + n16)) / 2;
                for (int i = 0; i < n3; ++i) {
                    Component component = container.getComponent(i);
                    Dimension dimension2 = component.getPreferredSize();
                    int n20 = dimension2.width;
                    int n21 = dimension2.height;
                    if (this.m_orient == 0) {
                        if (this.m_align == 1) {
                            component.setBounds(n14, n15, n20, n21);
                        } else if (this.m_align == 3) {
                            component.setBounds(n14, dimension.height - n21 - n16, n20, n21);
                        } else {
                            component.setBounds(n14, n19 - n21 / 2, n20, n21);
                        }
                        n14 += n20 + this.m_space;
                        continue;
                    }
                    if (this.m_align == 2) {
                        component.setBounds(n14, n15, n20, n21);
                    } else if (this.m_align == 4) {
                        component.setBounds(dimension.width - dimension2.width - n17, n15, n20, n21);
                    } else {
                        component.setBounds(n18 - n20 / 2, n15, n20, n21);
                    }
                    n15 += n21 + this.m_space;
                }
            }
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

