/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework;

import com.ibm.as400.ui.framework.AbortException;
import com.ibm.as400.ui.framework.FrameworkDefaults;
import com.ibm.as400.ui.framework.KeyDescriptor;
import com.ibm.as400.ui.framework.MenuDescriptor;
import com.ibm.as400.ui.framework.MenuItemDescriptor;
import com.ibm.as400.ui.framework.MessageLog;
import com.ibm.as400.ui.framework.PDMLSpecificationException;
import com.ibm.as400.ui.framework.PanelDefinitionsDescriptor;
import com.ibm.as400.ui.framework.ParseException;
import com.ibm.as400.ui.framework.ResourceLoader;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.XMLPanelDefinition;
import com.ibm.as400.ui.framework.XMLSAXErrorHandler;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

public class XMLMenuDefinition
implements Serializable,
DocumentHandler {
    private transient String m_baseName;
    private transient Locale m_locale;
    private transient String m_menuName;
    private transient ResourceBundle m_bundle;
    private transient String m_documentName;
    private static transient Hashtable m_virtualKeyDictionary = new Hashtable();
    private static transient Hashtable m_modifierDictionary = new Hashtable();
    private static transient boolean m_bElementTrace = false;
    private transient PDMLSpecificationException m_pdmlException;
    private transient int m_nestLevel = 0;
    private transient Hashtable m_menuDictionary = new Hashtable();
    private transient String m_sxml = null;
    private PanelDefinitionsDescriptor m_panelDefinitions = new PanelDefinitionsDescriptor();
    private MenuDescriptor m_menuDescriptor = new MenuDescriptor();
    private Vector m_menuItemDescriptors = new Vector();
    private Stack m_stack = null;
    private String m_chars = "";
    static final long serialVersionUID = -7143159049147275826L;
    private boolean found = false;
    private Stack curMenuItem = new Stack();

    public static void main(String[] stringArray) {
        System.setErr(System.out);
        m_bElementTrace = true;
        if (stringArray.length == 2) {
            XMLMenuDefinition xMLMenuDefinition;
            try {
                xMLMenuDefinition = new XMLMenuDefinition(stringArray[0], null, stringArray[1]);
            }
            catch (ParseException parseException) {
                parseException.reportErrors();
                return;
            }
            catch (PDMLSpecificationException pDMLSpecificationException) {
                pDMLSpecificationException.reportErrors();
                return;
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println(missingResourceException);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            xMLMenuDefinition.dump();
        } else {
            System.out.println("Arguments are: <resource bundle name> <menu name>");
        }
    }

    public XMLMenuDefinition(String string, Locale locale, String string2) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_locale = locale = ResourceLoader.getOpNavLocale(locale);
        this.m_menuName = string2;
        this.m_documentName = locale != null ? this.m_baseName + "_" + locale.toString() + ".pdml" : this.m_baseName + ".pdml";
        try {
            this.m_bundle = FrameworkDefaults.m_resourceMode == 1 ? (locale != null ? ResourceBundle.getBundle(string, locale) : ResourceBundle.getBundle(string)) : SystemResourceFinder.getUncachedBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            Object[] objectArray = new Object[]{string};
            throw new MissingResourceException(SystemResourceFinder.format("resourceBundleNotFound", objectArray), missingResourceException.getClassName(), missingResourceException.getKey());
        }
        this.parseXML(false);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLMenuDefinition(String string, Locale locale) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_locale = locale = ResourceLoader.getOpNavLocale(locale);
        this.m_documentName = locale != null ? this.m_baseName + "_" + locale.toString() + ".pdml" : this.m_baseName + ".pdml";
        try {
            this.m_bundle = locale != null ? ResourceBundle.getBundle(string, locale) : ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            Object[] objectArray = new Object[]{string};
            throw new MissingResourceException(SystemResourceFinder.format("resourceBundleNotFound", objectArray), missingResourceException.getClassName(), missingResourceException.getKey());
        }
        this.parseXML(false);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLMenuDefinition(String string, ResourceBundle resourceBundle, String string2, String string3, PanelDefinitionsDescriptor panelDefinitionsDescriptor) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        this.m_baseName = string;
        this.m_bundle = resourceBundle;
        this.m_documentName = this.addLocale(this.m_baseName, panelDefinitionsDescriptor.m_localeString) + ".pdml";
        this.m_panelDefinitions = panelDefinitionsDescriptor;
        this.m_menuName = string2;
        this.m_sxml = string3;
        this.parseXML(true);
        if (this.m_pdmlException != null) {
            throw this.m_pdmlException;
        }
    }

    public XMLMenuDefinition(String string) {
        this.m_menuName = string;
        this.m_menuDescriptor.m_name = string;
    }

    public PanelDefinitionsDescriptor getPanelDefinitions() {
        return this.m_panelDefinitions;
    }

    public MenuDescriptor getMenu() {
        return this.m_menuDescriptor;
    }

    public Vector getMenuItems() {
        return this.m_menuItemDescriptors;
    }

    public String toString() {
        return this.getClass().getName() + "[baseName=" + this.m_baseName + ",locale=" + this.m_locale + ",menuName=" + this.m_menuName + "]";
    }

    private String addLocale(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string2.trim().length() == 0) {
            return string;
        }
        return string + "_" + string2;
    }

    public void dump() {
        System.out.println(this.m_panelDefinitions);
        System.out.println(this.m_menuDescriptor);
        Enumeration enumeration = this.m_menuItemDescriptors.elements();
        while (enumeration.hasMoreElements()) {
            MenuItemDescriptor menuItemDescriptor = (MenuItemDescriptor)enumeration.nextElement();
            System.out.println(menuItemDescriptor);
            if (menuItemDescriptor.m_children == null) continue;
            this.dumpChildren(menuItemDescriptor);
        }
    }

    private void dumpChildren(MenuItemDescriptor menuItemDescriptor) {
        if (menuItemDescriptor.m_children == null) {
            return;
        }
        ++this.m_nestLevel;
        for (int i = 0; i < menuItemDescriptor.m_children.size(); ++i) {
            MenuItemDescriptor menuItemDescriptor2 = (MenuItemDescriptor)menuItemDescriptor.m_children.elementAt(i);
            for (int j = 0; j < this.m_nestLevel; ++j) {
                System.out.print(">");
            }
            System.out.println(menuItemDescriptor2);
            if (menuItemDescriptor2.m_children == null) continue;
            this.dumpChildren(menuItemDescriptor2);
        }
        --this.m_nestLevel;
    }

    private void parseXML(boolean bl) throws MissingResourceException, IOException, ParseException, PDMLSpecificationException {
        InputStream inputStream = SystemResourceFinder.getPDMLHeader();
        InputStream inputStream2 = null;
        inputStream2 = !bl ? SystemResourceFinder.getPDMLDocument(this.m_baseName, this.m_locale) : new BufferedInputStream(new FileInputStream(this.m_sxml));
        this.m_documentName = this.m_baseName + SystemResourceFinder.getLastDocumentLocale() + ".pdml";
        XMLSAXErrorHandler xMLSAXErrorHandler = new XMLSAXErrorHandler(this.m_documentName, SystemResourceFinder.getHeaderLineCount());
        Object object = XMLPanelDefinition.getParser(this, xMLSAXErrorHandler);
        SequenceInputStream sequenceInputStream = new SequenceInputStream(inputStream, inputStream2);
        InputSource inputSource = new InputSource(sequenceInputStream);
        XMLPanelDefinition.introspectMethod(object, "parse", new Object[]{inputSource}, new Class[]{inputSource.getClass()}, this.m_baseName);
        sequenceInputStream.close();
        ParseException parseException = xMLSAXErrorHandler.getException();
        if (parseException != null) {
            throw parseException;
        }
    }

    private MenuItemDescriptor findItem(String string, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            MenuItemDescriptor menuItemDescriptor;
            MenuItemDescriptor menuItemDescriptor2 = (MenuItemDescriptor)vector.elementAt(i);
            if (menuItemDescriptor2.m_name != null && menuItemDescriptor2.m_name.equals(string)) {
                return menuItemDescriptor2;
            }
            if (menuItemDescriptor2.m_children == null || (menuItemDescriptor = this.findItem(string, menuItemDescriptor2.m_children)) == null) continue;
            return menuItemDescriptor;
        }
        return null;
    }

    private char checkMnemonic(String string) {
        char c = '\u0000';
        int n = string.indexOf(37);
        while (n != -1 && n < string.length() - 1) {
            if (string.charAt(n + 1) != '%') {
                c = string.charAt(n + 1);
                break;
            }
            if (n + 1 >= string.length()) break;
            string = string.substring(n + 2);
            n = string.indexOf(37);
        }
        return c;
    }

    private String removeMnemonic(String string) {
        String string2 = "";
        int n = string.indexOf(37);
        while (n != -1 && n < string.length() - 1) {
            if (string.charAt(n + 1) != '%') {
                string = string2 = string2 + string.substring(0, n) + string.substring(n + 1);
                string2 = "";
                break;
            }
            if (n + 1 >= string.length()) break;
            string2 = string2 + string.substring(0, n + 1);
            string = string.substring(n + 2);
            n = string.indexOf(37);
        }
        if (!string2.equals("")) {
            string = string2 + string;
        }
        return string;
    }

    private void processError(String string) {
        if (this.m_pdmlException == null) {
            Object[] objectArray = new Object[]{this.m_documentName};
            this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
        }
        this.m_pdmlException.addMessage(string);
    }

    private void processError(Throwable throwable, String string) {
        Object[] objectArray;
        if (this.m_pdmlException == null) {
            objectArray = new Object[]{this.m_documentName};
            this.m_pdmlException = new PDMLSpecificationException(SystemResourceFinder.format("failedToValidate", objectArray));
        }
        if (throwable instanceof NumberFormatException) {
            objectArray = new Object[]{throwable.getMessage(), string};
            this.m_pdmlException.addMessage(SystemResourceFinder.format("valueNotNumeric", objectArray));
        } else {
            objectArray = new Object[]{throwable.toString(), string};
            this.m_pdmlException.addMessage(SystemResourceFinder.format("unknownValidationError", objectArray));
        }
    }

    public void startDocument() {
        this.m_stack = new Stack();
    }

    public void endDocument() {
        if (this.m_menuDescriptor.m_name == null) {
            if (this.m_locale == null) {
                Object[] objectArray = new Object[]{this.m_menuName, this.m_baseName};
                throw new MissingResourceException(SystemResourceFinder.format("menuNotFound", objectArray), this.m_baseName, this.m_menuName);
            }
            Object[] objectArray = new Object[]{this.m_menuName, new String(this.m_baseName + "_" + this.m_locale)};
            throw new MissingResourceException(SystemResourceFinder.format("menuNotFound", objectArray), this.m_baseName + "_" + this.m_locale, this.m_menuName);
        }
        this.m_stack = null;
    }

    public void startElement(String string, AttributeList attributeList) {
        if (this.found) {
            this.debug("<" + string + ">");
        }
        if (!this.found) {
            if (string.equalsIgnoreCase("PDML")) {
                this.m_panelDefinitions.m_baseName = this.m_baseName;
                this.debug("Base name: " + this.m_panelDefinitions.m_baseName);
                this.m_panelDefinitions.m_locale = this.m_locale;
                this.m_panelDefinitions.m_localeString = SystemResourceFinder.getLastDocumentLocale();
                this.debug("Locale string: " + this.m_panelDefinitions.m_localeString);
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    Object[] objectArray;
                    String string2 = attributeList.getName(i);
                    String string3 = attributeList.getValue(i).trim();
                    if (string2.equalsIgnoreCase("VERSION")) {
                        this.m_panelDefinitions.m_version = string3;
                        this.debug("Version: " + this.m_panelDefinitions.m_version);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("SOURCE")) {
                        this.m_panelDefinitions.m_source = string3.toUpperCase();
                        this.debug("Source: " + this.m_panelDefinitions.m_source);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("BASESCREENSIZE")) continue;
                    String string4 = string3;
                    int n = string4.indexOf(120);
                    if (n == -1) {
                        this.debug("Base Screen Size '" + string4 + "' invalid");
                        objectArray = new Object[]{string4, string2.toString()};
                        this.processError(SystemResourceFinder.format("baseScreenSizeNotValid", objectArray));
                        continue;
                    }
                    objectArray = string4.substring(0, n).trim();
                    String string5 = string4.substring(n + 1).trim();
                    try {
                        int n2 = Integer.parseInt((String)objectArray);
                        int n3 = Integer.parseInt(string5);
                        this.m_panelDefinitions.m_baseScreenSize.setSize(n2, n3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.debug("Base Screen Size '" + string4 + "' invalid");
                        this.processError(numberFormatException, string2 + "= " + string3);
                        continue;
                    }
                    this.debug("Storing base screen size: " + string4);
                }
            } else if (string.equalsIgnoreCase("MENU")) {
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string6 = attributeList.getName(i);
                    String string7 = attributeList.getValue(i).trim();
                    if (string6.equalsIgnoreCase("NAME")) {
                        if (string7 == null || !string7.equals(this.m_menuName)) continue;
                        this.found = true;
                        this.m_menuDescriptor.m_name = string7;
                        this.m_stack.push(this.m_menuDescriptor);
                        continue;
                    }
                    if (!string6.equalsIgnoreCase("TYPE")) continue;
                    this.m_menuDescriptor.m_type = string7.toUpperCase();
                }
            }
        } else if (string.equalsIgnoreCase("TITLE") || string.equalsIgnoreCase("FLYOVER") || string.equalsIgnoreCase("ACTION") || string.equalsIgnoreCase("ITEMLINK")) {
            this.m_stack.push(string);
        } else if (string.equalsIgnoreCase("SEPARATOR")) {
            MenuItemDescriptor menuItemDescriptor = new MenuItemDescriptor();
            if (!this.m_stack.empty() && this.m_stack.peek() instanceof MenuItemDescriptor) {
                MenuItemDescriptor menuItemDescriptor2 = (MenuItemDescriptor)this.m_stack.peek();
                if (menuItemDescriptor2.m_children == null) {
                    menuItemDescriptor2.m_children = new Vector();
                }
                menuItemDescriptor2.m_children.add(menuItemDescriptor);
            } else {
                this.m_menuItemDescriptors.addElement(menuItemDescriptor);
            }
            this.m_stack.push(menuItemDescriptor);
        } else if (string.equalsIgnoreCase("MENUITEM")) {
            MenuItemDescriptor menuItemDescriptor = new MenuItemDescriptor();
            for (int i = 0; i < attributeList.getLength(); ++i) {
                String string8 = attributeList.getName(i);
                String string9 = attributeList.getValue(i).trim();
                if (string8.equalsIgnoreCase("NAME")) {
                    menuItemDescriptor.m_name = string9;
                    continue;
                }
                if (string8.equalsIgnoreCase("TYPE")) {
                    menuItemDescriptor.m_type = string9.toUpperCase();
                    continue;
                }
                if (string8.equalsIgnoreCase("SELECTED")) {
                    menuItemDescriptor.m_selected = string9.equalsIgnoreCase("YES");
                    continue;
                }
                if (string8.equalsIgnoreCase("DISABLED")) {
                    menuItemDescriptor.m_disabled = string9.equalsIgnoreCase("YES");
                    continue;
                }
                if (!string8.equalsIgnoreCase("DEFAULT")) continue;
                menuItemDescriptor.m_default = string9.equalsIgnoreCase("YES");
            }
            if (!this.m_stack.empty() && this.m_stack.peek() instanceof MenuItemDescriptor) {
                MenuItemDescriptor menuItemDescriptor3 = (MenuItemDescriptor)this.m_stack.peek();
                if (menuItemDescriptor3.m_children == null) {
                    menuItemDescriptor3.m_children = new Vector();
                }
                menuItemDescriptor3.m_children.add(menuItemDescriptor);
            } else {
                this.m_menuItemDescriptors.addElement(menuItemDescriptor);
            }
            this.curMenuItem.push(menuItemDescriptor);
            this.m_stack.push(menuItemDescriptor);
            this.debug("Storing menu item name: " + menuItemDescriptor.m_name);
        } else if (string.equalsIgnoreCase("ICON")) {
            MenuItemDescriptor menuItemDescriptor = (MenuItemDescriptor)this.m_stack.peek();
            for (int i = 0; i < attributeList.getLength(); ++i) {
                String string10 = attributeList.getName(i);
                String string11 = attributeList.getValue(i).trim();
                if (string10.equalsIgnoreCase("POSITION")) {
                    menuItemDescriptor.m_iconPosition = string11.toUpperCase();
                    this.debug("Storing icon position: " + menuItemDescriptor.m_iconPosition);
                    continue;
                }
                if (!string10.equalsIgnoreCase("VPOSITION")) continue;
                menuItemDescriptor.m_vIconPosition = string11.toUpperCase();
                this.debug("Storing vertical icon position: " + menuItemDescriptor.m_vIconPosition);
            }
            this.m_stack.push(string);
        } else if (string.equalsIgnoreCase("ACCELERATOR")) {
            int n;
            MenuItemDescriptor menuItemDescriptor = (MenuItemDescriptor)this.m_stack.peek();
            String string12 = null;
            String string13 = null;
            for (n = 0; n < attributeList.getLength(); ++n) {
                String string14 = attributeList.getName(n);
                String string15 = attributeList.getValue(n).trim();
                if (string14.equalsIgnoreCase("KEY")) {
                    string12 = string15.toUpperCase();
                    continue;
                }
                if (!string14.equalsIgnoreCase("MODIFIER")) continue;
                string13 = string15.trim().toUpperCase();
            }
            n = string12.length() == 1 ? (int)string12.charAt(0) : (Integer)m_virtualKeyDictionary.get(string12);
            int n4 = (Integer)m_modifierDictionary.get(string13);
            menuItemDescriptor.m_accelerator = new KeyDescriptor(n, n4);
            menuItemDescriptor.m_accelerator.setStringValues(string12, string13);
            this.debug("Storing menu item accelerator: " + menuItemDescriptor.m_accelerator);
            this.m_stack.push(string);
        }
    }

    public void endElement(String string) {
        if (!this.m_chars.equals("")) {
            try {
                this.writeChars();
            }
            catch (Exception exception) {
                throw new AbortException(exception);
            }
            this.m_chars = "";
        }
        if (this.found) {
            if (this.m_stack.peek() instanceof MenuItemDescriptor && !this.curMenuItem.isEmpty()) {
                this.curMenuItem.pop();
            }
            this.m_stack.pop();
            if (string.equalsIgnoreCase("MENU")) {
                this.found = false;
                throw new AbortException();
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (!this.found) {
            return;
        }
        if (!(this.m_stack.peek() instanceof String)) {
            this.debug("STRING expected on the stack");
            return;
        }
        this.m_chars = this.m_chars + new String(cArray, n, n2).trim();
    }

    private void writeChars() throws IOException, ParseException, PDMLSpecificationException {
        Object object;
        String string = this.m_chars;
        String string2 = (String)this.m_stack.pop();
        if (string2.equalsIgnoreCase("ITEMLINK")) {
            Serializable serializable;
            Object[] objectArray;
            object = string;
            int n = ((String)object).indexOf(46);
            if (n == -1) {
                objectArray = new Object[]{object};
                this.processError(SystemResourceFinder.format("menuLinkNotValid", objectArray));
            }
            objectArray = ((String)object).substring(0, n);
            String string3 = ((String)object).substring(n + 1);
            Vector vector = (Vector)this.m_menuDictionary.get(objectArray);
            if (vector == null) {
                serializable = null;
                serializable = this.m_sxml == null ? new XMLMenuDefinition(this.m_baseName, this.m_locale, (String)objectArray) : new XMLMenuDefinition(this.m_baseName, this.m_bundle, (String)objectArray, this.m_sxml, this.m_panelDefinitions);
                vector = ((XMLMenuDefinition)serializable).getMenuItems();
                this.m_menuDictionary.put(objectArray, vector);
            }
            if ((serializable = this.findItem(string3, vector)) != null) {
                ((MenuItemDescriptor)serializable).m_itemLink = object;
                if (!this.m_stack.isEmpty() && this.m_stack.peek() instanceof MenuItemDescriptor) {
                    MenuItemDescriptor menuItemDescriptor = (MenuItemDescriptor)this.m_stack.peek();
                    if (menuItemDescriptor.m_children == null) {
                        menuItemDescriptor.m_children = new Vector();
                    }
                    menuItemDescriptor.m_children.add(serializable);
                } else {
                    this.m_menuItemDescriptors.addElement(serializable);
                }
                this.debug("Linking to item: " + (String)object);
            } else {
                Object[] objectArray2 = new Object[]{string3, objectArray};
                MessageLog.traceErr(SystemResourceFinder.format("menuItemNotFound", objectArray2));
            }
        }
        if (string2.equalsIgnoreCase("TITLE")) {
            if (this.m_stack.peek() instanceof MenuItemDescriptor) {
                object = (MenuItemDescriptor)this.m_stack.peek();
                ((MenuItemDescriptor)object).m_title = string;
                ((MenuItemDescriptor)object).m_titleBundle = string;
                try {
                    ((MenuItemDescriptor)object).m_title = this.m_bundle.getString(((MenuItemDescriptor)object).m_title);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                char c = this.checkMnemonic(((MenuItemDescriptor)object).m_title);
                this.debug("Storing menu item title: " + ((MenuItemDescriptor)object).m_title);
                if (c != '\u0000') {
                    ((MenuItemDescriptor)object).m_title = this.removeMnemonic(((MenuItemDescriptor)object).m_title);
                    ((MenuItemDescriptor)object).m_mnemonic = c;
                    this.debug("Storing menu item mnemonic: " + ((MenuItemDescriptor)object).m_mnemonic);
                }
            } else if (this.m_stack.peek() instanceof MenuDescriptor) {
                this.m_menuDescriptor.m_title = string;
                this.m_menuDescriptor.m_titleBundle = string;
                try {
                    this.m_menuDescriptor.m_title = this.m_bundle.getString(this.m_menuDescriptor.m_titleBundle);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                char c = this.checkMnemonic(this.m_menuDescriptor.m_title);
                this.debug("Storing menu title: " + this.m_menuDescriptor.m_title);
                if (c != '\u0000') {
                    this.m_menuDescriptor.m_title = this.removeMnemonic(this.m_menuDescriptor.m_title);
                    this.m_menuDescriptor.m_mnemonic = c;
                    this.debug("Storing menu mnemonic: " + this.m_menuDescriptor.m_mnemonic);
                }
            } else {
                this.debug("TITLE: invalid item on stack");
            }
        }
        if (string2.equalsIgnoreCase("ICON")) {
            if (this.m_stack.peek() instanceof MenuItemDescriptor) {
                ((MenuItemDescriptor)this.m_stack.peek()).m_icon = string;
                try {
                    ((MenuItemDescriptor)this.m_stack.peek()).m_icon = this.m_bundle.getString(((MenuItemDescriptor)this.m_stack.peek()).m_icon);
                }
                catch (MissingResourceException missingResourceException) {}
            } else if (this.m_stack.peek() instanceof MenuDescriptor) {
                ((MenuDescriptor)this.m_stack.peek()).m_icon = string;
                try {
                    ((MenuDescriptor)this.m_stack.peek()).m_icon = this.m_bundle.getString(((MenuDescriptor)this.m_stack.peek()).m_icon);
                }
                catch (MissingResourceException missingResourceException) {}
            } else {
                this.debug("ICON: invalid item on stack");
            }
        }
        if (string2.equalsIgnoreCase("FLYOVER")) {
            object = (MenuItemDescriptor)this.m_stack.peek();
            ((MenuItemDescriptor)object).m_flyover = string;
            ((MenuItemDescriptor)object).m_flyoverBundle = string;
            try {
                ((MenuItemDescriptor)object).m_flyover = this.m_bundle.getString(((MenuItemDescriptor)object).m_flyoverBundle);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.debug("Storing menu item flyover: " + ((MenuItemDescriptor)object).m_flyover);
        }
        if (string2.equalsIgnoreCase("ACTION")) {
            object = (MenuItemDescriptor)this.m_stack.peek();
            ((MenuItemDescriptor)object).m_action = string;
            this.debug("Storing menu action: " + ((MenuItemDescriptor)object).m_action);
        }
        this.m_stack.push(string2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    public void skippedEntity(String string) {
    }

    private void debug(String string) {
        if (m_bElementTrace) {
            System.out.println("XMLMenuDefinition: " + string);
        }
    }

    public String getMenuName() {
        return this.m_menuName;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }

    static {
        m_virtualKeyDictionary.put("ESC", new Integer(27));
        m_virtualKeyDictionary.put("PAUSE", new Integer(19));
        m_virtualKeyDictionary.put("BACKSPACE", new Integer(8));
        m_virtualKeyDictionary.put("INSERT", new Integer(155));
        m_virtualKeyDictionary.put("HOME", new Integer(36));
        m_virtualKeyDictionary.put("PAGEUP", new Integer(33));
        m_virtualKeyDictionary.put("TAB", new Integer(9));
        m_virtualKeyDictionary.put("DELETE", new Integer(127));
        m_virtualKeyDictionary.put("END", new Integer(35));
        m_virtualKeyDictionary.put("PAGEDOWN", new Integer(34));
        m_virtualKeyDictionary.put("ENTER", new Integer(10));
        m_virtualKeyDictionary.put("SPACE", new Integer(32));
        m_virtualKeyDictionary.put("UP", new Integer(38));
        m_virtualKeyDictionary.put("LEFT", new Integer(37));
        m_virtualKeyDictionary.put("DOWN", new Integer(40));
        m_virtualKeyDictionary.put("RIGHT", new Integer(39));
        m_virtualKeyDictionary.put("F1", new Integer(112));
        m_virtualKeyDictionary.put("F2", new Integer(113));
        m_virtualKeyDictionary.put("F3", new Integer(114));
        m_virtualKeyDictionary.put("F4", new Integer(115));
        m_virtualKeyDictionary.put("F5", new Integer(116));
        m_virtualKeyDictionary.put("F6", new Integer(117));
        m_virtualKeyDictionary.put("F7", new Integer(118));
        m_virtualKeyDictionary.put("F8", new Integer(119));
        m_virtualKeyDictionary.put("F9", new Integer(120));
        m_virtualKeyDictionary.put("F10", new Integer(121));
        m_virtualKeyDictionary.put("F11", new Integer(122));
        m_virtualKeyDictionary.put("F12", new Integer(123));
        m_modifierDictionary.put("NONE", new Integer(0));
        m_modifierDictionary.put("CTRL", new Integer(2));
        m_modifierDictionary.put("ALT", new Integer(8));
        m_modifierDictionary.put("SHIFT", new Integer(1));
        m_modifierDictionary.put("CTRL-ALT", new Integer(10));
        m_modifierDictionary.put("CTRL-SHIFT", new Integer(3));
        m_modifierDictionary.put("ALT-SHIFT", new Integer(9));
        m_modifierDictionary.put("CTRL-ALT-SHIFT", new Integer(11));
    }
}

